/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jigcell.sbml2.SBase;
import jigcell.sbml2.SBaseId;
import jigcell.sbml2.Unit;
import jigcell.sbml2.XMLPrinter;

public final class UnitDefinition
extends SBaseId {
    private final List units;
    private final SBase unitsElement = new SBase();

    public static boolean isValidAreaUnit(UnitDefinition areaUnit) {
        if (areaUnit == null) {
            return false;
        }
        String id = areaUnit.getId();
        if (id.equals("area")) {
            return true;
        }
        List units = areaUnit.getUnits();
        if (units.size() != 1) {
            return false;
        }
        Unit unit = (Unit)units.get(0);
        return unit.getKindName().equals("metre") && unit.getExponent() == 2;
    }

    public static boolean isValidLengthUnit(UnitDefinition lengthUnit) {
        if (lengthUnit == null) {
            return false;
        }
        String id = lengthUnit.getId();
        if (id.equals("length")) {
            return true;
        }
        List units = lengthUnit.getUnits();
        if (units.size() != 1) {
            return false;
        }
        Unit unit = (Unit)units.get(0);
        return unit.getKindName().equals("metre") && unit.getExponent() == 1;
    }

    public static boolean isValidSpatialSizeUnit(UnitDefinition spatialSizeUnit, int spatialDimensions) {
        if (spatialSizeUnit == null) {
            return false;
        }
        switch (spatialDimensions) {
            case 0: {
                return UnitDefinition.isValidSubstanceUnit(spatialSizeUnit);
            }
            case 1: {
                return UnitDefinition.isValidLengthUnit(spatialSizeUnit);
            }
            case 2: {
                return UnitDefinition.isValidAreaUnit(spatialSizeUnit);
            }
            case 3: {
                return UnitDefinition.isValidVolumeUnit(spatialSizeUnit);
            }
        }
        return false;
    }

    public static boolean isValidSubstanceUnit(UnitDefinition substanceUnit) {
        if (substanceUnit == null) {
            return false;
        }
        String id = substanceUnit.getId();
        if (id.equals("substance") || id.equals("moles") || id.equals("item")) {
            return true;
        }
        List units = substanceUnit.getUnits();
        if (units.size() != 1) {
            return false;
        }
        Unit unit = (Unit)units.get(0);
        return (unit.getKindName().equals("moles") || unit.getKindName().equals("item")) && unit.getExponent() == 1;
    }

    public static boolean isValidTimeUnit(UnitDefinition timeUnit) {
        if (timeUnit == null) {
            return false;
        }
        String id = timeUnit.getId();
        if (id.equals("time") || id.equals("second")) {
            return true;
        }
        List units = timeUnit.getUnits();
        if (units.size() != 1) {
            return false;
        }
        Unit unit = (Unit)units.get(0);
        return unit.getKindName().equals("second") && unit.getExponent() == 1;
    }

    public static boolean isValidVolumeUnit(UnitDefinition volumeUnit) {
        if (volumeUnit == null) {
            return false;
        }
        String id = volumeUnit.getId();
        if (id.equals("volume")) {
            return true;
        }
        List units = volumeUnit.getUnits();
        if (units.size() != 1) {
            return false;
        }
        Unit unit = (Unit)units.get(0);
        return unit.getKindName().equals("metre") && unit.getExponent() == 3 || unit.getKindName().equals("litre") && unit.getExponent() == 1;
    }

    public UnitDefinition() {
        this(null, null);
    }

    public UnitDefinition(UnitDefinition definition) {
        this(definition.getId(), definition.isNameSet() ? definition.getName() : null);
        Iterator iterator = definition.getUnits().iterator();
        while (iterator.hasNext()) {
            Unit unit = (Unit)iterator.next();
            if (unit == null) continue;
            this.addUnit(new Unit(unit));
        }
    }

    public UnitDefinition(String id, String name) {
        super(id, name);
        this.units = new ArrayList();
    }

    public void addUnit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        this.units.add(unit);
    }

    public SBase getUnitsElement() {
        return this.unitsElement;
    }

    public List getUnits() {
        return this.units;
    }

    protected XMLPrinter print(XMLPrinter parent) {
        return this.print(parent, "unitDefinition");
    }

    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        printer.addElementList(this.getUnitsElement(), "listOfUnits", this.getUnits());
        return printer;
    }
}

