/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.math;

import java.io.PrintStream;
import java.io.StringReader;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jigcell.sbml2.math.MathElement;
import jigcell.sbml2.math.SBMLNode;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MathMLConvertorSAX
extends DefaultHandler {
    private static Hashtable functions = new Hashtable();
    private static String mathML;
    private boolean isLambda;
    private boolean isRatelaw;
    private boolean lambdaGiven;
    private Hashtable hashTable = new Hashtable();
    private int BVARMODE = 16;
    private int CIMODE = 2;
    private int CNMODE = 1;
    private int CSYMBOLMODE = 4;
    private int DELAYMODE = 8;
    private int ENOTATION = 32;
    private int ENOTATIONSEP = 256;
    private int INTEGER = 64;
    private int INTEGERSEP = 512;
    private int NORMAL = 0;
    private int RATIONAL = 128;
    private int RATIONALSEP = 1024;
    private int argumentNum = 1;
    private int mode = this.NORMAL;
    private int numArgumentsExpected = 0;
    private SBMLNode currentNode;
    private SBMLNode root;
    private String type = "";

    public MathMLConvertorSAX() {
    }

    public MathMLConvertorSAX(String mathML, boolean isLambda, boolean isRatelaw) throws Exception {
        MathMLConvertorSAX.mathML = mathML;
        this.isRatelaw = isRatelaw;
        this.root = null;
        this.currentNode = null;
        this.isLambda = isLambda;
        if (isLambda) {
            if (mathML.startsWith("<lambda") && !mathML.endsWith("</lambda>")) {
                mathML = mathML + "</lambda>";
            } else if (mathML.startsWith("<math:lambda") && !mathML.endsWith("</math:lambda>")) {
                mathML = mathML + "</math:lambda>";
            }
        }
        if (mathML.startsWith("null")) {
            mathML = mathML.substring(4);
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(false);
        spf.setValidating(false);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.setErrorHandler(new MyErrorHandler(System.err));
        InputSource source = new InputSource(new StringReader(mathML));
        xmlReader.parse(source);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String s = new String(ch, start, length);
            if (s.trim().length() != 0 || s == null) {
                String trimmed = s.trim();
                if (this.mode == this.CNMODE || (this.mode & this.CNMODE) == this.CNMODE) {
                    if (this.mode == this.CNMODE + this.RATIONALSEP) {
                        trimmed = this.type + "/" + trimmed;
                    } else if (this.mode == this.CNMODE + this.ENOTATIONSEP) {
                        trimmed = this.type + "e" + trimmed;
                    }
                    if (this.mode == this.CNMODE + this.RATIONAL) {
                        this.type = trimmed;
                        this.mode = this.CNMODE + this.RATIONALSEP;
                    } else if (this.mode == this.CNMODE + this.ENOTATION) {
                        this.type = trimmed;
                        this.mode = this.CNMODE + this.ENOTATIONSEP;
                    } else if (this.isLambda && !this.lambdaGiven) {
                        this.lambdaGiven = true;
                        SBMLNode n = new SBMLNode(this.currentNode);
                        n.setElement(new MathElement(trimmed));
                        this.currentNode.addChild(n);
                    } else if (this.currentNode != null) {
                        SBMLNode n = new SBMLNode(this.currentNode);
                        n.setElement(new MathElement(trimmed));
                        this.currentNode.addChild(n);
                    } else {
                        this.currentNode = this.root = new SBMLNode(new MathElement());
                        MathElement m = new MathElement(trimmed);
                        this.currentNode.setElement(m);
                    }
                } else if (this.mode == this.CIMODE || this.mode == this.BVARMODE + this.CIMODE) {
                    if (this.mode == this.BVARMODE + this.CIMODE) {
                        if (this.isLambda) {
                            String argument = trimmed;
                            String argument2 = "A" + this.argumentNum;
                            ++this.argumentNum;
                            if (!this.isRatelaw) {
                                this.hashTable.put(argument, argument2);
                            } else {
                                this.hashTable.put(argument, argument);
                            }
                        }
                    } else if (this.isLambda && !this.lambdaGiven) {
                        String argument = (String)this.hashTable.get(trimmed);
                        if (this.currentNode != null) {
                            SBMLNode n = new SBMLNode(this.currentNode);
                            n.setElement(new MathElement(argument));
                            this.currentNode.addChild(n);
                        } else {
                            this.currentNode = this.root = new SBMLNode(new MathElement(argument));
                        }
                    } else if (functions.containsKey(trimmed)) {
                        this.currentNode.setElement(new MathElement(trimmed));
                    } else if (this.currentNode != null) {
                        if (this.currentNode.getElement() == null) {
                            this.currentNode.setElement(new MathElement(trimmed));
                        } else {
                            SBMLNode n = new SBMLNode(this.currentNode);
                            n.setElement(new MathElement(trimmed));
                            this.currentNode.addChild(n);
                        }
                    } else {
                        this.root = this.currentNode = new SBMLNode(new MathElement());
                        this.currentNode.setElement(new MathElement(trimmed));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("math:apply") || qName.equals("apply")) {
            this.currentNode = this.currentNode.getParent();
        } else if (qName.equals("math:piecewise") || qName.equals("piecewise")) {
            this.currentNode = this.currentNode.parent;
        } else if (qName.equals("math:piece") || qName.equals("piece")) {
            this.currentNode = this.currentNode.parent;
        } else if (qName.equals("math:otherwise") || qName.equals("otherwise")) {
            this.currentNode = this.currentNode.parent;
        } else if (qName.equals("math:bvar") || qName.equals("bvar")) {
            this.mode = this.NORMAL;
        }
    }

    public Hashtable getFunctions() {
        return functions;
    }

    public SBMLNode getRoot() {
        return this.root;
    }

    public void insertFunction(String function) {
        functions.put(function, function);
    }

    public void reset() {
        functions.clear();
    }

    public void startDocument() throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (qName.equals("math:cn") || qName.equals("cn")) {
                this.mode = this.CNMODE;
                if (atts.getIndex("type") == -1) return;
                if (atts.getValue("type").equals("e-notation")) {
                    this.mode = this.CNMODE + this.ENOTATION;
                    return;
                } else {
                    if (!atts.getValue("type").equals("rational")) return;
                    this.mode = this.CNMODE + this.RATIONAL;
                }
                return;
            }
            if (qName.equals("math:ci") || qName.equals("ci")) {
                if (this.mode != this.CIMODE + this.BVARMODE) {
                    this.mode = this.CIMODE;
                }
                if (atts.getValue("type") == null) return;
                return;
            }
            if (qName.equals("math:csymbol") || qName.equals("csymbol") || qName.equals("/csymbol") || qName.equals("/math:csymbol")) {
                this.mode = this.CSYMBOLMODE;
                if (atts.getValue("definitionURL").equals("http://www.sbml.org/sbml/symbols/time")) {
                    this.currentNode.setElement(new MathElement("@time"));
                    return;
                } else {
                    if (!atts.getValue("definitionURL").equals("http://www.sbml.org/sbml/symbols/delay")) return;
                    this.currentNode.setElement(new MathElement("@delay"));
                }
                return;
            }
            if (qName.equals("math:apply") || qName.equals("apply")) {
                if (this.isLambda) {
                    if (this.root == null) {
                        this.currentNode = this.root = new SBMLNode(new MathElement());
                        return;
                    } else {
                        SBMLNode n = new SBMLNode(this.currentNode);
                        this.currentNode.addChild(n);
                        this.currentNode = n;
                    }
                    return;
                } else if (this.root == null) {
                    this.currentNode = this.root = new SBMLNode(new MathElement());
                    return;
                } else {
                    SBMLNode n = new SBMLNode(this.currentNode);
                    this.currentNode.addChild(n);
                    this.currentNode = n;
                }
                return;
            }
            if (qName.equals("math:piecewise") || qName.equals("piecewise")) {
                if (this.root == null) {
                    this.currentNode = this.root = new SBMLNode(new MathElement());
                } else {
                    SBMLNode n = new SBMLNode(this.currentNode);
                    this.currentNode.addChild(n);
                    this.currentNode = n;
                }
                this.currentNode.setElement(new MathElement("@piecewise"));
                return;
            }
            if (qName.equals("math:piece") || qName.equals("piece")) {
                SBMLNode n = new SBMLNode(this.currentNode);
                this.currentNode.addChild(n);
                this.currentNode = n;
                this.currentNode.setElement(new MathElement("@piece"));
                return;
            }
            if (qName.equals("math:otherwise") || qName.equals("otherwise")) {
                SBMLNode n = new SBMLNode(this.currentNode);
                this.currentNode.addChild(n);
                this.currentNode = n;
                this.currentNode.setElement(new MathElement("@otherwise"));
                return;
            }
            if (qName.equals("math:eq") || qName.equals("eq")) {
                this.currentNode.setElement(new MathElement("@eq"));
                return;
            }
            if (qName.equals("math:neq") || qName.equals("neq")) {
                this.currentNode.setElement(new MathElement("@neq"));
                return;
            }
            if (qName.equals("math:gt") || qName.equals("gt")) {
                this.currentNode.setElement(new MathElement("@gt"));
                return;
            }
            if (qName.equals("math:lt") || qName.equals("lt")) {
                this.currentNode.setElement(new MathElement("@lt"));
                return;
            }
            if (qName.equals("math:geq") || qName.equals("geq")) {
                this.currentNode.setElement(new MathElement("@geq"));
                return;
            }
            if (qName.equals("math:leq") || qName.equals("leq")) {
                this.currentNode.setElement(new MathElement("@leq"));
                return;
            }
            if (qName.equals("math:plus") || qName.equals("plus")) {
                this.currentNode.setElement(new MathElement("@plus"));
                return;
            }
            if (qName.equals("math:minus") || qName.equals("minus")) {
                this.currentNode.setElement(new MathElement("@minus"));
                return;
            }
            if (qName.equals("math:times") || qName.equals("times")) {
                this.currentNode.setElement(new MathElement("@times"));
                return;
            }
            if (qName.equals("math:divide") || qName.equals("divide")) {
                this.currentNode.setElement(new MathElement("@divide"));
                return;
            }
            if (qName.equals("math:power") || qName.equals("power")) {
                this.currentNode.setElement(new MathElement("@power"));
                return;
            }
            if (qName.equals("math:root") || qName.equals("root")) {
                this.currentNode.setElement(new MathElement("@root"));
                return;
            }
            if (qName.equals("math:abs") || qName.equals("abs")) {
                this.currentNode.setElement(new MathElement("@abs"));
                return;
            }
            if (qName.equals("math:exp") || qName.equals("exp")) {
                this.currentNode.setElement(new MathElement("@exp"));
                return;
            }
            if (qName.equals("math:ln") || qName.equals("ln")) {
                this.currentNode.setElement(new MathElement("@ln"));
                return;
            }
            if (qName.equals("math:log") || qName.equals("log")) {
                this.currentNode.setElement(new MathElement("@log"));
                return;
            }
            if (qName.equals("math:floor") || qName.equals("floor")) {
                this.currentNode.setElement(new MathElement("@floor"));
                return;
            }
            if (qName.equals("math:ceiling") || qName.equals("ceiling")) {
                this.currentNode.setElement(new MathElement("@ceiling"));
                return;
            }
            if (qName.equals("math:factorial") || qName.equals("factorial")) {
                this.currentNode.setElement(new MathElement("@factorial"));
                return;
            }
            if (qName.equals("math:and") || qName.equals("and")) {
                this.currentNode.setElement(new MathElement("@and"));
                return;
            }
            if (qName.equals("math:or") || qName.equals("or")) {
                this.currentNode.setElement(new MathElement("@or"));
                return;
            }
            if (qName.equals("math:xor") || qName.equals("xor")) {
                this.currentNode.setElement(new MathElement("@xor"));
                return;
            }
            if (qName.equals("math:not") || qName.equals("not")) {
                this.currentNode.setElement(new MathElement("@not"));
                return;
            }
            if (qName.equals("math:degree") || qName.equals("degree")) return;
            if (qName.equals("math:bvar") || qName.equals("bvar")) {
                this.mode = this.BVARMODE + this.CIMODE;
                return;
            }
            if (qName.equals("math:logbase") || qName.equals("logbase")) return;
            if (qName.equals("math:sin") || qName.equals("sin")) {
                this.currentNode.setElement(new MathElement("@sin"));
                return;
            }
            if (qName.equals("math:cos") || qName.equals("cos")) {
                this.currentNode.setElement(new MathElement("@cos"));
                return;
            }
            if (qName.equals("math:tan") || qName.equals("tan")) {
                this.currentNode.setElement(new MathElement("@tan"));
                return;
            }
            if (qName.equals("math:sec") || qName.equals("sec")) {
                this.currentNode.setElement(new MathElement("@sec"));
                return;
            }
            if (qName.equals("math:csc") || qName.equals("csc")) {
                this.currentNode.setElement(new MathElement("@csc"));
                return;
            }
            if (qName.equals("math:cot") || qName.equals("cot")) {
                this.currentNode.setElement(new MathElement("@cot"));
                return;
            }
            if (qName.equals("math:sinh") || qName.equals("sinh")) {
                this.currentNode.setElement(new MathElement("@sinh"));
                return;
            }
            if (qName.equals("math:cosh") || qName.equals("cosh")) {
                this.currentNode.setElement(new MathElement("@cosh"));
                return;
            }
            if (qName.equals("math:tanh") || qName.equals("tanh")) {
                this.currentNode.setElement(new MathElement("@tanh"));
                return;
            }
            if (qName.equals("math:sech") || qName.equals("sech")) {
                this.currentNode.setElement(new MathElement("@sech"));
                return;
            }
            if (qName.equals("math:csch") || qName.equals("csch")) {
                this.currentNode.setElement(new MathElement("@csch"));
                return;
            }
            if (qName.equals("math:coth") || qName.equals("coth")) {
                this.currentNode.setElement(new MathElement("@coth"));
                return;
            }
            if (qName.equals("math:arcsin") || qName.equals("arcsin")) {
                this.currentNode.setElement(new MathElement("@arcsin"));
                return;
            }
            if (qName.equals("math:arccos") || qName.equals("arccos")) {
                this.currentNode.setElement(new MathElement("@arccos"));
                return;
            }
            if (qName.equals("math:arctan") || qName.equals("arctan")) {
                this.currentNode.setElement(new MathElement("@arctan"));
                return;
            }
            if (qName.equals("math:arccosh") || qName.equals("arccosh")) {
                this.currentNode.setElement(new MathElement("@arccosh"));
                return;
            }
            if (qName.equals("math:arccot") || qName.equals("arccot")) {
                this.currentNode.setElement(new MathElement("@arccot"));
                return;
            }
            if (qName.equals("math:arccoth") || qName.equals("arccoth")) {
                this.currentNode.setElement(new MathElement("@arccoth"));
                return;
            }
            if (qName.equals("math:arccsc") || qName.equals("arccsc")) {
                this.currentNode.setElement(new MathElement("@arccsc"));
                return;
            }
            if (qName.equals("math:arccsch") || qName.equals("arccsch")) {
                this.currentNode.setElement(new MathElement("@arccsch"));
                return;
            }
            if (qName.equals("math:arcsec") || qName.equals("arcsec")) {
                this.currentNode.setElement(new MathElement("@arcsec"));
                return;
            }
            if (qName.equals("math:arcsech") || qName.equals("arcsech")) {
                this.currentNode.setElement(new MathElement("@arcsech"));
                return;
            }
            if (qName.equals("math:arcsinh") || qName.equals("arcsinh")) {
                this.currentNode.setElement(new MathElement("@arcsinh"));
                return;
            }
            if (qName.equals("math:arctanh") || qName.equals("arctanh")) {
                this.currentNode.setElement(new MathElement("@arctanh"));
                return;
            }
            if (qName.equals("math:true") || qName.equals("true")) {
                this.currentNode.setElement(new MathElement("@true"));
                return;
            }
            if (qName.equals("math:false") || qName.equals("false")) {
                this.currentNode.setElement(new MathElement("@false"));
                return;
            }
            if (qName.equals("math:notanumber") || qName.equals("notanumber")) {
                this.currentNode.setElement(new MathElement("@notanumber"));
                return;
            }
            if (qName.equals("math:pi") || qName.equals("pi")) {
                this.currentNode.setElement(new MathElement("@pi"));
                return;
            }
            if (qName.equals("math:infinity") || qName.equals("infinity")) {
                this.currentNode.setElement(new MathElement("@infinity"));
                return;
            }
            if (qName.equals("math:exponentiale") || qName.equals("exponentiale")) {
                this.currentNode.setElement(new MathElement("@exponentiale"));
                return;
            }
            if (!qName.equals("math:semantics") && !qName.equals("semantics") && !qName.equals("math:annotation") && !qName.equals("annotation") && !qName.equals("math:annotation-xml") && !qName.equals("annotation-xml")) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintStream out;

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            System.out.println(mathML);
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        MyErrorHandler(PrintStream out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }
    }
}

