/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.math;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class SymbolTable {
    public static final int ID_START = 1;
    public static final int ID_END = 9999;
    public static final int ID_WIDTH = 4;
    private static Hashtable forbiddenSymbols;
    private ArrayList nameCol;
    private ArrayList fortranNameCol;
    private ArrayList idCol;
    private ArrayList nameColRev;
    private ArrayList fortranNameColRev;
    private Hashtable idNameMap;
    private int maxLength;
    private Mode mode = Mode.FORTRAN_IDENTIFIER;
    private boolean padToLength = false;
    private char padCharacter = (char)32;

    public SymbolTable() {
        this.maxLength = this.mode.maxLength();
        this.nameCol = new ArrayList();
        this.fortranNameCol = new ArrayList();
        this.idCol = new ArrayList();
        this.nameColRev = new ArrayList();
        this.fortranNameColRev = new ArrayList();
        this.idNameMap = new Hashtable();
    }

    public SymbolTable(int maxLength) {
        this();
        this.maxLength = maxLength > this.mode.maxLength() ? this.mode.maxLength() : maxLength;
    }

    public SymbolTable(Mode mode) {
        this();
        this.mode = mode;
        this.maxLength = mode.maxLength();
    }

    public SymbolTable(Mode mode, int maxLength) {
        this();
        this.mode = mode;
        this.maxLength = maxLength;
    }

    public SymbolTable(Mode mode, int maxLength, boolean padToLength) {
        this();
        this.mode = mode;
        this.maxLength = maxLength;
        this.padToLength = padToLength;
    }

    public void dumpSymbolTable(PrintWriter out) {
        Iterator n = this.nameCol.iterator();
        Iterator f = this.fortranNameCol.iterator();
        while (n.hasNext() && f.hasNext()) {
            String name = (String)n.next();
            out.println(name + " (" + this.lookupId(name) + ")" + " => " + f.next());
        }
        out.flush();
    }

    public void dumpSymbolTable() {
        this.dumpSymbolTable(new PrintWriter(System.out));
    }

    public void emptySymbolTable() {
        this.nameCol.clear();
        this.fortranNameCol.clear();
        this.idCol.clear();
        this.nameColRev.clear();
        this.fortranNameColRev.clear();
        this.idNameMap.clear();
    }

    public Map getSymbolToIdMap() {
        HashMap map = new HashMap();
        for (int i = 0; i < this.fortranNameCol.size(); ++i) {
            map.put(this.fortranNameCol.get(i), this.idCol.get(i));
        }
        return map;
    }

    public String lookupSymbol(String name) {
        int index = this.lookupSymbolIndex(name, this.nameCol);
        if (index < 0) {
            return null;
        }
        return (String)this.fortranNameCol.get(index);
    }

    public String lookupSymbolById(String id) {
        String name = (String)this.idNameMap.get(id);
        if (name == null) {
            return null;
        }
        String ret = this.lookupSymbol(name);
        return ret;
    }

    public String lookupId(String name) {
        int index = this.lookupSymbolIndex(name, this.nameCol);
        if (index < 0) {
            return null;
        }
        return (String)this.idCol.get(index);
    }

    public String lookupName(String id) {
        return (String)this.idNameMap.get(id);
    }

    public String reverseLookupId(String fortranName) {
        int index = this.lookupFortranNameIndex(fortranName);
        if (index < 0) {
            return null;
        }
        return this.lookupId((String)this.nameColRev.get(index));
    }

    private int lookupFortranNameIndex(String fname) {
        if (this.mode == Mode.IDENTITY) {
            return this.lookupSymbolIndex(fname, this.fortranNameColRev);
        }
        return this.lookupSymbolIndex(fname.toUpperCase(), this.fortranNameColRev);
    }

    private int lookupSymbolIndex(String name, ArrayList array) {
        int left = 0;
        int right = array.size();
        int next = (left + right) / 2;
        if (right == left) {
            return -1;
        }
        int compare = 0;
        if (next < array.size()) {
            compare = name.compareTo(array.get(next));
        }
        while (right > left && compare != 0) {
            if (compare > 0) {
                left = next + 1;
            } else {
                right = next;
            }
            if ((next = (left + right) / 2) >= array.size()) continue;
            compare = name.compareTo(array.get(next));
        }
        if (compare == 0) {
            return next;
        }
        return -next - 1;
    }

    public String addSymbol(String id) throws Exception {
        return this.addSymbol(id, id);
    }

    public String addSymbol(String name, String id) throws Exception {
        if (name == null) {
            System.err.println("WARNING: symbol name is null, setting name = id");
            name = id;
        }
        if (id == null) {
            throw new Exception("id is null");
        }
        if (this.nameCol.size() == Integer.MAX_VALUE) {
            throw new Exception("Symbol table is full.");
        }
        String fortranName = this.makeFortranSafe(name, this.mode, this.maxLength);
        int index = this.lookupSymbolIndex(name, this.nameCol);
        int fortranIndex = this.lookupFortranNameIndex(fortranName);
        if (index >= 0) {
            throw new Exception(name + " already exists in the symbol table.");
        }
        if (fortranIndex >= 0 && this.mode != Mode.IDENTITY) {
            fortranName = this.findAFortranName(fortranName);
        }
        int forIndex = this.lookupFortranNameIndex(fortranName);
        this.nameCol.add(-index - 1, name);
        this.fortranNameCol.add(-index - 1, fortranName);
        this.idCol.add(-index - 1, id);
        this.nameColRev.add(-forIndex - 1, name);
        if (this.mode == Mode.IDENTITY) {
            this.fortranNameColRev.add(-forIndex - 1, fortranName);
        } else {
            this.fortranNameColRev.add(-forIndex - 1, fortranName.toUpperCase());
        }
        if (this.idNameMap.get(id) != null) {
            throw new Exception("Id " + id + " isn't unique.");
        }
        this.idNameMap.put(id, name);
        return fortranName;
    }

    public String findAFortranName(String name) throws Exception {
        int index = 0;
        int id = 1;
        String suffix = "";
        String newName = "";
        if (this.lookupFortranNameIndex(name) < 0) {
            return name;
        }
        suffix = Integer.toString(id);
        while (suffix.length() < 4) {
            suffix = "0" + suffix;
        }
        suffix = "_" + suffix;
        newName = name.length() < this.maxLength - suffix.length() ? name + suffix : name.substring(0, this.maxLength - suffix.length()) + suffix;
        while ((index = this.lookupFortranNameIndex(newName)) >= 0 && id < 9999) {
            suffix = Integer.toString(++id);
            while (suffix.length() < 4) {
                suffix = "0" + suffix;
            }
            suffix = "_" + suffix;
            if (name.length() < this.maxLength - suffix.length()) {
                newName = name + suffix;
                continue;
            }
            newName = name.substring(0, this.maxLength - suffix.length()) + suffix;
        }
        if (index >= 0) {
            throw new Exception("A unique Fortran name couldn't be found.");
        }
        return newName;
    }

    public String makeFortranSafe(String string) throws Exception {
        return SymbolTable.makeFortranSafe(string, this.mode, this.maxLength, this.padToLength, this.padCharacter);
    }

    public String makeFortranSafe(String string, Mode mode) throws Exception {
        return SymbolTable.makeFortranSafe(string, mode, this.maxLength, this.padToLength, this.padCharacter);
    }

    public String makeFortranSafe(String string, Mode mode, int maxLength) throws Exception {
        return SymbolTable.makeFortranSafe(string, mode, maxLength, this.padToLength, this.padCharacter);
    }

    public static String makeFortranSafe(String string, Mode mode, int maxLength, boolean padToLength, char padCharacter) throws Exception {
        if (mode == Mode.IDENTITY) {
            return string;
        }
        if (mode == Mode.FORTRAN_IDENTIFIER) {
            return SymbolTable.makeFortranIdSafe_(string, maxLength);
        }
        if (mode == Mode.FORTRAN_CHARACTER_STRING) {
            return SymbolTable.makeFortranCharacterSafe_(string, maxLength, padToLength, padCharacter);
        }
        throw new Exception("Unrecognized mode.");
    }

    public static String makeFortranCharacterSafe_(String string, int maxLength, boolean padToLength, char padCharacter) throws Exception {
        StringBuffer out = new StringBuffer();
        StringBuffer in = new StringBuffer(string);
        while (in.length() > 0 && out.length() < maxLength) {
            if (in.toString().matches("^[0-9A-Za-z~`!#$%&*()_+\\-=\\[\\]\\\\{};':\",./<>? ].*")) {
                out.append(in.charAt(0));
            } else {
                if (out.length() > 1) {
                    out.append("_");
                }
                out.append("u" + Integer.toHexString(in.charAt(0)));
                if (in.length() > 1) {
                    out.append("_");
                }
            }
            in.deleteCharAt(0);
        }
        if (out.length() > maxLength) {
            return out.substring(0, maxLength);
        }
        if (padToLength) {
            while (out.length() < maxLength) {
                out.append(padCharacter);
            }
        }
        return out.toString();
    }

    public String makeFortranIdSafe(String string) throws Exception {
        return SymbolTable.makeFortranIdSafe_(string, this.maxLength);
    }

    private static String makeFortranIdSafe_(String in, int maxLength) {
        int length = in.length();
        if (length > maxLength) {
            length = maxLength;
        }
        if (length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        char c = in.charAt(0);
        int count = 0;
        int pos = 1;
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            out.append("A_");
            count += 2;
        }
        block0: while (count < maxLength) {
            if (c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                out.append(c);
                ++count;
            } else {
                if (c == '\'' || c == '\"') {
                    out.append("_");
                    ++count;
                    while (true) {
                        if (c == '\'') {
                            out.append("p");
                            ++count;
                        } else {
                            if (c != '\"') continue block0;
                            out.append("pp");
                            count += 2;
                        }
                        if (pos == length) break block0;
                        c = in.charAt(pos++);
                    }
                }
                out.append("_u");
                String hexCode = Integer.toHexString(c);
                out.append(hexCode);
                count += 2 + hexCode.length();
            }
            if (pos == length) break;
            c = in.charAt(pos++);
        }
        return count > maxLength ? out.substring(0, maxLength) : out.toString();
    }

    public static final class Mode {
        public static final Mode FORTRAN_IDENTIFIER = new Mode("FORTRAN_INDENTIFIER", 31);
        public static final Mode FORTRAN_CHARACTER_STRING = new Mode("FORTRAN_CHARACTER_STRING", 65000);
        public static final Mode IDENTITY = new Mode("IDENTITY", Integer.MAX_VALUE);
        private String name;
        private int maxLength;

        public Mode(String name, int maxLength) {
            this.name = name;
            this.maxLength = maxLength;
        }

        public int maxLength() {
            return this.maxLength;
        }

        public String toString() {
            return this.name;
        }
    }
}

