/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.tests;

import jigcell.sbml2.Reaction;
import jigcell.sbml2.tests.SBMLModelTests;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BoundaryModelTests
extends SBMLModelTests {
    public static void main(String[] args) {
        TestRunner.run((Test)BoundaryModelTests.suite());
    }

    public static Test suite() {
        return new TestSuite(BoundaryModelTests.class);
    }

    public BoundaryModelTests(String name) {
        super(name);
        this.modelName = "l2v1-boundary.sbml";
    }

    public void testCompartment0() throws Exception {
        BoundaryModelTests.assertTrue((this.model.getCompartments().size() == 1 ? 1 : 0) != 0);
    }

    public void testCompartment1() throws Exception {
        this.testCompartment("compartmentOne", true, null, 1.0, 3, "volume");
    }

    public void testEvent0() throws Exception {
        BoundaryModelTests.assertTrue((this.model.getEvents().size() == 0 ? 1 : 0) != 0);
    }

    public void testFunction0() throws Exception {
        BoundaryModelTests.assertTrue((this.model.getFunctionDefinitions().size() == 0 ? 1 : 0) != 0);
    }

    public void testModel1() throws Exception {
        BoundaryModelTests.assertTrue((boolean)this.model.getId().equals("BoundaryCondExampleModel"));
    }

    public void testParameter0() throws Exception {
        BoundaryModelTests.assertTrue((this.model.getParameters().size() == 2 ? 1 : 0) != 0);
    }

    public void testParameter1() throws Exception {
        this.testParameter("k1", 0.5);
    }

    public void testParameter2() throws Exception {
        this.testParameter("k2", 0.1);
    }

    public void testReaction0() throws Exception {
        BoundaryModelTests.assertTrue((this.model.getReactions().size() == 1 ? 1 : 0) != 0);
    }

    public void testReaction1() throws Exception {
        Reaction reaction = this.testReaction("reaction_1", null, false);
        BoundaryModelTests.assertTrue((reaction.getReactant().size() == 2 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "S1", 1.0);
        this.testReactionModifier(reaction.getReactant(), "S2", 1.0);
        BoundaryModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "S4", 1.0);
        BoundaryModelTests.assertTrue((reaction.getModifier().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getModifier(), "S3");
    }

    public void testRule0() throws Exception {
        BoundaryModelTests.assertTrue((this.model.getRules().size() == 1 ? 1 : 0) != 0);
    }

    public void testSpecies0() throws Exception {
        BoundaryModelTests.assertTrue((this.model.getSpecies().size() == 4 ? 1 : 0) != 0);
    }

    public void testSpecies1() throws Exception {
        this.testSpecies("S1", "compartmentOne", 0.0, false, true);
    }

    public void testSpecies2() throws Exception {
        this.testSpecies("S2", "compartmentOne", 1.0, true, true);
    }

    public void testSpecies3() throws Exception {
        this.testSpecies("S3", "compartmentOne", 3.0, true, false);
    }

    public void testSpecies4() throws Exception {
        this.testSpecies("S4", "compartmentOne", 0.0, false, false);
    }

    public void testUnit0() throws Exception {
        BoundaryModelTests.assertTrue((this.model.getUnitDefinitions().size() == 0 ? 1 : 0) != 0);
    }
}

