/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.tests;

import jigcell.sbml2.Reaction;
import jigcell.sbml2.tests.SBMLModelTests;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BranchModelTests
extends SBMLModelTests {
    public static void main(String[] args) {
        TestRunner.run((Test)BranchModelTests.suite());
    }

    public static Test suite() {
        return new TestSuite(BranchModelTests.class);
    }

    public BranchModelTests(String name) {
        super(name);
        this.modelName = "l2v1-branch.sbml";
    }

    public void testCompartment0() throws Exception {
        BranchModelTests.assertTrue((this.model.getCompartments().size() == 1 ? 1 : 0) != 0);
    }

    public void testCompartment1() throws Exception {
        this.testCompartment("compartmentOne", true, null, 1.0, 3, "volume");
    }

    public void testEvent0() throws Exception {
        BranchModelTests.assertTrue((this.model.getEvents().size() == 0 ? 1 : 0) != 0);
    }

    public void testFunction0() throws Exception {
        BranchModelTests.assertTrue((this.model.getFunctionDefinitions().size() == 0 ? 1 : 0) != 0);
    }

    public void testModel1() throws Exception {
        BranchModelTests.assertTrue((boolean)this.model.getId().equals("Branch"));
    }

    public void testParameter0() throws Exception {
        BranchModelTests.assertTrue((this.model.getParameters().size() == 0 ? 1 : 0) != 0);
    }

    public void testReaction0() throws Exception {
        BranchModelTests.assertTrue((this.model.getReactions().size() == 3 ? 1 : 0) != 0);
    }

    public void testReaction1() throws Exception {
        Reaction reaction = this.testReaction("reaction_1", null, false);
        BranchModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "X0", 1.0);
        BranchModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "S1", 1.0);
        BranchModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 1 ? 1 : 0) != 0);
        this.testParameter(reaction, "k1", 0.0);
    }

    public void testReaction2() throws Exception {
        Reaction reaction = this.testReaction("reaction_2", null, false);
        BranchModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "S1", 1.0);
        BranchModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "X1", 1.0);
        BranchModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 1 ? 1 : 0) != 0);
        this.testParameter(reaction, "k2", 0.0);
    }

    public void testReaction3() throws Exception {
        Reaction reaction = this.testReaction("reaction_3", null, false);
        BranchModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "S1", 1.0);
        BranchModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "X2", 1.0);
        BranchModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 1 ? 1 : 0) != 0);
        this.testParameter(reaction, "k3", 0.0);
    }

    public void testRule0() throws Exception {
        BranchModelTests.assertTrue((this.model.getRules().size() == 0 ? 1 : 0) != 0);
    }

    public void testSpecies0() throws Exception {
        BranchModelTests.assertTrue((this.model.getSpecies().size() == 4 ? 1 : 0) != 0);
    }

    public void testSpecies1() throws Exception {
        this.testSpecies("S1", "compartmentOne", 0.0, false, false);
    }

    public void testSpecies2() throws Exception {
        this.testSpecies("X0", "compartmentOne", 0.0, false, true);
    }

    public void testSpecies3() throws Exception {
        this.testSpecies("X1", "compartmentOne", 0.0, false, true);
    }

    public void testSpecies4() throws Exception {
        this.testSpecies("X2", "compartmentOne", 0.0, false, true);
    }

    public void testUnit0() throws Exception {
        BranchModelTests.assertTrue((this.model.getUnitDefinitions().size() == 0 ? 1 : 0) != 0);
    }
}

