/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.tests;

import java.util.List;
import jigcell.sbml2.Reaction;
import jigcell.sbml2.Unit;
import jigcell.sbml2.UnitDefinition;
import jigcell.sbml2.tests.SBMLModelTests;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CompartmentModelTests
extends SBMLModelTests {
    public static void main(String[] args) {
        TestRunner.run((Test)CompartmentModelTests.suite());
    }

    public static Test suite() {
        return new TestSuite(CompartmentModelTests.class);
    }

    public CompartmentModelTests(String name) {
        super(name);
        this.modelName = "l2v1-2D-compartments.sbml";
    }

    public void testCompartment0() throws Exception {
        CompartmentModelTests.assertTrue((this.model.getCompartments().size() == 3 ? 1 : 0) != 0);
    }

    public void testCompartment1() throws Exception {
        this.testCompartment("Extracellular", true, null, Double.NaN, 3, "volume");
    }

    public void testCompartment2() throws Exception {
        this.testCompartment("PlasmaMembrane", true, "Extracellular", Double.NaN, 2, "area");
    }

    public void testCompartment3() throws Exception {
        this.testCompartment("Cytosol", true, "PlasmaMembrane", Double.NaN, 3, "volume");
    }

    public void testEvent0() throws Exception {
        CompartmentModelTests.assertTrue((this.model.getEvents().size() == 0 ? 1 : 0) != 0);
    }

    public void testFunction0() throws Exception {
        CompartmentModelTests.assertTrue((this.model.getFunctionDefinitions().size() == 0 ? 1 : 0) != 0);
    }

    public void testModel1() throws Exception {
        CompartmentModelTests.assertTrue((boolean)this.model.getId().equals("facilitated_ca_diffusion"));
    }

    public void testParameter0() throws Exception {
        CompartmentModelTests.assertTrue((this.model.getParameters().size() == 0 ? 1 : 0) != 0);
    }

    public void testReaction0() throws Exception {
        CompartmentModelTests.assertTrue((this.model.getReactions().size() == 4 ? 1 : 0) != 0);
    }

    public void testReaction1() throws Exception {
        Reaction reaction = this.testReaction("CalciumCalbindin_gt_BoundCytosol", Boolean.TRUE, true);
        CompartmentModelTests.assertTrue((reaction.getReactant().size() == 2 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "CaBP_C", 1.0);
        this.testReactionModifier(reaction.getReactant(), "Ca_C", 1.0);
        CompartmentModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "CaBPB_C", 1.0);
        CompartmentModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 2 ? 1 : 0) != 0);
        this.testParameter(reaction, "Kf_CalciumCalbindin_BoundCytosol", 20.0);
        this.testParameter(reaction, "Kr_CalciumCalbindin_BoundCytosol", 8.6);
    }

    public void testReaction2() throws Exception {
        Reaction reaction = this.testReaction("CalciumBuffer_gt_BoundCytosol", Boolean.TRUE, true);
        CompartmentModelTests.assertTrue((reaction.getReactant().size() == 2 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "Ca_C", 1.0);
        this.testReactionModifier(reaction.getReactant(), "B_C", 1.0);
        CompartmentModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "CaB_C", 1.0);
        CompartmentModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 2 ? 1 : 0) != 0);
        this.testParameter(reaction, "Kf_CalciumBuffer_BoundCytosol", 0.1);
        this.testParameter(reaction, "Kr_CalciumBuffer_BoundCytosol", 1.0);
    }

    public void testReaction3() throws Exception {
        Reaction reaction = this.testReaction("Ca_Pump", null, true);
        CompartmentModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "Ca_C", 1.0);
        CompartmentModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "Ca_EC", 1.0);
        CompartmentModelTests.assertTrue((reaction.getModifier().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getModifier(), "CaPump_PM");
        CompartmentModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 3 ? 1 : 0) != 0);
        this.testParameter(reaction, "Vmax", -4000.0);
        this.testParameter(reaction, "kP", 0.25);
        this.testParameter(reaction, "Ca_Rest", 0.1);
    }

    public void testReaction4() throws Exception {
        Reaction reaction = this.testReaction("Ca_channel", null, true);
        CompartmentModelTests.assertTrue((reaction.getReactant().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getReactant(), "Ca_EC", 1.0);
        CompartmentModelTests.assertTrue((reaction.getProduct().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getProduct(), "Ca_C", 1.0);
        CompartmentModelTests.assertTrue((reaction.getModifier().size() == 1 ? 1 : 0) != 0);
        this.testReactionModifier(reaction.getModifier(), "CaCh_PM");
        CompartmentModelTests.assertTrue((reaction.getKineticLaw().getParameter().size() == 2 ? 1 : 0) != 0);
        this.testParameter(reaction, "J0", 0.014);
        this.testParameter(reaction, "Kc", 0.5);
    }

    public void testRule0() throws Exception {
        CompartmentModelTests.assertTrue((this.model.getRules().size() == 0 ? 1 : 0) != 0);
    }

    public void testSpecies0() throws Exception {
        CompartmentModelTests.assertTrue((this.model.getSpecies().size() == 8 ? 1 : 0) != 0);
    }

    public void testSpecies1() throws Exception {
        this.testSpecies("CaBPB_C", "Cytosol", 47.17, false, false);
    }

    public void testSpecies2() throws Exception {
        this.testSpecies("B_C", "Cytosol", 396.04, false, false);
    }

    public void testSpecies3() throws Exception {
        this.testSpecies("CaB_C", "Cytosol", 3.96, false, false);
    }

    public void testSpecies4() throws Exception {
        this.testSpecies("Ca_EC", "Extracellular", 1000.0, false, false);
    }

    public void testSpecies5() throws Exception {
        this.testSpecies("Ca_C", "Cytosol", 0.1, false, false);
    }

    public void testSpecies6() throws Exception {
        this.testSpecies("CaCh_PM", "PlasmaMembrane", 1.0, false, false);
    }

    public void testSpecies7() throws Exception {
        this.testSpecies("CaPump_PM", "PlasmaMembrane", 1.0, false, false);
    }

    public void testSpecies8() throws Exception {
        this.testSpecies("CaBP_C", "Cytosol", 202.83, false, false);
    }

    public void testUnit0() throws Exception {
        CompartmentModelTests.assertTrue((this.model.getUnitDefinitions().size() == 2 ? 1 : 0) != 0);
    }

    public void testUnit1() throws Exception {
        UnitDefinition definition = this.testUnitDefinition("substance", 1);
        List units = definition.getUnits();
        this.testUnit((Unit)units.get(0), 1, "mole", 1.0, 0.0, -6);
    }

    public void testUnit2() throws Exception {
        UnitDefinition definition = this.testUnitDefinition("area", 1);
        List units = definition.getUnits();
        this.testUnit((Unit)units.get(0), 2, "metre", 1.0, 0.0, -6);
    }
}

