/*
 * Decompiled with CFR 0.152.
 */
import JSim.aserver.ASModel;
import JSim.aserver.ASQuery;
import JSim.aserver.ASVar;
import JSim.data.Data;
import JSim.gui.plugin.GGraphic;
import JSim.project.PJob;
import JSim.project.PModel;
import JSim.project.PModelRunJob;
import JSim.project.PNamed;
import JSim.util.Xcept;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.w3c.dom.Element;

public class MyGraphic
extends GGraphic
implements ActionListener,
ComponentListener {
    private int POLLFREQ = 200;
    private JPanel figure;
    private PModel pmodel;
    private ASVar Qra;
    private ASVar Qrv;
    private ASVar Qla;
    private ASVar Qlv;
    private double Vra;
    private double Vrv;
    private double Vla;
    private double Vlv;
    private Timer timer;

    public MyGraphic(GGraphic.Callbacks cb) throws Exception {
        super(cb);
        final int rcell = this.radius(175.0);
        this.figure = new JPanel(null){

            public void paint(Graphics g) {
                int w = this.getSize().width;
                int h = this.getSize().height;
                g.setColor(Color.white);
                g.fillRect(0, 0, w, h);
                this.paint(g, Color.blue, rcell, rcell, MyGraphic.this.Vra, "RA");
                this.paint(g, Color.blue, rcell, rcell * 3, MyGraphic.this.Vrv, "RV");
                this.paint(g, Color.red, rcell * 3, rcell, MyGraphic.this.Vla, "LA");
                this.paint(g, Color.red, rcell * 3, rcell * 3, MyGraphic.this.Vlv, "LV");
                if (MyGraphic.this.pmodel != null) {
                    g.setColor(Color.black);
                    g.drawString(MyGraphic.this.pmodel.name(), 0, 20);
                }
            }

            public void paint(Graphics g, Color c, int xc, int yc, double v, String name) {
                if (Double.isNaN(v)) {
                    return;
                }
                if (v < 10.0) {
                    v = 10.0;
                }
                if (v > 200.0) {
                    v = 200.0;
                }
                int r = MyGraphic.this.radius(v);
                g.setColor(c);
                g.fillOval(xc - r, yc - r, 2 * r, 2 * r);
                g.setColor(Color.black);
                g.drawString(name, xc, yc);
            }
        };
        this.figure.setPreferredSize(new Dimension(4 * rcell, 4 * rcell));
        this.figure.addComponentListener(this);
        this.timer = new Timer(this.POLLFREQ, this);
    }

    public int radius(double v) {
        return (int)(10.0 * Math.pow(v, 0.3333));
    }

    public JComponent getJComponent() {
        return this.figure;
    }

    public void importXML(Element e) {
        this.pmodel = null;
        if (e == null) {
            this.pmodel = this.callbacks().userModelSelect((Component)this.figure);
        } else {
            String name = e.getAttribute("modelName");
            PNamed p = this.callbacks().getProject().child(name);
            if (p instanceof PModel) {
                this.pmodel = (PModel)p;
            }
        }
    }

    public void exportXML(Element e) {
        e.setAttribute("modelName", this.pmodel == null ? "" : this.pmodel.name());
    }

    public void jobStarted(PJob pjob) {
        if (this.pmodel == null) {
            return;
        }
        if (pjob.pmodel() != this.pmodel) {
            return;
        }
        if (!(pjob instanceof PModelRunJob)) {
            return;
        }
        this.Qlv = null;
        this.Qla = null;
        this.Qrv = null;
        this.Qra = null;
        ASModel asmodel = this.pmodel.rt();
        try {
            this.Qra = asmodel.getASVar("Vra");
            this.Qrv = asmodel.getASVar("Vrv");
            this.Qla = asmodel.getASVar("Vla");
            this.Qlv = asmodel.getASVar("Vlv");
        }
        catch (Xcept e) {
            System.err.println("" + (Object)((Object)e));
        }
        this.timer.start();
    }

    public void jobStopped(PJob pjob) {
        if (this.pmodel == null) {
            return;
        }
        if (pjob.pmodel() != this.pmodel) {
            return;
        }
        if (!(pjob instanceof PModelRunJob)) {
            return;
        }
        this.timer.stop();
        this.Qlv = null;
        this.Qla = null;
        this.Qrv = null;
        this.Qra = null;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.figure.isShowing()) {
            return;
        }
        try {
            this.Vra = this.getLatestVal(this.Qra);
            this.Vrv = this.getLatestVal(this.Qrv);
            this.Vla = this.getLatestVal(this.Qla);
            this.Vlv = this.getLatestVal(this.Qlv);
        }
        catch (Xcept x) {
            System.err.println("Exception: " + (Object)((Object)x));
        }
        this.figure.repaint();
    }

    public double getLatestVal(ASVar v) throws Xcept {
        if (v == null) {
            return Double.NaN;
        }
        Data data = this.pmodel.rt().getData(0, (ASQuery)v);
        if (data == null || data.samples() == null) {
            return Double.NaN;
        }
        double[] arr = data.samples();
        int i = arr.length - 1;
        if (data.subset != null) {
            i = data.subset.hix - 1;
        }
        if (i < 0) {
            return Double.NaN;
        }
        return arr[i];
    }

    public void projectContentChanged() {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }
}

