/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.newrmic;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import sun.rmi.rmic.newrmic.BatchEnvironment;
import sun.rmi.rmic.newrmic.Generator;
import sun.rmi.rmic.newrmic.Resources;
import sun.rmi.rmic.newrmic.jrmp.JrmpGenerator;
import sun.tools.util.CommandLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static final Object batchCountLock = new Object();
    private static long batchCount = 0L;
    private static final Map<Long, Batch> batchTable = Collections.synchronizedMap(new HashMap());
    private final PrintStream out;
    private final String program;

    public static void main(String[] stringArray) {
        Main main = new Main(System.err, "rmic");
        System.exit(main.compile(stringArray) ? 0 : 1);
    }

    public Main(OutputStream outputStream, String string) {
        this.out = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
        this.program = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compile(String[] stringArray) {
        boolean bl;
        long l;
        long l2 = System.currentTimeMillis();
        Object object = batchCountLock;
        synchronized (object) {
            l = batchCount++;
        }
        object = this.parseArgs(stringArray);
        if (object == null) {
            return false;
        }
        try {
            batchTable.put(l, (Batch)object);
            bl = this.invokeJavadoc((Batch)object, l);
        }
        finally {
            batchTable.remove(l);
        }
        if (((Batch)object).verbose) {
            long l3 = System.currentTimeMillis() - l2;
            this.output(Resources.getText("rmic.done_in", Long.toString(l3)));
        }
        return bl;
    }

    public void output(String string) {
        this.out.println(string);
    }

    public void error(String string, String ... stringArray) {
        this.output(Resources.getText(string, stringArray));
    }

    public void usage() {
        this.error("rmic.usage", this.program);
    }

    private Batch parseArgs(String[] stringArray) {
        int n;
        Batch batch = new Batch();
        try {
            stringArray = CommandLine.parse(stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error("rmic.cant.read", fileNotFoundException.getMessage());
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.out);
            return null;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-Xnew")) {
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-show")) {
                this.error("rmic.option.unsupported", stringArray[n]);
                this.usage();
                return null;
            }
            if (stringArray[n].equals("-O")) {
                this.error("rmic.option.unsupported", stringArray[n]);
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-debug")) {
                this.error("rmic.option.unsupported", stringArray[n]);
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-depend")) {
                this.error("rmic.option.unsupported", stringArray[n]);
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-keep") || stringArray[n].equals("-keepgenerated")) {
                batch.keepGenerated = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-g")) {
                batch.debug = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-nowarn")) {
                batch.noWarn = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-nowrite")) {
                batch.noWrite = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-verbose")) {
                batch.verbose = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-Xnocompile")) {
                batch.noCompile = true;
                batch.keepGenerated = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-bootclasspath")) {
                if (n + 1 >= stringArray.length) {
                    this.error("rmic.option.requires.argument", stringArray[n]);
                    this.usage();
                    return null;
                }
                if (batch.bootClassPath != null) {
                    this.error("rmic.option.already.seen", stringArray[n]);
                    this.usage();
                    return null;
                }
                stringArray[n] = null;
                batch.bootClassPath = stringArray[++n];
                assert (batch.bootClassPath != null);
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-extdirs")) {
                if (n + 1 >= stringArray.length) {
                    this.error("rmic.option.requires.argument", stringArray[n]);
                    this.usage();
                    return null;
                }
                if (batch.extDirs != null) {
                    this.error("rmic.option.already.seen", stringArray[n]);
                    this.usage();
                    return null;
                }
                stringArray[n] = null;
                batch.extDirs = stringArray[++n];
                assert (batch.extDirs != null);
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-classpath")) {
                if (n + 1 >= stringArray.length) {
                    this.error("rmic.option.requires.argument", stringArray[n]);
                    this.usage();
                    return null;
                }
                if (batch.classPath != null) {
                    this.error("rmic.option.already.seen", stringArray[n]);
                    this.usage();
                    return null;
                }
                stringArray[n] = null;
                batch.classPath = stringArray[++n];
                assert (batch.classPath != null);
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-d")) {
                if (n + 1 >= stringArray.length) {
                    this.error("rmic.option.requires.argument", stringArray[n]);
                    this.usage();
                    return null;
                }
                if (batch.destDir != null) {
                    this.error("rmic.option.already.seen", stringArray[n]);
                    this.usage();
                    return null;
                }
                stringArray[n] = null;
                batch.destDir = new File(stringArray[++n]);
                assert (batch.destDir != null);
                stringArray[n] = null;
                if (batch.destDir.exists()) continue;
                this.error("rmic.no.such.directory", batch.destDir.getPath());
                this.usage();
                return null;
            }
            if (stringArray[n].equals("-v1.1") || stringArray[n].equals("-vcompat") || stringArray[n].equals("-v1.2")) {
                JrmpGenerator jrmpGenerator = new JrmpGenerator();
                batch.generators.add(jrmpGenerator);
                if (jrmpGenerator.parseArgs(stringArray, this)) continue;
                return null;
            }
            if (stringArray[n].equalsIgnoreCase("-iiop")) {
                this.error("rmic.option.unimplemented", stringArray[n]);
                return null;
            }
            if (stringArray[n].equalsIgnoreCase("-idl")) {
                this.error("rmic.option.unimplemented", stringArray[n]);
                return null;
            }
            if (!stringArray[n].equalsIgnoreCase("-xprint")) continue;
            this.error("rmic.option.unimplemented", stringArray[n]);
            return null;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            if (stringArray[n].startsWith("-")) {
                this.error("rmic.no.such.option", stringArray[n]);
                this.usage();
                return null;
            }
            batch.classes.add(stringArray[n]);
        }
        if (batch.classes.isEmpty()) {
            this.usage();
            return null;
        }
        if (batch.generators.isEmpty()) {
            batch.generators.add(new JrmpGenerator());
        }
        return batch;
    }

    public static boolean start(RootDoc rootDoc) {
        BatchEnvironment batchEnvironment;
        Object object3;
        long l = -1L;
        for (String[] stringArray : rootDoc.options()) {
            if (!stringArray[0].equals("-batchID")) continue;
            try {
                l = Long.parseLong(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AssertionError((Object)numberFormatException);
            }
        }
        Batch batch = batchTable.get(l);
        assert (batch != null);
        try {
            object3 = batch.envClass.getConstructor(RootDoc.class);
            batchEnvironment = ((Constructor)object3).newInstance(rootDoc);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
        batchEnvironment.setVerbose(batch.verbose);
        object3 = batch.destDir;
        if (object3 == null) {
            object3 = new File(System.getProperty("user.dir"));
        }
        for (String object22 : batch.classes) {
            ClassDoc classDoc = rootDoc.classNamed(object22);
            try {
                for (Generator generator : batch.generators) {
                    generator.generate(batchEnvironment, classDoc, (File)object3);
                }
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        boolean bl = true;
        List<File> list = batchEnvironment.generatedFiles();
        if (!(batch.noCompile || batch.noWrite || list.isEmpty())) {
            bl = batch.enclosingMain().invokeJavac(batch, list);
        }
        if (!batch.keepGenerated) {
            for (Object nullPointerException : list) {
                ((File)nullPointerException).delete();
            }
        }
        return bl;
    }

    public static int optionLength(String string) {
        if (string.equals("-batchID")) {
            return 2;
        }
        return 0;
    }

    private boolean invokeJavadoc(Batch batch, long l) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-private");
        arrayList.add("-Xclasses");
        if (batch.verbose) {
            arrayList.add("-verbose");
        }
        if (batch.bootClassPath != null) {
            arrayList.add("-bootclasspath");
            arrayList.add(batch.bootClassPath);
        }
        if (batch.extDirs != null) {
            arrayList.add("-extdirs");
            arrayList.add(batch.extDirs);
        }
        if (batch.classPath != null) {
            arrayList.add("-classpath");
            arrayList.add(batch.classPath);
        }
        arrayList.add("-batchID");
        arrayList.add(Long.toString(l));
        HashSet<String> hashSet = new HashSet<String>();
        for (Generator object : batch.generators) {
            hashSet.addAll(object.bootstrapClassNames());
        }
        hashSet.addAll(batch.classes);
        for (String string : hashSet) {
            arrayList.add(string);
        }
        int n = com.sun.tools.javadoc.Main.execute((String)this.program, (PrintWriter)new PrintWriter(this.out, true), (PrintWriter)new PrintWriter(this.out, true), (PrintWriter)new PrintWriter(this.out, true), (String)this.getClass().getName(), (String[])arrayList.toArray(new String[arrayList.size()]));
        return n == 0;
    }

    private boolean invokeJavac(Batch batch, List<File> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-nowarn");
        if (batch.debug) {
            arrayList.add("-g");
        }
        if (batch.verbose) {
            arrayList.add("-verbose");
        }
        if (batch.bootClassPath != null) {
            arrayList.add("-bootclasspath");
            arrayList.add(batch.bootClassPath);
        }
        if (batch.extDirs != null) {
            arrayList.add("-extdirs");
            arrayList.add(batch.extDirs);
        }
        if (batch.classPath != null) {
            arrayList.add("-classpath");
            arrayList.add(batch.classPath);
        }
        arrayList.add("-source");
        arrayList.add("1.3");
        arrayList.add("-target");
        arrayList.add("1.1");
        for (File file : list) {
            arrayList.add(file.getPath());
        }
        int n = com.sun.tools.javac.Main.compile(arrayList.toArray(new String[arrayList.size()]), new PrintWriter(this.out, true));
        return n == 0;
    }

    private class Batch {
        boolean keepGenerated = false;
        boolean debug = false;
        boolean noWarn = false;
        boolean noWrite = false;
        boolean verbose = false;
        boolean noCompile = false;
        String bootClassPath = null;
        String extDirs = null;
        String classPath = null;
        File destDir = null;
        List<Generator> generators = new ArrayList<Generator>();
        Class<? extends BatchEnvironment> envClass = BatchEnvironment.class;
        List<String> classes = new ArrayList<String>();

        Batch() {
        }

        Main enclosingMain() {
            return Main.this;
        }
    }
}

