/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.btex;

import JSim.bcl.btex.BComp;
import JSim.bcl.btex.Chem;
import JSim.bcl.btex.FlowComp;
import JSim.bcl.btex.FlowSource;
import JSim.bcl.btex.Inject;
import JSim.mml.Comp;
import JSim.mml.RealNVar;
import JSim.util.Expr;
import JSim.util.Unit;
import JSim.util.Xcept;

public abstract class Flow
extends BComp {
    FlowComp incomp;
    FlowComp outcomp;
    RealNVar F;
    Inject.List inject;
    Expr srcFin;

    public Flow(Comp p, String n, Expr.List e) throws Xcept {
        super(p, n, e);
        this.F = new RealNVar(this, "F", this.sys.tlist());
        this.inject = new Inject.List(1);
        for (int i = 0; i < this.sys.chem.size(); ++i) {
            this.addChem(this.sys.chem.chem(i));
        }
    }

    protected void addChem(Chem c) throws Xcept {
        RealNVar v = new RealNVar(this, c.name() + "conc", this.sys.tlist());
    }

    protected void attach(boolean isin, FlowComp fc) throws Xcept {
        if (isin) {
            this.incomp = fc;
        } else {
            this.outcomp = fc;
        }
        fc.attach(!isin, this);
    }

    protected void attach(Inject i) {
        this.inject.add((Object)i);
    }

    protected void setInflow(Expr fx) throws Xcept {
        if (((Object)((Object)this)).getClass() == FlowSource.class) {
            this.srcFin = fx;
        } else {
            this.setVar(this.F, fx, true);
        }
    }

    protected void solve2() throws Xcept {
        super.solve2();
        for (int i = 0; i < this.sys.chem.size(); ++i) {
            Chem c = this.sys.chem.chem(i);
            Object e = Expr.zero;
            if (this.incomp != null) {
                e = this.incomp.conc(c);
                if (this.srcFin != null) {
                    e = e.mult(this.srcFin.div((Expr)this.F));
                }
            }
            for (int j = 0; j < this.inject.size(); ++j) {
                Inject inj = (Inject)this.inject.comp(j);
                if (inj.chem != c) continue;
                e = e.add(inj.rate.div((Expr)this.F));
            }
            this.setVar(this.conc(c), (Expr)e, true);
        }
    }

    public String compatibleUnit() {
        return "liter";
    }

    public void assignUnits() throws Xcept {
        super.assignUnits();
        Unit funit = this.unit.div(this.sys.t.unit());
        this.setVarUnit(this.F, funit);
        for (int i = 0; i < this.sys.chem.size(); ++i) {
            Chem c = this.sys.chem.chem(i);
            RealNVar v = this.conc(c);
            Unit vunit = c.unit().div(this.unit);
            this.setVarUnit(v, vunit);
        }
    }

    public static class List
    extends Comp.List {
        public List(int n) {
            super(n);
        }
    }
}

