/*
 * Decompiled with CFR 0.152.
 */
package JSim.bcl.mfax;

import JSim.bcl.mfax.Chem;
import JSim.bcl.mfax.FastGroup;
import JSim.bcl.mfax.FlowComp;
import JSim.bcl.mfax.Membrane;
import JSim.bcl.mfax.Production;
import JSim.bcl.mfax.Reaction;
import JSim.bcl.mfax.ReactionFast;
import JSim.mml.Comp;
import JSim.mml.RealNVar;
import JSim.mml.SubDom;
import JSim.util.Expr;
import JSim.util.Xcept;

public abstract class Region
extends FlowComp {
    protected RealNVar vol;
    Membrane.List mem = new Membrane.List(1);
    Production.List prod = new Production.List(1);
    Reaction.List reac = new Reaction.List(1);
    FastGroup.List fastGroups;
    Chem.List fastChem;

    public Region(Comp c, String n, Expr.List e) throws Xcept {
        super(c, n, e);
        this.vol = new RealNVar(this, "vol", null);
        this.checkNParm(e, 0);
        for (int i = 0; i < this.sys.chem.size(); ++i) {
            this.addChem(this.sys.chem.chem(i));
        }
    }

    protected void attach(Membrane m) {
        this.mem.add((Object)m);
    }

    protected void attach(Production p) {
        this.prod.add((Object)p);
    }

    protected void attach(Reaction q) {
        this.reac.add((Object)q);
    }

    protected void solve2() throws Xcept {
        int i;
        super.solve2();
        this.fastGroups = new FastGroup.List(4);
        this.fastChem = new Chem.List(4);
        boolean[] rfast = new boolean[this.reac.size()];
        for (i = 0; i < rfast.length; ++i) {
            rfast[i] = this.reac.reac(i).isFast();
        }
        for (i = 0; i < rfast.length; ++i) {
            if (!rfast[i]) continue;
            ReactionFast wr = (ReactionFast)this.reac.reac(i);
            FastGroup wgroup = new FastGroup(this, wr);
            rfast[i] = false;
            boolean working = true;
            while (working) {
                working = false;
                for (int j = i + 1; j < rfast.length; ++j) {
                    if (!rfast[j]) continue;
                    wr = (ReactionFast)this.reac.reac(j);
                    if (!wgroup.chem.xsects(wr.eqn.chem)) continue;
                    wgroup.add(wr);
                    rfast[j] = false;
                    working = true;
                }
            }
        }
        for (i = 0; i < this.sys.chem.size(); ++i) {
            Chem c = this.sys.chem.chem(i);
            if (this.isFast(c)) continue;
            RealNVar v = this.conc(c);
            if (this.varSet(SubDom.entire(), v)) continue;
            this.setVar(this.sys.t.lhbc(), v, (Expr)Expr.zero, false);
            Expr e = this.slowDelta(c);
            this.setVar(v.deriv(this.sys.t), e, false);
        }
        for (i = 0; i < this.fastGroups.size(); ++i) {
            this.fastGroups.group(i).solve2();
        }
    }

    protected abstract Expr slowDelta(Chem var1) throws Xcept;

    protected boolean isFast(Chem c) {
        return this.fastChem.contains((Object)c);
    }

    protected Expr uClamp(Chem c) throws Xcept {
        return this.varExpr(SubDom.entire(), this.conc(c));
    }

    protected Expr utClamp(Chem c) throws Xcept {
        return this.varExpr(SubDom.entire(), this.conc(c).deriv(this.sys.t));
    }

    public String compatibleUnit() {
        return "liter";
    }

    public void assignUnits() throws Xcept {
        super.assignUnits();
        this.setVarUnit(this.vol, this.unit);
        this.assignConcUnits();
    }
}

