/*
 * Decompiled with CFR 0.152.
 */
package JSim.cellml;

import JSim.cellml.CMLDoc;
import JSim.util.DiagInfo;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Unit;
import JSim.util.UnitNList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CMLUnit
implements Named {
    private CMLDoc doc;
    private String cmlName;
    private String mmlName;
    private Unit unit;
    private boolean fundamental;

    protected CMLUnit(CMLDoc d, Element elem) throws Xcept {
        this.doc = d;
        this.cmlName = elem.getAttribute("name");
        Util.verbose((String)("processing unit " + this.cmlName));
        this.unit = Unit.scalar();
        NodeList nodes = elem.getElementsByTagName("unit");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Unit u = this.getSubUnit((Element)nodes.item(i));
            double exp = this.getExponent((Element)nodes.item(i));
            if (Math.abs(exp) != 1.0) {
                u = u.power(Math.abs(exp));
            }
            this.unit = exp > 0.0 ? this.unit.mult(u) : this.unit.div(u);
        }
        if (this.conflict(this.doc.preUnits, this.cmlName, this.unit)) {
            throw new Xcept("Illegal redefinition of pre-defined unit  " + this.cmlName);
        }
        this.mmlName = this.conflict(this.doc.sysUnits, this.cmlName, this.unit) ? this.uniqueName(this.cmlName) : this.cmlName;
        this.unit = new Unit(this.mmlName, this.unit);
        this.fundamental = elem.getAttribute("base_units").equals("yes");
        if (!this.fundamental) {
            return;
        }
        this.doc.preUnits.addFund(this.mmlName);
        this.unit = this.doc.preUnits.byName(this.mmlName);
    }

    private Unit getSubUnit(Element elem) throws Xcept {
        Unit u;
        String base = elem.getAttribute("units");
        try {
            u = this.doc.preUnits.byName(base);
        }
        catch (Xcept e) {
            CMLUnit ubase = this.doc.units.unit(base);
            if (ubase == null) {
                throw new Xcept((DiagInfo)this, "Undefined basic unit:" + base);
            }
            u = ubase.unit();
        }
        String pfx = elem.getAttribute("prefix");
        if (Util.isBlank((String)pfx)) {
            return u;
        }
        UnitNList.Prefix upfx = this.doc.preUnits.prefixes.prefix(pfx);
        try {
            double mult = upfx == null ? Math.pow(10.0, Util.toInt((String)pfx)) : upfx.mult();
            return new Unit(pfx + base, u.f * mult, u.dim);
        }
        catch (Xcept e) {
            throw new Xcept((DiagInfo)this, "Illegal unit prefix: " + pfx);
        }
    }

    private double getExponent(Element elem) throws Xcept {
        String kexp = elem.getAttribute("exponent");
        return Util.isBlank((String)kexp) ? 1.0 : Util.toDouble((String)kexp);
    }

    private boolean conflict(UnitNList units, String n, Unit u) {
        try {
            Unit u0 = units.byName(n);
            return !Unit.same((Unit)u, (Unit)u0);
        }
        catch (Xcept e) {
            return false;
        }
    }

    private String uniqueName(String n) {
        while (this.doc.sysUnits.defined(n = n + "_") || this.doc.units.unit(n) != null) {
        }
        return n;
    }

    public void writeMML(PrintWriter out) throws Xcept {
        if (this.fundamental) {
            out.println("unit " + this.mmlName + " = fundamental;");
            return;
        }
        try {
            Unit pu = this.doc.preUnits.byName(this.mmlName);
            out.println("// unit " + this.mmlName + " predefined");
        }
        catch (Xcept e) {
            out.println("unit " + this.mmlName + "=" + this.unit.fundStr(this.doc.preUnits) + ";");
        }
    }

    public String name() {
        return this.cmlName;
    }

    public String diagInfo() {
        return "CellML unit " + this.name();
    }

    public Unit unit() {
        return this.unit;
    }

    public static class NList
    extends NamedList {
        public NList() {
            super(16);
        }

        public CMLUnit unit(int i) {
            return (CMLUnit)this.get(i);
        }

        public CMLUnit unit(String n) {
            return (CMLUnit)this.getByName(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<CMLUnit> {
        public CMLUnit unit(int i) {
            return (CMLUnit)this.get(i);
        }
    }
}

