/*
 * Decompiled with CFR 0.152.
 */
package JSim.cellml;

import JSim.cellml.CMLDoc;
import JSim.cellml.CMLVar;
import JSim.util.DiagInfo;
import JSim.util.StringList;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.util.ArrayList;

public class CMLVarGroup
implements DiagInfo {
    private CMLDoc doc;
    protected String mmlName;
    protected CMLVar.List vars;
    protected StringList varNames;
    protected boolean isDomain;
    protected boolean isInput;
    private String initVal;
    private Unit unit;
    protected boolean hasDeriv;
    protected boolean hasLHSEqn;
    protected List domains;

    public CMLVarGroup(CMLDoc d, CMLVar v) throws Xcept {
        this.doc = d;
        this.vars = new CMLVar.List(4);
        this.varNames = new StringList();
        Util.verbose((String)"new CMLVarGroup");
        this.isInput = true;
        this.add(v);
        this.mmlName = v.fullName();
    }

    private void add(CMLVar v) throws Xcept {
        int i;
        String vname;
        if (v.varGroup != null) {
            return;
        }
        Util.verbose((String)("  adding " + v.fullName()));
        this.vars.add(v);
        v.varGroup = this;
        if (v.isDomain) {
            this.isDomain = true;
        }
        if (!v.isInput) {
            this.isInput = false;
        }
        if (!Util.isBlank((String)v.initVal)) {
            this.initVal = v.initVal;
        }
        if (v.unit != null) {
            this.unit = v.unit;
        }
        if (v.hasDeriv) {
            this.hasDeriv = true;
        }
        if (v.comp.hasLHSEqn(v)) {
            this.hasLHSEqn = true;
        }
        if (!this.varNames.containSame(vname = v.name())) {
            for (i = 0; i < this.varNames.size() && vname.length() > this.varNames.str(i).length(); ++i) {
            }
            if (i >= this.varNames.size() || !vname.equals(this.varNames.str(i))) {
                this.varNames.add((Object)vname);
            }
        }
        for (i = 0; i < v.connectVars.size(); ++i) {
            this.add(v.connectVars.var(i));
        }
    }

    protected void writeMML(PrintWriter out) throws Xcept {
        if (this.isDomain) {
            out.println("\trealDomain " + this.mmlName + " " + this.unit.pubName() + ";");
            out.println("\t" + this.mmlName + ".min=0;");
            out.println("\textern " + this.mmlName + ".max;");
            out.println("\textern " + this.mmlName + ".delta;");
        } else {
            boolean isExtern = !this.hasLHSEqn && !this.hasDeriv && Util.isBlank((String)this.initVal);
            out.println("\t" + (isExtern ? "extern " : "") + "real " + this.mmlName + this.domains.mmlName() + " " + this.unit.pubName() + ";");
        }
        if (this.hasDeriv && Util.isBlank((String)this.initVal)) {
            Util.verbose((String)("Assuming zero initial-condition for " + this.mmlName));
            this.initVal = "0";
        }
        if (Util.isBlank((String)this.initVal)) {
            return;
        }
        String SD = "";
        if (this.hasDeriv) {
            String tname = this.icDomain().mmlName;
            SD = "when(" + tname + "=" + tname + ".min) ";
        }
        String comment = this.hasLHSEqn ? "//CELLML INITVAL: " : "";
        out.println("\t" + comment + SD + this.mmlName + "=" + this.initVal + ";");
    }

    protected void loadVarDomains() throws Xcept {
        this.domains = new List(2);
        for (int i = 0; i < this.vars.size(); ++i) {
            CMLVar v = this.vars.var(i);
            for (int j = 0; j < v.domains.size(); ++j) {
                CMLVar x = (CMLVar)((Object)v.domains.get(j));
                CMLVarGroup xg = x.varGroup;
                this.domains.addUniq(xg);
            }
        }
    }

    protected CMLVarGroup icDomain() throws Xcept {
        if (this.domains.size() < 1) {
            throw new Xcept((DiagInfo)this, "Variable missing IC domain");
        }
        return this.domains.varGroup(0);
    }

    public String diagInfo() {
        return "CellML VarGroup " + this.mmlName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<CMLVarGroup> {
        public List(int n) {
            super(n);
        }

        public CMLVarGroup varGroup(int i) {
            return (CMLVarGroup)this.get(i);
        }

        public void addUniq(CMLVarGroup v) {
            if (!this.contains(v)) {
                this.add(v);
            }
        }

        public boolean addAll(List list) {
            boolean addany = false;
            for (int i = 0; i < list.size(); ++i) {
                CMLVarGroup vg = list.varGroup(i);
                if (this.contains(vg)) continue;
                addany = true;
                this.add(vg);
            }
            return addany;
        }

        public String mmlName() {
            if (this.size() == 0) {
                return "";
            }
            String s = "(";
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    s = s + ",";
                }
                s = s + this.varGroup((int)i).mmlName;
            }
            return s + ")";
        }
    }
}

