/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode;

import JSim.jcode.JPlanWriter;
import JSim.jcode.JSubWriter;
import JSim.mml.Var;
import JSim.plan.Cache;
import JSim.plan.FzeroProc;
import JSim.plan.FzeroToolIF;
import JSim.util.Context;
import JSim.util.Xcept;

public class JFzeroWriter
extends JSubWriter {
    public JFzeroWriter(JPlanWriter w) {
        super(w);
    }

    public void writeClass(FzeroProc proc) throws Xcept {
        if (proc.tool.isLinear()) {
            this.write1Class(proc);
        } else {
            this.write2Class(proc);
        }
    }

    public void write(FzeroProc proc) throws Xcept {
        if (proc.tool.isLinear()) {
            this.write1(proc);
        } else {
            this.write2(proc);
        }
    }

    public void write1Class(FzeroProc proc) throws Xcept {
        FzeroToolIF tool = proc.tool;
        int n = tool.exprs().size();
        this.println("// linear zero finder solving " + (Object)((Object)tool.vsol()));
        this.println("public class " + proc.name.toUpperCase() + " extends Fzero1Problem {");
        this.indentIn();
        this.println("// constructor");
        this.println("public " + proc.name.toUpperCase() + "(RTModel m) throws Xcept { super(m, \"" + proc.name + "\", " + tool.exprs().size() + "); }");
        this.println("");
        this.writeXCall(proc.name, "void", "setCoef", "double[] mat, double[] vec, double[] res", "mat, vec, res", null);
        this.writeXCall(proc.name, "void", "export", "double[] val", "val", null);
        this.indentOut();
        this.println("}");
    }

    public void write1(FzeroProc proc) throws Xcept {
        int i;
        FzeroToolIF tool = proc.tool;
        int n = tool.exprs().size();
        this.println("// set matrix and constant coefficients");
        this.println("public void " + proc.name + "_setCoef(");
        this.println("double[] mat, double[] vec, double[] res) throws Xcept {");
        this.indentIn();
        for (i = 0; i < n * n; ++i) {
            this.println("mat[" + i + "] = " + tool.linmat(i).toString((Context)this.ctxt) + ";");
        }
        for (i = 0; i < n; ++i) {
            this.println("vec[" + i + "] = " + tool.lincons(i).toString((Context)this.ctxt) + ";");
        }
        this.writeInterruptCheck();
        this.indentOut();
        this.println("}");
        this.println("");
        this.println("// export final values");
        this.println("public void " + proc.name + "_export(double[] val) throws Xcept {");
        this.indentIn();
        for (i = 0; i < tool.vsol().size(); ++i) {
            Var v = tool.vsol().var(i);
            Cache pcache = proc.parentCache;
            if (pcache.v0.contains((Object)v)) {
                this.println(this.ctxt.vcache(v) + " = val[" + i + "];");
                continue;
            }
            this.println("set(" + this.ctxt.vstruct(v) + ", val[" + i + "]);");
        }
        this.writeInterruptCheck();
        this.indentOut();
        this.println("}");
        this.println("");
    }

    public void write2Class(FzeroProc proc) throws Xcept {
        FzeroToolIF tool = proc.tool;
        int n = tool.exprs().size();
        String sd = "";
        if (!tool.sdsol().isEntire()) {
            sd = " for " + tool.sdsol();
        }
        this.println("// non-linear zero finder solving " + (Object)((Object)tool.vsol()) + sd);
        this.println("public class " + proc.name.toUpperCase() + " extends Fzero2Problem {");
        this.indentIn();
        this.println("// constructor");
        this.println("public " + proc.name.toUpperCase() + "(RTModel m) throws Xcept { super(m, \"" + proc.name + "\", " + tool.exprs().size() + "); }");
        this.println("");
        this.writeXCall(proc.name, "void", "setBounds", "double[] vmin, double[] vmax, double[] vguess", "vmin, vmax, vguess", null);
        this.writeXCall(proc.name, "void", "calcZero", "double[] val, double[] zero", "val, zero", null);
        this.writeXCall(proc.name, "void", "export", "double[] val", "val", null);
        this.writeLoopDomains(proc.loopDomains(), null);
        this.indentOut();
        this.println("}");
    }

    public void write2(FzeroProc proc) throws Xcept {
        int i;
        FzeroToolIF tool = proc.tool;
        int n = tool.exprs().size();
        this.println("// set bounds & initial guesses, if any");
        this.println("public void " + proc.name + "_setBounds(");
        this.println("double[] vmin, double[] vmax, double[] vguess) throws Xcept {");
        this.indentIn();
        for (i = 0; i < n; ++i) {
            if (tool.vmin(i) != null) {
                this.println("vmin[" + i + "] = " + tool.vmin(i).toString((Context)this.ctxt) + ";");
            }
            if (tool.vmax(i) != null) {
                this.println("vmax[" + i + "] = " + tool.vmax(i).toString((Context)this.ctxt) + ";");
            }
            if (tool.vapprox(i) == null) continue;
            this.println("vguess[" + i + "] = " + tool.vapprox(i).toString((Context)this.ctxt) + ";");
        }
        this.indentOut();
        this.println("}");
        this.println("");
        this.println("// calculate zeroes");
        this.println("public void " + proc.name + "_calcZero(double[] val, double[] zero) throws Xcept {");
        this.indentIn();
        for (i = 0; i < n; ++i) {
            this.println(this.ctxt.vcache(tool.vsol().var(i)) + " = val[" + i + "];");
        }
        for (i = 0; i < n; ++i) {
            this.println("zero[" + i + "] = " + proc.tool.exprs().expr(i).toString((Context)this.ctxt) + ";");
        }
        this.writeInterruptCheck();
        this.indentOut();
        this.println("}");
        this.println("");
        this.println("// export final values");
        this.println("public void " + proc.name + "_export(double[] val) throws Xcept {");
        this.indentIn();
        for (i = 0; i < n; ++i) {
            Var v = tool.vsol().var(i);
            this.println("set(" + this.ctxt.vstruct(v) + ", val[" + i + "]);");
        }
        this.writeInterruptCheck();
        this.indentOut();
        this.println("}");
        this.println("");
    }
}

