/*
 * Decompiled with CFR 0.152.
 */
package JSim.jcode;

import JSim.aserver.ASInfo;
import JSim.jcode.JCalcWriter;
import JSim.jcode.JContext;
import JSim.jcode.JFuncWriter;
import JSim.jcode.JFzeroWriter;
import JSim.jcode.JLang;
import JSim.jcode.JODEWriter;
import JSim.jcode.JPDEWriter;
import JSim.mml.ChoiceNVar;
import JSim.mml.Domain;
import JSim.mml.MathSys;
import JSim.mml.Var;
import JSim.plan.DomainCalc;
import JSim.plan.ExprCalc;
import JSim.plan.FuncCalc;
import JSim.plan.FzeroProc;
import JSim.plan.IfCalc;
import JSim.plan.LoopCalc;
import JSim.plan.MultiCalc;
import JSim.plan.ODEProc;
import JSim.plan.PDEProc;
import JSim.plan.PlanIF;
import JSim.plan.PlanWriter;
import JSim.plan.Proc;
import JSim.plan.ProcCalc;
import JSim.plan.RelationCalc;
import JSim.plan.SetCalc;
import JSim.plan.TopProc;
import JSim.util.Expr;
import JSim.util.StringList;
import JSim.util.Unit;
import JSim.util.UnitNList;
import JSim.util.Xcept;

public class JPlanWriter
extends PlanWriter {
    protected MathSys math;
    protected JContext ctxt;
    protected String cname;
    protected JCalcWriter calcWriter;
    protected JFzeroWriter fzeroWriter;
    protected JODEWriter odeWriter;
    protected JPDEWriter pdeWriter;
    protected JFuncWriter funcWriter;
    protected ASInfo.Build buildInfo;
    protected StringList traceVars;
    protected String methodType;
    protected String methodBase;
    protected String methodDeclArgs;
    protected String methodCallArgs;
    protected static int methodLineMax = 1000;
    protected static int methodCharMax = 64000;
    protected int methodLineCt;
    protected int methodCharCt;
    protected int methodSfx;

    public JPlanWriter(PlanIF p, String cnam) throws Xcept {
        super(p, JLang.lang);
        this.math = this.plan.math();
        this.ctxt = new JContext(this);
        this.cname = cnam;
        this.calcWriter = new JCalcWriter(this);
        this.fzeroWriter = new JFzeroWriter(this);
        this.odeWriter = new JODEWriter(this);
        this.pdeWriter = new JPDEWriter(this);
        this.funcWriter = new JFuncWriter(this);
        this.buildInfo = new ASInfo.Build();
    }

    public void setDebug(ASInfo.Build binfo) {
        this.buildInfo = binfo;
        String s = binfo.options.stringVal("traceVars", null);
        if (s != null) {
            this.traceVars = new StringList(s, ", ");
        }
    }

    protected void write() throws Xcept {
        Proc p;
        Var v;
        int i;
        Var v2;
        int i2;
        this.stopMethod();
        this.println("// JSim generated model " + this.cname);
        this.println("");
        this.println("import java.lang.Math;");
        this.println("import JSim.util.*;");
        this.println("import JSim.data.*;");
        this.println("import JSim.jruntime.*;");
        this.println("import JSim.aserver.*;");
        this.println("import JSim.nml.math.NatMath;");
        this.println("");
        this.println("// " + this.cname + " model");
        this.println("public class " + this.cname + " extends RTModel {");
        this.println("");
        this.indentIn();
        this.println("// variable declarations");
        for (int i3 = 0; i3 < this.math.nVar(); ++i3) {
            Var v3 = this.math.var(i3);
            this.println("public " + this.rtClass(v3) + " " + this.ctxt.vstruct(v3) + ";");
        }
        this.println("");
        Var.List vorder = new Var.List(this.math.nVar());
        for (i2 = 0; i2 < this.math.nVar(); ++i2) {
            v2 = this.math.var(i2);
            if (v2.ndim() != 0) continue;
            vorder.add((Object)v2);
        }
        for (i2 = 0; i2 < this.math.nVar(); ++i2) {
            v2 = this.math.var(i2);
            if (!v2.isDomain()) continue;
            vorder.add((Object)v2);
        }
        for (i2 = 0; i2 < this.math.nVar(); ++i2) {
            v2 = this.math.var(i2);
            if (v2.isDomain() || v2.ndim() <= 0) continue;
            vorder.add((Object)v2);
        }
        this.funcWriter.writeDecl();
        this.println("//solver declarations");
        for (i2 = 0; i2 < this.plan.procs().size(); ++i2) {
            Proc proc = this.plan.procs().proc(i2);
            this.println("public " + proc.name().toUpperCase() + " " + proc.name() + ";");
        }
        this.println("");
        this.println("// constructor");
        this.println("public " + this.cname + "(UnitNList u, ASServer.Messenger m) throws Xcept {");
        this.indentIn();
        this.println("super(\"" + this.cname + "\", u, m);");
        this.println("");
        this.startMethod("void", "constructor", "() throws Xcept", "()", false);
        UnitNList units = this.plan.model().units;
        if (units != null) {
            int i4;
            this.println("// unit declarations");
            for (i4 = 0; i4 < units.fund.size(); ++i4) {
                this.println("units.addFund(\"" + units.fund.str(i4) + "\");");
            }
            for (i4 = 0; i4 < this.plan.units().size(); ++i4) {
                Unit u = this.plan.units().unit(i4);
                this.println("units.add(\"" + u.name() + "\", Unit.parse(this, \"" + u.fundStr(units) + "\"));");
            }
            this.println("");
        }
        this.println("// variable instantiation");
        for (i = 0; i < vorder.size(); ++i) {
            String s4;
            v = vorder.var(i);
            int phase = this.plan.phase(v);
            if (!v.isPrivate() && phase < 1) {
                throw new Xcept("Internal Var phase() error in JPlanWriter");
            }
            if (v.isDomain()) {
                Domain x = (Domain)v;
                s4 = this.ctxt.vstruct(x.vmin) + ", " + this.ctxt.vstruct(x.vmax) + ", " + this.ctxt.vstruct(x.vdelta) + ", " + this.ctxt.vstruct(x.vct);
            } else if (v.ndim() == 0) {
                s4 = "null";
            } else {
                s4 = "new RTRealDomain[] {";
                for (int j = 0; j < v.ndim(); ++j) {
                    Domain x = v.domain(j);
                    if (j > 0) {
                        s4 = s4 + ",";
                    }
                    s4 = s4 + this.ctxt.vstruct(x);
                }
                s4 = s4 + "}";
            }
            String s5 = "";
            if (v instanceof ChoiceNVar) {
                ChoiceNVar cv = (ChoiceNVar)v;
                s5 = ", new String[] { " + cv.labels().toString(",", true) + "}, new String[] {" + cv.values().toString(",", true) + "}";
            }
            this.println(this.ctxt.vstruct(v) + " = new " + this.rtClass(v) + "(this, \"" + (Object)((Object)v) + "\", \"" + (Unit.same((Unit)v.unit(), (Unit)Unit.scalar()) ? "dimensionless" : v.unit().name()) + "\", " + phase + ", " + s4 + s5 + ");");
            if (!v.isPrivate()) continue;
            this.println(this.ctxt.vstruct(v) + ".setPrivate();");
        }
        this.println("");
        this.println("// input var defaults");
        for (i = 0; i < this.math.nVar(); ++i) {
            Expr expr;
            v = this.math.var(i);
            if (!this.plan.inputVars().contains((Object)v) || (expr = this.plan.inputDef(v)) == null) continue;
            this.println(this.ctxt.vstruct(v) + ".setDefault(\"" + expr + "\");");
        }
        this.println("");
        this.stopMethod();
        this.funcWriter.writeInit();
        this.println("// solver initialization");
        for (i = 0; i < this.plan.procs().size(); ++i) {
            Proc proc = this.plan.procs().proc(i);
            this.println(proc.name() + " = new " + proc.name().toUpperCase() + "(this);");
            Var.List vlist = new Var.List(4);
            proc.addVars(vlist);
            StringBuffer buf = new StringBuffer(proc.name() + ".setSolvedVars(new ASVar[] {");
            for (int j = 0; j < vlist.size(); ++j) {
                if (j > 0) {
                    buf.append(",");
                }
                buf.append(this.ctxt.vstruct(vlist.var(j)));
            }
            buf.append("});");
            this.println(buf.toString());
        }
        this.println("");
        this.println("// done with sub-class constructor");
        this.println("doneConstructor();");
        this.indentOut();
        this.println("}");
        this.println("");
        this.println("public boolean defaultUnitCorrect() { return " + (this.plan.model().unitControl == 2) + "; }");
        this.println("");
        this.println("// create model-specific run context");
        this.println("public RTContext newRunContext(int threadInx, int nproc, RTDataStore s) {");
        this.indentIn();
        this.println("return new XContext(this, threadInx, nproc, s);");
        this.indentOut();
        this.println("}");
        this.println("");
        this.println("// parallel MP runs allowed in no PDEs or non-reentrant F&P");
        this.println("public boolean allowMPRuns() { return " + this.allowMPRuns() + "; }");
        this.println("");
        this.println("// mainline calculation");
        this.println("public void mainline(RTContext ctxt) throws Xcept {");
        this.indentIn();
        this.println("((XContext) ctxt).mainline();");
        this.indentOut();
        this.println("}");
        this.println("");
        for (i = 0; i < this.plan.procs().size(); ++i) {
            p = this.plan.procs().proc(i);
            this.writeProcClass(p);
            this.println("");
        }
        this.funcWriter.writeFuncClasses();
        this.println("// model-specific context");
        this.println("public class XContext extends RTContext {");
        this.indentIn();
        for (i = 0; i < this.plan.cache().v0.size(); ++i) {
            v = this.plan.cache().v0.var(i);
            String vinit = this.buildInfo.options.boolVal("initNaN", false) ? " = Double.NaN" : "";
            this.println("private double " + this.ctxt.vcache(v) + vinit + ";");
        }
        this.println("");
        this.println("public XContext(RTModel m, int threadInx, int nproc, RTDataStore s) { super(m, threadInx, nproc, s, false); }");
        this.println("");
        this.cache = this.plan.mainProc().cache;
        this.writeMainline(this.plan.mainProc());
        this.println("");
        this.calcWriter.writeCalcGroups();
        for (i = 0; i < this.plan.procs().size(); ++i) {
            p = this.plan.procs().proc(i);
            this.writeProc(p);
            this.println("");
        }
        this.funcWriter.writeXMethods();
        this.indentOut();
        this.println("}");
        this.println("");
        this.indentOut();
        this.println("}");
        this.funcWriter.writeNativeFuncClasses();
        for (i = 0; i < this.plan.model().externJava.size(); ++i) {
            this.println("// extern java\n");
            this.println(this.plan.model().externJava.str(i));
        }
    }

    public void writeProcClass(Proc p) throws Xcept {
        if (p instanceof ODEProc) {
            this.odeWriter.writeClass((ODEProc)p);
        } else if (p instanceof PDEProc) {
            this.pdeWriter.writeClass((PDEProc)p);
        } else if (p instanceof FzeroProc) {
            this.fzeroWriter.writeClass((FzeroProc)p);
        } else {
            throw new Xcept("writeProcClass not implemented for " + p.getClass());
        }
    }

    public void writeMainline(TopProc mproc) throws Xcept {
        this.println("public void " + mproc.name + "() throws Xcept {");
        this.indentIn();
        this.println("// initialize variable caches  (required due to unresolved sequencer errors)");
        this.println("");
        this.println("// load input caches");
        for (int i = 0; i < this.plan.inputVars().size(); ++i) {
            Var v = this.plan.inputVars().var(i);
            if (!this.cache.v0.contains((Object)v)) continue;
            this.println(this.ctxt.vcache(v) + " = " + "realVal(" + this.ctxt.vstruct(v) + ");");
        }
        this.println("");
        this.println("// mainline calculations");
        this.writeCalc(mproc.mcalc);
        this.indentOut();
        this.println("}");
    }

    public void write(TopProc proc) throws Xcept {
        this.println("public void " + proc.name + "() throws Xcept {");
        this.indentIn();
        this.writeCalc(proc.mcalc);
        this.indentOut();
        this.println("}");
    }

    public void write(FzeroProc proc) throws Xcept {
        this.fzeroWriter.write(proc);
    }

    public void write(ODEProc proc) throws Xcept {
        this.odeWriter.write(proc);
    }

    public void write(PDEProc proc) throws Xcept {
        this.pdeWriter.write(proc);
    }

    public void write(ExprCalc calc) throws Xcept {
        this.calcWriter.write(calc);
    }

    public void write(DomainCalc calc) throws Xcept {
        this.calcWriter.write(calc);
    }

    public void write(FuncCalc calc) throws Xcept {
        this.calcWriter.write(calc);
    }

    public void write(SetCalc calc) throws Xcept {
        this.calcWriter.write(calc);
    }

    public void write(LoopCalc calc) throws Xcept {
        this.calcWriter.write(calc);
    }

    public void write(IfCalc calc) throws Xcept {
        this.calcWriter.write(calc);
    }

    public void write(MultiCalc calc) throws Xcept {
        this.calcWriter.write(calc);
    }

    public void write(ProcCalc calc) throws Xcept {
        this.calcWriter.write(calc);
    }

    public void write(RelationCalc calc) throws Xcept {
        this.calcWriter.write(calc);
    }

    public void writeInterruptCheck() {
        this.println("interruptCheck();");
    }

    public void indentIn() {
        ++this.indent;
    }

    public void indentOut() {
        --this.indent;
    }

    public void startMethod(String t, String b, String da, String ca, boolean print) {
        this.methodType = t;
        this.methodBase = b;
        this.methodDeclArgs = da;
        this.methodCallArgs = ca;
        this.methodLineCt = 0;
        this.methodCharCt = 0;
        this.methodSfx = 0;
        if (!print) {
            return;
        }
        this.println("public " + this.methodType + " " + this.methodBase + this.methodDeclArgs + " {");
    }

    public void stopMethod() {
        this.methodBase = null;
    }

    public void println(String s) {
        if (this.methodBase != null && (this.methodLineCt > methodLineMax || this.methodCharCt + s.length() > methodCharMax)) {
            String msg = "// break method at " + this.methodLineCt + " lines " + this.methodCharCt + " chars for javac 64K limit";
            this.methodLineCt = 0;
            this.methodCharCt = 0;
            ++this.methodSfx;
            this.println(this.methodBase + "_" + this.methodSfx + this.methodCallArgs + ";" + msg);
            this.indentOut();
            this.println("}");
            this.println("");
            this.println("// continuation of above method");
            this.println("private " + this.methodType + " " + this.methodBase + "_" + this.methodSfx + this.methodDeclArgs + " {");
            this.indentIn();
        }
        ++this.methodLineCt;
        this.methodCharCt += s.length();
        super.println(s);
    }

    public String rtClass(Var v) {
        String s1;
        String string = s1 = v.isInt() ? "Int" : "Real";
        if (v instanceof ChoiceNVar) {
            s1 = "Choice";
        }
        String s2 = v.isDomain() ? "Domain" : "NVar";
        return "RT" + s1 + s2;
    }
}

