/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.jruntime.RTContext;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTProblem;
import JSim.nml.Solver;
import JSim.nml.SolverCallbacks;
import JSim.nml.fzero.Fzero1Solver;
import JSim.util.Xcept;

public abstract class Fzero1Problem
extends RTProblem
implements SolverCallbacks {
    public int n;

    public Fzero1Problem(RTModel m, String na, int nn) throws Xcept {
        super(m, na);
        this.n = nn;
    }

    public Solver createSolver(int solverInx, RTContext ctxt) throws Xcept {
        return new Fzero1Solver(this, solverInx, ctxt, this.n);
    }

    public void solve(RTContext ctxt) throws Xcept {
        int i;
        this.init(ctxt);
        double[] mat = new double[this.n * this.n];
        double[] vec = new double[this.n];
        double[] res = new double[this.n];
        for (i = 0; i < this.n * this.n; ++i) {
            mat[i] = Double.NaN;
        }
        for (i = 0; i < this.n; ++i) {
            vec[i] = Double.NaN;
            res[i] = Double.NaN;
        }
        this.setCoef(ctxt, mat, vec, res);
        Fzero1Solver solver = (Fzero1Solver)this.solver(ctxt);
        solver.solve(ctxt, mat, vec, res);
        this.export(ctxt, res);
    }

    public String desc() {
        return "linear zero finder";
    }

    public abstract void setCoef(RTContext var1, double[] var2, double[] var3, double[] var4) throws Xcept;

    public abstract void export(RTContext var1, double[] var2) throws Xcept;
}

