/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.aserver.ASVar;
import JSim.jruntime.RTContext;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTRealDomain;
import JSim.nml.Solver;
import JSim.util.DiagInfo;
import JSim.util.Xcept;
import java.util.ArrayList;

public abstract class RTProblem
implements DiagInfo {
    protected RTModel model;
    protected String name;
    protected ASVar[] vsol;
    protected Solver[][] solvers;

    public RTProblem(RTModel m, String n) throws Xcept {
        this.model = m;
        this.name = n;
        this.model.add(this);
    }

    public ASVar[] getSolvedVars() {
        return this.vsol;
    }

    public void setSolvedVars(ASVar[] v) {
        this.vsol = v;
    }

    public String solvedVarsText() {
        if (this.vsol == null) {
            return "{}";
        }
        StringBuffer buf = new StringBuffer("{");
        for (int i = 0; i < this.vsol.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.vsol[i].name());
        }
        buf.append("}");
        return buf.toString();
    }

    public RTRealDomain[] loopDomains() {
        return null;
    }

    protected void allocThreads(int n) throws Xcept {
        this.solvers = new Solver[n][0];
    }

    protected void runPrep(RTContext ctxt) throws Xcept {
        this.solvers[ctxt.threadInx] = new Solver[0];
    }

    public void init(RTContext ctxt) throws Xcept {
        int tx = ctxt.threadInx;
        if (this.solvers[tx].length != 0) {
            return;
        }
        Solver s0 = this.createSolver(0, ctxt);
        int lct = 1;
        if (!s0.isReentrant() && this.loopDomains() != null) {
            RTRealDomain[] doms = this.loopDomains();
            for (int i = 0; i < doms.length; ++i) {
                lct *= ctxt.ct(doms[i]);
            }
        }
        this.solvers[tx] = new Solver[lct];
        this.solvers[tx][0] = s0;
        for (int i = 1; i < lct; ++i) {
            this.solvers[tx][i] = this.createSolver(i, ctxt);
        }
    }

    public Solver solver(RTContext ctxt) throws Xcept {
        int tx = ctxt.threadInx;
        if (this.solvers[tx].length == 1) {
            return this.solvers[tx][0];
        }
        if (this.solvers[tx].length == 0) {
            throw new Xcept((DiagInfo)this, "No solver array for tx=" + tx + ": no init()?");
        }
        int lx = 0;
        RTRealDomain[] doms = this.loopDomains();
        if (doms != null) {
            lx = ctxt.inx(doms[0]);
            for (int i = 1; i < doms.length; ++i) {
                lx = lx * ctxt.ct(doms[i - 1]) + ctxt.inx(doms[i]);
            }
        }
        return this.solvers[tx][lx];
    }

    abstract Solver createSolver(int var1, RTContext var2) throws Xcept;

    protected final void interruptCheck() throws Xcept {
        this.model.interruptCheck();
    }

    public abstract String desc();

    public String diagInfo() {
        return this.desc();
    }

    public String name() {
        return this.name;
    }

    public RTModel model() {
        return this.model;
    }

    public abstract void solve(RTContext var1) throws Xcept;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<RTProblem> {
        public List(int i) {
            super(i);
        }

        public RTProblem prob(int i) {
            return (RTProblem)this.get(i);
        }
    }
}

