/*
 * Decompiled with CFR 0.152.
 */
package JSim.jruntime;

import JSim.jruntime.RTContext;
import JSim.jruntime.RTRealDomain;
import JSim.jruntime.RTRealNVar;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.Named;
import JSim.util.NamedExpr;
import JSim.util.Unit;
import JSim.util.Xcept;

public class RTVarFuncCall
extends Expr {
    public RTRealNVar v;
    public Expr.List args;

    public RTVarFuncCall(RTRealNVar vv, Expr.List a) throws Xcept {
        this.v = vv;
        this.args = a;
        if (this.v.ndim() != this.args.size()) {
            throw new Xcept((DiagInfo)this, "RTVariable requires " + this.v.ndim() + " arguments");
        }
    }

    public boolean sameAs(Expr e) {
        RTVarFuncCall func = null;
        try {
            func = (RTVarFuncCall)e;
        }
        catch (ClassCastException x) {
            return false;
        }
        return this.v.sameAs((Expr)func.v) && this.args.sameAs(func.args);
    }

    public void addNamedExpr(Expr.List list) throws Xcept {
        this.v.addNamedExpr(list);
        for (int i = 0; i < this.args.size(); ++i) {
            this.args.expr(i).addNamedExpr(list);
        }
    }

    public void addDomains(Expr.List list) {
        for (int i = 0; i < this.args.size(); ++i) {
            this.args.expr(i).addDomains(list);
        }
    }

    public int dataType() {
        return 4;
    }

    public double realVal(Context ctxt0) throws Xcept {
        RTContext ctxt = (RTContext)ctxt0;
        double[] xval = new double[this.args.size()];
        for (int i = 0; i < xval.length; ++i) {
            xval[i] = this.args.expr(i).realVal((Context)ctxt);
        }
        return ctxt.realVal(this.v, xval);
    }

    public Expr unitCorrect() throws Xcept {
        Expr.List nargs = new Expr.List(this.args.size());
        for (int i = 0; i < this.args.size(); ++i) {
            RTRealDomain x = (RTRealDomain)this.v.domain(i);
            Expr arg = this.args.expr(i).unitCorrect();
            Unit au = arg.unit();
            Unit xu = x.unit();
            if (!Unit.compatible((Unit)xu, (Unit)au)) {
                throw new Xcept((DiagInfo)this, "Units are not compatible with variable domain " + (Object)((Object)x));
            }
            nargs.add((Object)arg.multUnit(xu, au));
        }
        return new RTVarFuncCall(this.v, nargs);
    }

    public Expr calculable(Known known) {
        return truex;
    }

    public Expr takeDomDeriv(NamedExpr t) throws Xcept {
        throw new Xcept((DiagInfo)this, "takeDeriv not implemented");
    }

    public Expr expandDeriv() throws Xcept {
        throw new Xcept((DiagInfo)this, "expandDeriv not implemented");
    }

    public Unit unit() {
        return this.v.unit();
    }

    public Expr simplify(Known known) throws Xcept {
        throw new Xcept("RTVarFuncCall.simplify() not implemented");
    }

    public String toString() {
        return this.v.toString() + this.args.toString();
    }

    public String toString(Context ctxt) {
        return ctxt.funcCall((Named)this.v, this.args);
    }
}

