/*
 * Decompiled with CFR 0.152.
 */
package JSim.lserver;

import JSim.lserver.LSServer;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LSJavac {
    private LSServer server;
    private String classpath;
    private static String smain = "sun.tools.javac.Main";
    private Constructor cons;
    private Method m_compile;

    public LSJavac(LSServer s) throws Xcept {
        this.server = s;
        try {
            Class<?> clss = this.server.classLoader.loadClass(smain);
            Class[] cargs = new Class[]{OutputStream.class, String.class};
            this.cons = clss.getConstructor(cargs);
            String[] st = new String[]{};
            Class[] margs = new Class[]{st.getClass()};
            this.m_compile = clss.getMethod("compile", margs);
        }
        catch (ClassNotFoundException e) {
            throw new Xcept("Java compiler missing:  no " + smain + " in CLASSPATH=" + this.server.jsimPath());
        }
        catch (NoSuchMethodException e) {
            throw new Xcept(smain + " missing required compile method and/or constructor");
        }
        this.classpath = System.getProperty("java.class.path") + File.pathSeparator + this.server.buildDir + File.pathSeparator + this.server.jsimPath();
    }

    public void compile(File javaFile, PrintStream log) throws Xcept {
        try {
            this.compileMain(javaFile, log);
        }
        catch (InvocationTargetException e) {
            throw new Xcept("" + e.getTargetException());
        }
        catch (Exception e) {
            throw Xcept.wrap((Throwable)e);
        }
    }

    private void compileMain(File javaFile, PrintStream log) throws Exception {
        Util.verbose((String)("==== Compiling model " + javaFile + " via " + smain));
        Object[] cargs = new Object[]{log, "javac"};
        Object main = this.cons.newInstance(cargs);
        String[] jcargs = new String[]{"-nowarn", "-classpath", this.classpath, javaFile.getPath()};
        Object[] margs = new Object[]{jcargs};
        Boolean ret = (Boolean)this.m_compile.invoke(main, margs);
        if (!ret.booleanValue()) {
            throw new Xcept("Java compilation failed for " + javaFile);
        }
    }
}

