/*
 * Decompiled with CFR 0.152.
 */
package JSim.lserver;

import JSim.aserver.ASConstraint;
import JSim.aserver.ASInfo;
import JSim.aserver.ASModel;
import JSim.aserver.ASQuery;
import JSim.aserver.ASServer;
import JSim.aserver.ASVar;
import JSim.data.Data;
import JSim.data.FimData;
import JSim.data.NamedVal;
import JSim.data.OptimResults;
import JSim.data.XMLWriter;
import JSim.jcode.JPlanWriter;
import JSim.jruntime.RTModel;
import JSim.jruntime.RTQuery;
import JSim.jruntime.RTVar;
import JSim.lserver.LSModelFim;
import JSim.lserver.LSModelOptim;
import JSim.lserver.LSServer;
import JSim.mathml.MLWriter;
import JSim.mml.MathSys;
import JSim.mml.Model;
import JSim.mml.ModelReader;
import JSim.mml.SourceFunc;
import JSim.plan.BuildControl;
import JSim.plan.JSPlanWriter;
import JSim.plan.PlanIF;
import JSim.plan.PlanWriter;
import JSim.plan1.Plan;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.MPDispatch;
import JSim.util.Named;
import JSim.util.Plugin;
import JSim.util.UnitNList;
import JSim.util.Util;
import JSim.util.UtilIO;
import JSim.util.UtilXML;
import JSim.util.XFunc;
import JSim.util.Xcept;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LSModel
implements DiagInfo,
ASModel,
BuildControl,
MPDispatch.Monitor,
ASServer.Messenger {
    private static int seq = 100;
    private LSServer server;
    private ASInfo.Build buildInfo;
    private boolean cancelBuild;
    private String name;
    private Model flatModel;
    private PlanIF plan;
    private RTModel rtmodel;
    private String mmlText;
    private File flatFile;
    private File javaFile;
    private int maxBuildTime;
    private long buildStartTime;
    private NamedVal.NList props;
    private ASConstraint.List constraints;
    private int storeMode;
    protected ASInfo.Status jobStat;
    private LSModelOptim optim;
    private LSModelFim fim;

    public LSModel(LSServer s) {
        this.server = s;
        this.unbuildRT();
    }

    public void unbuildRT() {
        this.flatModel = null;
        this.plan = null;
        this.rtmodel = null;
        this.mmlText = null;
        this.javaFile = null;
        this.flatFile = null;
        this.props = null;
        this.constraints = null;
        this.storeMode = 0;
        this.optim = null;
        this.jobStat = new ASInfo.Status(0);
    }

    public void buildRT(ASInfo.Build binfo) throws Xcept {
        this.unbuildRT();
        this.cancelBuild = false;
        this.buildInfo = binfo;
        this.maxBuildTime = binfo.options.intVal("maxBuildTime", 120);
        int smax = this.server.maxBuildTime();
        if (smax > 0 && smax < this.maxBuildTime) {
            this.maxBuildTime = smax;
        }
        this.buildStartTime = System.currentTimeMillis();
        try {
            this.buildRT1();
            this.server.scrubBuildDir();
        }
        catch (Exception e) {
            this.server.scrubBuildDir();
            throw Xcept.wrap((Throwable)e);
        }
    }

    private void buildRT1() throws Xcept {
        File buildDir = this.server.buildDir;
        this.name = this.buildInfo.name.replace('.', '_');
        String modelSource = this.buildInfo.modelSource + "\n";
        int sourceType = this.buildInfo.sourceType;
        String auxName = this.buildInfo.auxName;
        ClassLoader classLoader = this.server.classLoader;
        Util.verbose((String)("==== Build directory is " + buildDir));
        if (!buildDir.exists()) {
            Util.verbose((String)("\tCreating working directory " + buildDir));
            if (!buildDir.mkdir()) {
                throw new Xcept("Could not create directory " + buildDir);
            }
        }
        String outbase = sourceType < 3 ? "JS" + seq++ + this.name : auxName;
        this.mmlText = null;
        this.flatFile = null;
        this.javaFile = null;
        File classFile = null;
        if (sourceType < 3) {
            FileOutputStream jstr;
            String sstr = modelSource;
            StringReader rdr = new StringReader(sstr);
            this.flatModel = new ModelReader(rdr, classLoader, this.server.jsimPath());
            if (this.server.sandbox != null) {
                this.flatModel.checkSandbox();
            }
            if (sourceType == 1) {
                this.mmlText = modelSource;
                this.flatFile = new File(buildDir, outbase + ".flat");
                this.flatModel.flatten(this.flatFile.getPath());
            }
            MathSys math = this.flatModel.getFlatMath();
            this.plan = new Plan(this.flatModel, this);
            JPlanWriter pwriter = new JPlanWriter(this.plan, outbase);
            pwriter.setDebug(this.buildInfo);
            for (int i = 0; i < this.plan.funcs().size(); ++i) {
                XFunc f = this.plan.funcs().xfunc(i);
                if (!(f instanceof SourceFunc)) continue;
                switch (f.lang()) {
                    case 5: 
                    case 6: 
                    case 7: {
                        this.server.nativeCompiler.compile(outbase, (SourceFunc)f);
                    }
                }
            }
            this.javaFile = new File(buildDir, outbase + ".java");
            Util.verbose((String)("\tWriting Java model: " + this.javaFile));
            try {
                jstr = new FileOutputStream(this.javaFile);
            }
            catch (FileNotFoundException e) {
                throw new Xcept((DiagInfo)this, e.getMessage());
            }
            PrintStream jout = new PrintStream(jstr);
            pwriter.write(jout);
        } else {
            this.javaFile = new File(buildDir, auxName + ".java");
            UtilIO.writeText((File)this.javaFile, (String)modelSource);
        }
        Util.verbose((String)("==== Compiling Java model " + this.javaFile));
        this.server.javac.compile(this.javaFile, System.err);
        classFile = new File(buildDir, outbase + ".class");
        String class_name = UtilIO.fileBaseName((File)classFile);
        try {
            Class<?> model_class = classLoader.loadClass(class_name);
            if (!RTModel.class.isAssignableFrom(model_class)) {
                throw new Exception("Class " + class_name + " does not extend RTModel");
            }
            Class[] argc = new Class[]{UnitNList.class, ASServer.Messenger.class};
            Constructor<?> cons = model_class.getConstructor(argc);
            Object[] args = new Object[]{this.server.sysUnits(), this};
            this.rtmodel = (RTModel)cons.newInstance(args);
            this.rtmodel.setMaxProc(this.maxProc());
            this.rtmodel.setOptimFactory(this.server.optimFactory());
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
            throw new Xcept((Throwable)e, "Invocation target error instantiating " + class_name);
        }
        catch (NoSuchMethodException e) {
            throw new Xcept((Throwable)e, "Class " + class_name + " must be public and have public CONSTRUCTOR with one argument");
        }
        catch (IllegalAccessException e) {
            throw new Xcept((Throwable)e, "Class " + class_name + " must be public and have PUBLIC constructor with one argument");
        }
        catch (InstantiationException e) {
            throw new Xcept((Throwable)e, "Error instantiating " + class_name);
        }
        catch (Throwable e) {
            throw new Xcept(e, "Internal error instantiating " + class_name + ": " + e);
        }
    }

    public String buildCancelMessage() {
        if (this.cancelBuild) {
            return "user";
        }
        long delta = System.currentTimeMillis() - this.buildStartTime;
        if (this.maxBuildTime > 0 && delta > (long)(this.maxBuildTime * 1000)) {
            return "timeout (" + this.maxBuildTime + " secs)";
        }
        return null;
    }

    private void checkBuilt(String s) throws Xcept {
        if (this.isBuilt()) {
            return;
        }
        throw new Xcept((DiagInfo)this, s + "() called while model not compiled");
    }

    public String diagInfo() {
        return "LSModel " + this.name;
    }

    public final boolean isBuilt() {
        return this.rtmodel != null;
    }

    public ASVar.List getASVars() throws Xcept {
        this.checkBuilt("getASVars");
        return this.rtmodel.getVars();
    }

    public ASVar getASVar(String n) throws Xcept {
        this.checkBuilt("getASVar");
        return this.rtmodel.getVar(n);
    }

    public ASQuery parseQuery(String s) throws Xcept {
        this.checkBuilt("parseQuery");
        try {
            return this.rtmodel.getVar(s);
        }
        catch (Xcept e) {
            return new RTQuery(this.rtmodel, s);
        }
    }

    public Data getData(int i, ASQuery query) throws Xcept {
        this.checkBuilt("getData");
        if (query instanceof RTVar) {
            return this.rtmodel.getData(i, (Expr)((RTVar)query));
        }
        if (query instanceof RTQuery) {
            return this.rtmodel.getData(i, ((RTQuery)query).expr());
        }
        throw new Xcept("LSModel.getData() requires RTQuery");
    }

    public FimData getFimData() {
        if (this.fim == null) {
            return null;
        }
        return this.fim.fimData();
    }

    public UnitNList units() throws Xcept {
        this.checkBuilt("units");
        return this.rtmodel.units;
    }

    public String getText(int type, String variant) {
        File file = null;
        switch (type) {
            case 10: {
                if (this.plan == null) break;
                try {
                    PlanWriter pwriter = new JSPlanWriter(this.plan);
                    if (variant != null) {
                        Plugin plugin = this.server.plugins().plugin("PlanWriter", variant);
                        if (plugin == null) {
                            throw new Xcept("PlanWriter plugin " + variant + " not found");
                        }
                        pwriter = (PlanWriter)plugin.newInstance(new Class[]{PlanIF.class}, new Object[]{this.plan});
                    }
                    return pwriter.writeText();
                }
                catch (Xcept e) {
                    return "Error creating planning text:" + e.cleanMessage();
                }
            }
            case 12: {
                if (this.flatModel == null) break;
                try {
                    Document doc = UtilXML.createDoc((String)"html");
                    Element html = doc.getDocumentElement();
                    html.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
                    Element body = doc.createElement("body");
                    html.appendChild(body);
                    MLWriter mwrt = new MLWriter(body);
                    mwrt.setParagraphs(true);
                    mwrt.add(this.flatModel);
                    XMLWriter xwrt = new XMLWriter();
                    StringWriter swrt = new StringWriter();
                    xwrt.write(doc, (Writer)swrt);
                    return swrt.toString();
                }
                catch (Exception e) {
                    return "Error creating MathML text: " + e;
                }
            }
            case 13: {
                if (this.plan == null) break;
                try {
                    Document doc = this.plan.getXMML();
                    XMLWriter xwrt = new XMLWriter();
                    StringWriter swrt = new StringWriter();
                    xwrt.write(doc, (Writer)swrt);
                    return swrt.toString();
                }
                catch (Exception e) {
                    return "Error creating XMML text\n" + Util.stackTraceString((Throwable)e);
                }
            }
            case 1: {
                if (this.mmlText == null) break;
                return this.mmlText;
            }
            case 2: {
                file = this.flatFile;
                break;
            }
            case 3: {
                file = this.javaFile;
            }
        }
        if (file == null) {
            return "Text not available for this model.";
        }
        try {
            return UtilIO.readText((File)file);
        }
        catch (Exception e) {
            return "Text not available for this model.";
        }
    }

    public NamedVal.NList getProperties() throws Xcept {
        if (this.props != null) {
            return this.props;
        }
        if (this.flatModel == null) {
            throw new Xcept((DiagInfo)this, "Properties not available");
        }
        MathSys math = this.flatModel.getFlatMath();
        this.props = math.getProperties();
        if (this.plan != null) {
            this.plan.addProperties(this.props);
        }
        return this.props;
    }

    public ASConstraint.List getConstraints() throws Xcept {
        if (this.constraints != null) {
            return this.constraints;
        }
        if (this.flatModel == null) {
            throw new Xcept((DiagInfo)this, "Constraints not available");
        }
        ASConstraint.Info[] info = this.plan != null ? this.plan.getConstraints() : this.flatModel.getFlatMath().getConstraints();
        this.constraints = new ASConstraint.List(info);
        return this.constraints;
    }

    protected int maxProc() {
        int n = this.rtmodel != null && !this.rtmodel.allowMPRuns() ? 1 : this.server.maxProc();
        return n;
    }

    public void singleRun(NamedVal.NList runVals) throws Xcept {
        this.checkCompiled();
        this.rtmodel.cancelRun = false;
        this.storeMode = 0;
        this.jobStat = new ASInfo.Status(1);
        this.jobStat.mode = 0;
        this.jobStat.nruns = 1;
        this.rtmodel.setMaxProc(this.maxProc());
        this.rtmodel.allocStores(1);
        this.rtmodel.setRunVals(runVals);
        this.rtmodel.run(1, this.maxProc(), 0, null);
    }

    public void loopsRun(ASInfo.Loops loops) throws Xcept {
        this.checkCompiled();
        this.rtmodel.cancelRun = false;
        this.storeMode = 1;
        this.jobStat = new ASInfo.Status(loops.n());
        this.jobStat.mode = 1;
        this.jobStat.nruns = loops.n();
        this.jobStat.runName = "parallel loops";
        MPDispatch.Job[] jobs = new MPDispatch.Job[loops.n()];
        for (int i = 0; i < loops.n(); ++i) {
            jobs[i] = new SingleRun(loops.runNames[i], i, loops.nvals[i]);
        }
        this.rtmodel.setMaxProc(this.maxProc());
        this.rtmodel.allocStores(loops.runNames);
        this.rtmodel.setRunVals(loops.baseVals);
        MPDispatch dispatch = new MPDispatch("loops", jobs, (MPDispatch.Monitor)this);
        dispatch.run(this.maxProc());
        this.jobStat.nrunsDone = this.jobStat.nruns;
    }

    public synchronized void jobStarted(MPDispatch.Job job) {
        this.jobStat.runName = job.jobName();
    }

    public synchronized void jobCompleted(MPDispatch.Job job) {
        ++this.jobStat.nrunsDone;
    }

    public void sensRun(ASInfo.Sens sens) throws Xcept {
        this.checkCompiled();
        this.rtmodel.cancelRun = false;
        this.storeMode = 3;
        this.jobStat = new ASInfo.Status(1 + sens.parNames.length);
        this.jobStat.mode = 3;
        this.jobStat.nruns = 1 + sens.parNames.length;
        this.rtmodel.setMaxProc(this.maxProc());
        this.rtmodel.allocStores(sens.parNames, sens.deltas);
        this.rtmodel.setRunVals(sens.baseVals);
        this.jobStat.runName = null;
        this.rtmodel.run(1, 1, 0, null);
        ++this.jobStat.nrunsDone;
        int n = sens.parNames.length;
        MPDispatch.Job[] jobs = new MPDispatch.Job[n];
        for (int i = 0; i < n; ++i) {
            String pname = sens.parNames[i];
            ASQuery q = this.parseQuery(pname);
            Data data = this.getData(0, q);
            double val = data.realVal(0) + sens.deltas[i];
            if (Double.isNaN(val)) {
                throw new Xcept("Sensitivity parameter " + pname + "=NaN");
            }
            NamedVal nval = NamedVal.create((String)pname, (double)val);
            NamedVal.NList nvals = new NamedVal.NList();
            nvals.add((Named)nval);
            jobs[i] = new SingleRun("sens " + pname, i + 1, nvals);
        }
        MPDispatch dispatch = new MPDispatch("sensitivity", jobs, (MPDispatch.Monitor)this);
        dispatch.run(this.maxProc());
        this.jobStat.nrunsDone = this.jobStat.nruns;
    }

    public void optimRun(ASInfo.Optim jinfo) throws Xcept {
        this.checkCompiled();
        this.rtmodel.cancelRun = false;
        this.storeMode = 2;
        this.jobStat = new ASInfo.Status(2);
        this.jobStat.mode = 2;
        this.jobStat.nruns = 1 + jinfo.args.maxCalls;
        this.optim = null;
        this.optim = new LSModelOptim(this, jinfo, 0, 0);
        int nproc = this.optim.maxProc();
        this.rtmodel.setMaxProc(this.maxProc());
        this.rtmodel.allocStores(1 + nproc);
        this.rtmodel.setRunVals(jinfo.baseVals);
        this.optim.optimize();
    }

    public void fimRun(ASInfo.Fim jinfo) throws Xcept {
        this.fim = null;
        this.checkCompiled();
        this.rtmodel.cancelRun = false;
        this.storeMode = 4;
        this.jobStat = new ASInfo.Status(2);
        this.jobStat.mode = 4;
        this.jobStat.nruns = 1 + jinfo.optim.args.maxCalls;
        this.optim = null;
        int nproc = this.maxProc();
        this.rtmodel.setMaxProc(this.maxProc());
        this.rtmodel.allocStores(2 * nproc);
        this.rtmodel.setRunVals(jinfo.optim.baseVals);
        this.fim = new LSModelFim(this, jinfo, nproc);
        this.fim.run();
    }

    private void checkCompiled() throws Xcept {
        if (this.rtmodel == null) {
            throw new Xcept((DiagInfo)this, "Can't start job.  Model is not compiled.");
        }
    }

    public ASInfo.Status getJobStatus() {
        if (this.jobStat == null) {
            return null;
        }
        if (this.jobStat != null && this.rtmodel != null && this.jobStat.runStats != null) {
            for (int i = 0; i < this.jobStat.runStats.length; ++i) {
                this.jobStat.runStats[i] = this.rtmodel.getRunStat(i);
            }
        }
        return this.jobStat;
    }

    public void cancelJob() {
        this.cancelBuild = true;
        if (this.rtmodel != null) {
            this.rtmodel.cancelRun = true;
        }
    }

    public int storeMode() {
        return this.storeMode;
    }

    public int nstores() {
        if (!this.isBuilt()) {
            return 0;
        }
        return this.rtmodel.nstores();
    }

    public String getStoreName(int i) {
        if (i < 0 || i >= this.nstores()) {
            return null;
        }
        return this.rtmodel.getStoreName(i);
    }

    public OptimResults optimResults() {
        if (this.optim != null) {
            return this.optim.results();
        }
        return null;
    }

    protected LSServer server() {
        return this.server;
    }

    protected RTModel rtmodel() {
        return this.rtmodel;
    }

    public ASModel.Flags getFlags() {
        if (this.rtmodel == null) {
            return new ASModel.Flags();
        }
        return this.rtmodel.getFlags();
    }

    public void setFuncGenNames(String[] names) throws Xcept {
        if (this.isBuilt()) {
            this.rtmodel.setFuncGenNames(names);
        }
    }

    public String modelID() {
        return "lsmodel" + this.hashCode();
    }

    public void message(ASInfo.Message msg) {
        if (this.server.messenger == null) {
            return;
        }
        msg.modelID = this.modelID();
        this.server.messenger.message(msg);
    }

    public class SingleRun
    implements MPDispatch.Job {
        private String jobName;
        private int storeInx;
        private NamedVal.NList nvals;

        public SingleRun(String j, int i, NamedVal.NList n) {
            this.jobName = j;
            this.storeInx = i;
            this.nvals = n;
        }

        public String jobName() {
            return this.jobName;
        }

        public void jobRunX(int workerInx) throws Xcept {
            LSModel.this.rtmodel.run(workerInx + 1, 1, this.storeInx, this.nvals);
        }

        public void jobCancel() {
        }
    }
}

