/*
 * Decompiled with CFR 0.152.
 */
package JSim.lserver;

import JSim.aserver.ASInfo;
import JSim.aserver.ASQuery;
import JSim.data.Data;
import JSim.data.DataCompare;
import JSim.data.NamedVal;
import JSim.data.OptimArgs;
import JSim.data.OptimResults;
import JSim.data.SensMatrix;
import JSim.jruntime.RTContext;
import JSim.lserver.LSModel;
import JSim.nml.opt.OptimCallbacks;
import JSim.nml.opt.Optimizer;
import JSim.util.DiagInfo;
import JSim.util.MPDispatch;
import JSim.util.Named;
import JSim.util.Util;
import JSim.util.Xcept;

public class LSModelOptim
implements OptimCallbacks,
MPDispatch.Monitor {
    private LSModel lsmodel;
    private ASInfo.Optim jobInfo;
    private OptimArgs args;
    private int nx;
    private Optimizer opt;
    private OptimResults results;
    private ASQuery[] matchExprs;
    private DataCompare compare;
    private int threadInxBase;
    private int nproc;
    private RTContext optimCtxt;

    public LSModelOptim(LSModel m, ASInfo.Optim jinfo, int threadInxBase, int np) throws Xcept {
        this.lsmodel = m;
        this.jobInfo = jinfo;
        this.args = this.jobInfo.args;
        this.nx = this.args.nx();
        this.threadInxBase = threadInxBase;
        this.opt = this.lsmodel.server().optimFactory().createOptimizer(this.args.alg());
        this.results = new OptimResults(this.args);
        this.nproc = np == 0 ? this.maxProc() : np;
        this.optimCtxt = new RTContext(this.lsmodel.rtmodel(), threadInxBase, this.nproc, null, false);
        this.matchExprs = new ASQuery[this.nmatches()];
        for (int i = 0; i < this.nmatches(); ++i) {
            this.matchExprs[i] = this.lsmodel.parseQuery(this.jobInfo.matchExprs[i]);
        }
    }

    public void optimize() throws Xcept {
        this.opt.optimize(this.optimCtxt, this.results, this);
        if (!this.args.calcCovMat) {
            return;
        }
        double[] errs = new double[this.nx + 1];
        SensMatrix mat = this.calcSensMat(this.results.bestX, this.args.xistep, errs, false);
        this.results.covMat = mat.getCovMatrix();
        this.results.condno = mat.getCondNo();
        if (this.args.confPcts == null) {
            return;
        }
        this.results.confLims = new double[this.args.confPcts.length][this.nx];
        for (int i = 0; i < this.args.confPcts.length; ++i) {
            this.results.confLims[i] = mat.getConfLimits(this.args.confPcts[i]);
        }
    }

    public double calcError(RTContext ctxt, double[] x, OptimResults res) throws Xcept {
        if (x.length != this.nx) {
            throw new Xcept((DiagInfo)this.lsmodel, "calcError: array length inconsistent");
        }
        return this.singleRun(this.threadInxWorkBase(), x, -1, null, true);
    }

    public int calcErrors(RTContext ctxt, double[][] x, double[] errs, OptimResults res) throws Xcept {
        if (x.length != errs.length) {
            throw new Xcept((DiagInfo)this.lsmodel, "calcErrors: array lengths inconsistent");
        }
        return this.multRuns(x, errs, null, true);
    }

    public SensMatrix calcSensMatrix(RTContext ctxt, double[] x, double[] dx, double[] errs, OptimResults res) throws Xcept {
        if (x.length != this.nx || dx.length != this.nx || errs.length != this.nx + 1) {
            throw new Xcept((DiagInfo)this.lsmodel, "calcSensMatrix: array lengths inconsistent");
        }
        return this.calcSensMat(x, dx, errs, true);
    }

    private SensMatrix calcSensMat(double[] xbase, double[] dx, double[] errs, boolean updateResults) throws Xcept {
        for (int i = 0; i < dx.length; ++i) {
            if (dx[i] != 0.0) continue;
            throw new Xcept("Zero parameter step size illegal in covariance matrix calculation");
        }
        double[][] x = new double[this.nx + 1][this.nx];
        for (int i = 0; i < this.nx + 1; ++i) {
            for (int j = 0; j < this.nx; ++j) {
                x[i][j] = xbase[j];
            }
            if (i <= 0) continue;
            double[] dArray = x[i];
            int n = i - 1;
            dArray[n] = dArray[n] + dx[i - 1];
        }
        Data.List[] sensH = new Data.List[this.nx + 1];
        this.multRuns(x, errs, sensH, updateResults);
        Data.List hs = sensH[0];
        Data.List[] hks = new Data.List[this.nx];
        for (int i = 0; i < this.nx; ++i) {
            hks[i] = sensH[i + 1];
        }
        return new SensMatrix(xbase, dx, this.compare.refs(), hs, hks, this.compare.pointWgts(), this.compare.curveWgts());
    }

    private int multRuns(double[][] x, double[] errs, Data.List[] sensH, boolean updateResults) throws Xcept {
        int ct;
        int nruns = errs.length;
        for (int i = 0; i < nruns; ++i) {
            errs[i] = Double.NaN;
        }
        MPDispatch.Job[] jobs = new MPDispatch.Job[nruns];
        for (int i = 0; i < nruns; ++i) {
            int arrInx = i;
            jobs[i] = new SingleRun("opt_" + arrInx, arrInx, x[i], errs, sensH, updateResults);
        }
        if (Util.isSame((double[])x[0], (double[])this.results.bestX)) {
            errs[0] = this.singleRunUpdate(this.storeInxBest(), x[0], 0, sensH, updateResults);
            MPDispatch.Job[] jobz = new MPDispatch.Job[nruns - 1];
            for (int i = 1; i < nruns; ++i) {
                jobz[i - 1] = jobs[i];
            }
            jobs = jobz;
        }
        MPDispatch dispatch = new MPDispatch("optim", jobs, (MPDispatch.Monitor)this);
        dispatch.run(this.nproc);
        if (this.results.bestErr < this.args.errTol) {
            for (ct = nruns; ct > 0 && Double.isNaN(errs[ct - 1]); --ct) {
            }
        }
        return ct;
    }

    public synchronized void jobStarted(MPDispatch.Job job) {
    }

    public synchronized void jobCompleted(MPDispatch.Job job) {
    }

    private double singleRun(int threadInx, double[] x, int sensInx, Data.List[] sensH, boolean updateResults) throws Xcept {
        NamedVal.NList nvals = new NamedVal.NList();
        for (int i = 0; i < this.nx; ++i) {
            NamedVal nval = NamedVal.create((String)this.args.xname[i], (double)x[i]);
            nvals.add((Named)nval);
        }
        int storeInx = this.storeInx(threadInx);
        int np = 1;
        this.lsmodel.rtmodel().run(threadInx, np, storeInx, nvals);
        return this.singleRunUpdate(storeInx, x, sensInx, sensH, updateResults);
    }

    private synchronized double singleRunUpdate(int storeInx, double[] x, int sensInx, Data.List[] sensH, boolean updateResults) throws Xcept {
        if (this.compare == null) {
            this.createCompare(storeInx);
        }
        if (sensH != null) {
            sensH[sensInx] = this.getSensH(storeInx);
        }
        if (!updateResults) {
            return Double.NaN;
        }
        ++this.lsmodel.jobStat.nrunsDone;
        Data.List dlist = new Data.List(this.nmatches());
        for (int i = 0; i < this.nmatches(); ++i) {
            Data d = this.lsmodel.getData(storeInx, this.matchExprs[i]);
            dlist.add((Object)d);
        }
        this.compare.setData(dlist);
        double err = this.compare.rmsError();
        if (storeInx != this.storeInxBest() && this.results.newBest(err)) {
            this.lsmodel.rtmodel().copyStore(storeInx, this.storeInxBest());
            this.lsmodel.jobStat.nrunsBest = this.lsmodel.jobStat.nrunsDone;
            this.results.bestCompare = this.compare;
        }
        this.results.addResult(err, x);
        return err;
    }

    private void createCompare(int storeInx) throws Xcept {
        Data.List refList = new Data.List(this.jobInfo.refData);
        this.compare = new DataCompare(refList);
        this.compare.setCurveWgts(this.jobInfo.curveWgts);
        Data.List pwgts = new Data.List(this.nmatches());
        for (int i = 0; i < this.nmatches(); ++i) {
            ASQuery q = this.lsmodel.parseQuery(this.jobInfo.pointWgts[i]);
            Data pwgt = this.lsmodel.getData(storeInx, q);
            pwgts.add((Object)pwgt);
        }
        this.compare.setPointWgts(pwgts);
    }

    private Data.List getSensH(int storeInx) throws Xcept {
        int nd = this.compare.n();
        Data.List dlist = new Data.List(nd);
        for (int i = 0; i < nd; ++i) {
            Data d = this.lsmodel.getData(storeInx, this.matchExprs[i]);
            dlist.add((Object)d);
        }
        return this.compare.matchRefs(dlist);
    }

    private int nmatches() {
        return this.jobInfo.matchExprs.length;
    }

    public OptimResults results() {
        return this.results;
    }

    public int storeInx(int threadInx) {
        return threadInx;
    }

    public int storeInxBest() {
        return this.threadInxBase;
    }

    public int threadInxWorkBase() {
        return this.threadInxBase + 1;
    }

    public int maxProc() {
        return this.opt.allowMP() ? this.lsmodel.maxProc() : 1;
    }

    public class SingleRun
    implements MPDispatch.Job {
        private String jobName;
        private int arrInx;
        private double[] x;
        private double[] errs;
        private Data.List[] sensH;
        private boolean updateResults;

        public SingleRun(String j, int inx, double[] xx, double[] errs, Data.List[] sensH, boolean updateResults) {
            this.jobName = j;
            this.arrInx = inx;
            this.x = xx;
            this.errs = errs;
            this.sensH = sensH;
            this.updateResults = updateResults;
        }

        public String jobName() {
            return this.jobName;
        }

        public void jobRunX(int workerInx) throws Xcept {
            double err;
            boolean skip;
            boolean bl = skip = ((LSModelOptim)LSModelOptim.this).results.bestErr < ((LSModelOptim)LSModelOptim.this).args.errTol;
            if (this.sensH != null) {
                skip = false;
            }
            if (skip) {
                return;
            }
            int threadInx = LSModelOptim.this.threadInxWorkBase() + workerInx;
            this.errs[this.arrInx] = err = LSModelOptim.this.singleRun(threadInx, this.x, this.arrInx, this.sensH, this.updateResults);
        }

        public void jobCancel() {
        }
    }
}

