/*
 * Decompiled with CFR 0.152.
 */
package JSim.lserver;

import JSim.aserver.ASInfo;
import JSim.lserver.LSServer;
import JSim.util.StringList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.net.InetAddress;
import java.net.NetPermission;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.SecurityPermission;
import java.util.PropertyPermission;
import java.util.logging.LoggingPermission;

public class LSSandbox
extends SecurityManager {
    private LSServer server;
    private StringList readDirs;
    private StringList writeDirs;
    private StringList hosts;
    private StringList runPerms;

    public LSSandbox(LSServer s, ASInfo.Sandbox info) throws Xcept {
        this.server = s;
        Util.verbose((String)"Creating local sandbox...");
        this.readDirs = new StringList(8);
        if (info.readGUI) {
            File[] roots = File.listRoots();
            for (int i = 0; i < roots.length; ++i) {
                this.addDir(this.readDirs, roots[i]);
            }
        }
        this.addDir(this.readDirs, Util.jsimHome());
        this.addDir(this.readDirs, System.getProperty("java.home"));
        this.addPath(this.readDirs, System.getProperty("java.class.path"));
        this.addPath(this.readDirs, System.getProperty("java.ext.dirs"));
        this.addPath(this.readDirs, System.getProperty("sun.boot.class.path"));
        this.addPath(this.readDirs, this.server.jsimPath());
        this.addDir(this.readDirs, this.server.buildDir);
        this.addDir(this.readDirs, info.readPath);
        this.writeDirs = new StringList(8);
        this.addDir(this.writeDirs, this.server.buildDir);
        this.addDir(this.writeDirs, info.writePath);
        this.runPerms = new StringList(8);
        this.runPerms.add((Object)"setSecurityManager");
        this.hosts = new StringList(8);
        this.addHost("localhost");
        try {
            this.addHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        for (int i = 0; i < info.hosts.size(); ++i) {
            this.addHost(info.hosts.str(i));
        }
    }

    private void addHost(String h) {
        this.hosts.add((Object)h);
        try {
            byte[] addr = InetAddress.getByName(h).getAddress();
            String h1 = "";
            for (int j = 0; j < addr.length; ++j) {
                int k;
                if (j > 0) {
                    h1 = h1 + ".";
                }
                if ((k = addr[j]) < 0) {
                    k += 256;
                }
                h1 = h1 + k;
            }
            this.hosts.add((Object)h1);
            Util.verbose((String)("Adding host " + h + " (" + h1 + ") to sandbox"));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private void addPath(StringList list, String path) throws Xcept {
        StringList p = new StringList(path, File.pathSeparator);
        for (int i = 0; i < p.size(); ++i) {
            this.addDir(list, p.str(i));
        }
    }

    private void addDir(StringList list, StringList dirs) throws Xcept {
        for (int i = 0; i < dirs.size(); ++i) {
            this.addDir(list, dirs.str(i));
        }
    }

    private void addDir(StringList list, String s) throws Xcept {
        this.addDir(list, new File(s));
    }

    private void addDir(StringList list, File f) throws Xcept {
        if (f == null) {
            return;
        }
        try {
            String n = f.getCanonicalPath();
            if (!this.hasFile(list, n)) {
                list.add((Object)n);
            }
            if (!f.isAbsolute()) {
                return;
            }
            n = f.getPath();
            if (!this.hasFile(list, n)) {
                list.add((Object)n);
            }
        }
        catch (Exception e) {
            throw Xcept.wrap((Throwable)e);
        }
    }

    private boolean hasFile(StringList list, String n) {
        for (int i = 0; i < list.size(); ++i) {
            if (!n.startsWith(list.str(i))) continue;
            return true;
        }
        File f = new File(n);
        if (f.isAbsolute()) {
            return false;
        }
        try {
            return this.hasFile(list, f.getCanonicalPath());
        }
        catch (Exception e) {
            return false;
        }
    }

    private void error(String s) {
        String msg = "Cannot " + s + " in the JSim sandbox";
        throw new SecurityException(msg);
    }

    public void checkConnect(String host, int port) {
        if (this.hosts.containSame(host)) {
            return;
        }
        this.error("connect to host " + host + " allowed hosts=" + this.hosts);
    }

    public void checkDelete(String s) {
        if (!this.hasFile(this.writeDirs, s)) {
            this.error("delete file " + s);
        }
    }

    public void checkExec(String cmd) {
        this.error("run system command \"" + cmd + "\"");
    }

    public void checkRead(FileDescriptor f) {
    }

    public void checkRead(String s) {
        if (!this.hasFile(this.readDirs, s)) {
            this.error("read file " + s);
        }
    }

    public void checkRead(String s, Object o) {
        this.checkRead(s);
    }

    public void checkPackageAccess(String s) {
    }

    public void checkPermission(Permission p) {
        if (p instanceof PropertyPermission) {
            if (p.getActions().equals("read")) {
                return;
            }
            String n = p.getName();
            boolean err = false;
            if (n.startsWith("java")) {
                err = true;
            }
            if (n.startsWith("jsim")) {
                err = true;
            }
            if (err) {
                this.error("set property " + n);
            }
            return;
        }
        if (p instanceof FilePermission) {
            return;
        }
        if (p instanceof RuntimePermission) {
            if (this.runPerms.containSame(p.getName())) {
                this.error(p.getName());
            } else {
                return;
            }
        }
        if (p instanceof NetPermission) {
            return;
        }
        if (p instanceof SecurityPermission) {
            return;
        }
        if (p instanceof AWTPermission) {
            return;
        }
        if (p instanceof ReflectPermission) {
            return;
        }
        if (p instanceof LoggingPermission) {
            return;
        }
    }

    public void checkWrite(FileDescriptor f) {
    }

    public void checkWrite(String s) {
        if (!this.hasFile(this.writeDirs, s)) {
            this.error("write file " + s);
        }
    }
}

