/*
 * Decompiled with CFR 0.152.
 */
package JSim.lserver;

import JSim.aserver.ASInfo;
import JSim.aserver.ASModel;
import JSim.aserver.ASServer;
import JSim.cellml.CMLDoc;
import JSim.data.NamedVal;
import JSim.data.OptimAlg;
import JSim.jruntime.RTSolverSettings;
import JSim.lserver.LSJavac;
import JSim.lserver.LSModel;
import JSim.lserver.LSSandbox;
import JSim.lserver.NativeCompiler;
import JSim.mml.ModelReader;
import JSim.nml.ode1.ODE1Solver;
import JSim.nml.opt.OptimFactory;
import JSim.nml.opt.Optimizer;
import JSim.nml.pde1.PDE1Solver;
import JSim.sbml.SBModel;
import JSim.util.DiagInfo;
import JSim.util.JSClassLoader;
import JSim.util.Plugin;
import JSim.util.UnitNList;
import JSim.util.Util;
import JSim.util.UtilIO;
import JSim.util.UtilXML;
import JSim.util.Xcept;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.w3c.dom.Document;

public final class LSServer
extends ASServer {
    private String jsimPath;
    protected File buildDir;
    private int maxProc;
    private int maxBuildTime;
    protected boolean scrub;
    protected ASServer.Messenger messenger;
    protected ASInfo.Sandbox sandbox;
    protected Plugin.List plugins;
    private String libPath;
    private String sysUnitsText;
    private UnitNList sysUnits;
    private UnitNList cellMLUnits;
    private OptimFactory optimFactory;
    protected ClassLoader classLoader;
    protected LSJavac javac;
    protected NativeCompiler nativeCompiler;

    public LSServer(NamedVal.NList options, ASServer.Messenger msgr, ASInfo.Sandbox sandbox) throws Xcept {
        String s;
        this.messenger = msgr;
        this.jsimPath = options.stringVal("path", null);
        String bd = options.stringVal("buildDir", null);
        if (bd != null) {
            this.buildDir = new File(bd);
        }
        this.maxBuildTime = options.intVal("maxBuildTime", 0);
        this.scrub = options.boolVal("scrub", true);
        int mp = options.intVal("maxProcDebug", 0);
        if (mp > 0) {
            this.setMaxProc(mp, true);
        } else {
            this.setMaxProc(options.intVal("maxProc", 1), false);
        }
        this.sandbox = sandbox;
        if (System.getSecurityManager() != null) {
            throw new Xcept("May not create LSServer in JSim sandbox");
        }
        if (this.buildDir == null) {
            this.makeBuildDir();
        }
        if (!this.buildDir.isAbsolute()) {
            try {
                this.buildDir = this.buildDir.getCanonicalFile();
            }
            catch (IOException e) {
                throw Xcept.wrap((Throwable)e);
            }
        }
        this.scrubBuildDir();
        if (Util.isBlank((String)this.jsimPath)) {
            this.jsimPath = System.getProperty("jsim.path");
        }
        if (Util.isBlank((String)this.jsimPath)) {
            this.jsimPath = System.getProperty("user.home") + File.separator + ".jsim" + File.separator + "local" + File.pathSeparator + Util.jsimHome() + File.separator + "local" + File.pathSeparator + Util.jsimHome() + File.separator + "common";
        }
        char javaVers = (s = System.getProperty("java.version")).length() > 2 ? (char)s.charAt(2) : (char)'4';
        this.jsimPath = this.jsimPath + File.pathSeparator + Util.jsimHome() + File.separator + "lib" + File.separator + "tools" + javaVers + ".jar";
        if (sandbox == null) {
            this.jsimPath = this.jsimPath + File.pathSeparator + ".";
        }
        this.libPath = this.jsimPath;
        this.jsimPath = this.jsimPath + File.pathSeparator + this.buildDir;
        if (sandbox == null) {
            this.libPath = this.libPath + File.pathSeparator + this.buildDir;
        }
        this.classLoader = new JSClassLoader(this.jsimPath, this.libPath);
        this.javac = new LSJavac(this);
        String ulibname = Util.jsimHome() + File.separator + "common" + File.separator + "nsrunit.mod";
        ModelReader umodel = new ModelReader(new File(ulibname), this.classLoader, this.jsimPath);
        this.sysUnits = umodel.units;
        this.sysUnitsText = UtilIO.readText((File)new File(ulibname));
        ulibname = Util.jsimHome() + File.separator + "common" + File.separator + "cellmlunit.mod";
        umodel = new ModelReader(new File(ulibname), this.classLoader, this.jsimPath);
        this.cellMLUnits = umodel.units;
        this.plugins = new Plugin.List();
        this.optimFactory = new OptimFactory();
        this.nativeCompiler = new NativeCompiler(this);
        if (sandbox != null) {
            System.setSecurityManager(new LSSandbox(this, sandbox));
        }
    }

    private void dumpSettings() {
        System.out.println("Local Server Settings:");
        System.out.println("  path=" + this.jsimPath);
        System.out.println("  buildDir=" + this.buildDir);
        System.out.println("  maxProc=" + this.maxProc);
        System.out.println("  maxBuildTime=" + this.maxBuildTime);
        System.out.println("  scrub=" + this.scrub);
        System.out.println("  sandbox=" + this.sandbox);
    }

    public void addPlugin(Plugin plugin) throws Xcept {
        this.plugins.add((Object)plugin);
        this.optimFactory.add(plugin);
    }

    public void makeBuildDir() throws Xcept {
        File dir = new File(System.getProperty("user.home") + File.separator + ".jsim");
        this.makeDir(dir);
        this.makeDir(new File(dir, "local"));
        this.scrubOldDirs(dir.listFiles());
        int sfx = 0;
        do {
            this.buildDir = new File(dir, "work" + sfx++);
        } while (this.buildDir.exists());
        this.makeDir(this.buildDir);
    }

    private File makeDir(File f) throws Xcept {
        if (!f.exists()) {
            f.mkdir();
        }
        if (!f.isDirectory()) {
            f.delete();
            f.mkdir();
        }
        return f;
    }

    private void scrubOldDirs(File[] files) {
        if (!this.scrub) {
            return;
        }
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (!f.getName().startsWith("work") || UtilIO.dirNesting((File)f, (int)2) > 1) continue;
            long age = System.currentTimeMillis() - UtilIO.lastModifiedDir((File)f);
            if ((age /= 86400000L) <= 30L) continue;
            UtilIO.deleteOnExit1((File)f);
        }
    }

    protected void scrubBuildDir() {
        if (this.scrub) {
            UtilIO.deleteOnExit1((File)this.buildDir);
        }
    }

    public UnitNList sysUnits() {
        return this.sysUnits;
    }

    public String sysUnitsText() {
        return this.sysUnitsText;
    }

    public UnitNList cellMLUnits() {
        return this.cellMLUnits;
    }

    public NamedVal.NList getSolverDefaults() {
        return RTSolverSettings.getDefaults();
    }

    public OptimFactory optimFactory() {
        return this.optimFactory;
    }

    public OptimAlg.NList optimAlgs() throws Xcept {
        return this.optimFactory.algs();
    }

    public OptimAlg.Info[] optimAlgsInfo() throws Xcept {
        return this.optimFactory.algInfo();
    }

    public String createMML(String xtext, NamedVal[] options) throws Xcept {
        Document doc = UtilXML.parse((String)xtext);
        String type = doc.getDocumentElement().getNodeName();
        StringWriter wrt = new StringWriter();
        if (type.equals("model")) {
            CMLDoc cmlDoc = new CMLDoc(doc, this.cellMLUnits(), this.sysUnits());
            cmlDoc.writeMML(wrt);
        } else if (type.equals("sbml")) {
            xtext = xtext.replaceAll("\"_", "\"");
            StringReader rdr = new StringReader(xtext);
            SBModel sbmodel = new SBModel(rdr, options);
            sbmodel.writeMML(wrt);
        } else {
            throw new Xcept("Unsupported XML file format");
        }
        return ((Object)wrt).toString();
    }

    public ASModel newModelRT() throws Xcept {
        return new LSModel(this);
    }

    public int maxBuildTime() {
        return this.maxBuildTime;
    }

    public Plugin.List plugins() {
        return this.plugins;
    }

    public void setProperties(NamedVal[] nvals) throws Xcept {
        if (nvals == null) {
            return;
        }
        for (int i = 0; i < nvals.length; ++i) {
            this.setProperty(nvals[i]);
        }
    }

    public void setProperty(NamedVal nval) throws Xcept {
        String n = nval.name();
        if (n.equals("maxProc")) {
            this.setMaxProc(nval.intVal(), false);
        } else if (n.equals("maxProcDebug")) {
            this.setMaxProc(nval.intVal(), true);
        } else {
            throw new Xcept((DiagInfo)nval, "Unrecognized JSim server property");
        }
    }

    public NamedVal getProperty(String n) throws Xcept {
        if (n.equals("maxProc")) {
            return NamedVal.create((String)n, (int)this.maxProc());
        }
        return null;
    }

    public int maxProc() {
        return this.maxProc;
    }

    void setMaxProc(int i, boolean debug) {
        int sproc = Runtime.getRuntime().availableProcessors();
        this.maxProc = i;
        if (!debug && sproc < this.maxProc) {
            this.maxProc = sproc;
        }
        if (this.maxProc < 1) {
            this.maxProc = 1;
        }
        Util.verbose((String)("Now utilizing " + this.maxProc + " compute threads on " + sproc + " system processors."));
        LSServer.allocNativeThreads(2 * this.maxProc);
    }

    public void disconnect() {
        this.scrubBuildDir();
    }

    protected String jsimPath() {
        return this.jsimPath;
    }

    protected String libPath() {
        return this.libPath;
    }

    public static void allocNativeThreads(int n) {
        ODE1Solver.allocNativeThreads(n + 1);
        PDE1Solver.allocNativeThreads(n + 1);
        Optimizer.allocNativeThreads(n + 1);
    }

    public String memoryMessage() {
        return "Memory: " + Util.memoryMessage();
    }

    static {
        System.loadLibrary("odesolver");
        System.loadLibrary("pdesolver");
        System.loadLibrary("opt");
        LSServer.allocNativeThreads(2);
    }
}

