/*
 * Decompiled with CFR 0.152.
 */
package JSim.lserver;

import JSim.lserver.LSServer;
import JSim.mml.SourceFunc;
import JSim.util.DiagInfo;
import JSim.util.Util;
import JSim.util.UtilIO;
import JSim.util.Xcept;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class NativeCompiler {
    private LSServer server;
    private String compile_C;
    private String compile_CC;
    private String compile_F;
    private int ct;

    public NativeCompiler(LSServer s) {
        this.server = s;
        this.ct = 1001;
    }

    public void compile(String modelName, SourceFunc func) throws Xcept {
        String libName;
        String funcName = libName = "JSfunc" + this.ct++;
        func.setLibrary(libName, funcName);
        File outfile = new File(this.server.buildDir, libName + "." + this.suffix(func));
        try {
            PrintWriter wrt = new PrintWriter(new FileWriter(outfile));
            switch (func.lang()) {
                case 5: 
                case 6: {
                    this.writeC(wrt, func);
                    break;
                }
                case 7: {
                    throw new Xcept((DiagInfo)func, "native compiler not yet supported");
                }
            }
            wrt.close();
        }
        catch (IOException e) {
            throw new Xcept((DiagInfo)func, "error writing native code:" + e.getMessage());
        }
        String cmd = "jscompile_" + this.suffix(func);
        if (Util.isWin32()) {
            cmd = cmd + ".bat";
        }
        try {
            cmd = UtilIO.pathFind((String)cmd, (String)this.server.jsimPath());
        }
        catch (Xcept e) {
            String lname = this.langName(func.lang());
            throw new Xcept("Model requires " + lname + " compiler, but none is available. " + cmd + " not found in JSIMPATH=" + this.server.jsimPath());
        }
        cmd = new File(cmd).getAbsolutePath();
        String jhome = Util.jsimHome();
        String bdir = this.server.buildDir.getAbsolutePath();
        String q = "\"";
        if (Util.isWin32()) {
            jhome = q + jhome + q;
            cmd = q + cmd + q;
            bdir = q + bdir + q;
        }
        String[] cmdarr = new String[]{cmd, jhome, bdir, libName, func.flags() == null ? "" : func.flags()};
        File libFile = new File(this.server.buildDir, System.mapLibraryName(libName));
        if (libFile.exists() && !libFile.delete()) {
            throw new Xcept((DiagInfo)func, "Cannot delete old library " + libFile);
        }
        Util.verbose((String)("Executing native compiler: " + cmd));
        String msg = null;
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmdarr);
            int stat = proc.waitFor();
            if (stat != 0) {
                msg = "Native compile terminated abnormally (status=" + stat + ")";
            }
        }
        catch (Exception e) {
            msg = "Error during native compile: " + e.getMessage();
        }
        if (msg == null && !libFile.exists()) {
            msg = "Native compile failed to create " + libFile;
        }
        if (msg != null) {
            if (proc != null) {
                msg = msg + "\n" + UtilIO.readText((InputStream)proc.getInputStream()) + "\n" + UtilIO.readText((InputStream)proc.getErrorStream());
            }
            throw new Xcept((DiagInfo)func, msg);
        }
    }

    public String suffix(SourceFunc func) throws Xcept {
        switch (func.lang()) {
            case 5: {
                return "c";
            }
            case 6: {
                return "C";
            }
            case 7: {
                return "F";
            }
        }
        throw new Xcept((DiagInfo)func, "invalid native compiler code");
    }

    public String langName(int lang) throws Xcept {
        switch (lang) {
            case 5: {
                return "C";
            }
            case 6: {
                return "C++";
            }
            case 7: {
                return "Fortran";
            }
        }
        throw new Xcept("invalid native compiler");
    }

    public void writeC(PrintWriter wrt, SourceFunc func) throws Xcept {
        wrt.println("/* JSim generated native library */");
        wrt.println("");
        wrt.println("#include \"jsimapi.h\"");
        if (func.topCode() != null) {
            wrt.println("");
            wrt.println(func.topCode());
            wrt.println("");
        }
        wrt.println("");
        String jsfunc = func.dataType() == 1 ? "JSIM_PROCEDURE" : "JSIM_REAL_FUNCTION";
        wrt.println(jsfunc + "(" + func.libName() + "," + func.funcName() + ") {");
        wrt.println("\tJSIM_INIT();");
        for (int i = 0; i < func.nargs(); ++i) {
            wrt.println("\tJSimArg *" + func.parName(i) + " = JSIM_ARG(" + i + ");");
        }
        wrt.println(func.mainCode());
        wrt.println("");
        wrt.println("}");
        if (func.bottomCode() != null) {
            wrt.println("");
            wrt.println(func.bottomCode());
            wrt.println("");
        }
    }
}

