/*
 * Decompiled with CFR 0.152.
 */
package JSim.mathml;

import JSim.mathml.MLApply;
import JSim.mathml.MLCSymbol;
import JSim.mathml.MLLambda;
import JSim.mathml.MLNameSpace;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.IfExpr;
import JSim.util.RealConst;
import JSim.util.StringList;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.UtilXML;
import JSim.util.Xcept;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class MLMath
implements DiagInfo {
    private Element math;
    private static MLApply apply;
    private MLNameSpace nameSpace;
    private MLCSymbol.NList csymbols;

    public MLMath(Element e) throws Xcept {
        this.math = e;
        if (apply == null) {
            apply = new MLApply();
        }
    }

    public MLMath(String text) throws Xcept {
        Document doc = UtilXML.parse((String)text);
        this.math = doc.getDocumentElement();
        if (apply == null) {
            apply = new MLApply();
        }
    }

    public StringList getVars() {
        StringList list = new StringList();
        this.addVars(list, this.math);
        return list;
    }

    private void addVars(StringList list, Element elem) {
        String tag = elem.getNodeName();
        if (tag.equals("ci")) {
            list.addUniq(UtilXML.getText((Element)elem));
        }
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            this.addVars(list, (Element)node);
        }
    }

    public Expr.List makeExprList(MLNameSpace ns, MLCSymbol.NList csyms) throws Xcept {
        this.nameSpace = ns;
        this.csymbols = csyms;
        return this.makeExprList(this.math);
    }

    private Expr.List makeExprList(Element elem) throws Xcept {
        Expr.List list = new Expr.List(4);
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String n;
            Node node = nodes.item(i);
            if (!(node instanceof Element) || (n = node.getNodeName()).equals("rdf:RDF")) continue;
            Expr expr = this.makeExpr((Element)node);
            list.add((Object)expr);
        }
        return list;
    }

    private Expr makeExpr(Element elem) throws Xcept {
        String name = elem.getNodeName();
        if (name.equals("apply")) {
            return this.makeApplyExpr(elem);
        }
        if (name.equals("cn")) {
            return this.makeConstExpr(elem);
        }
        if (name.equals("ci")) {
            return this.makeVarExpr(elem);
        }
        if (name.equals("bvar")) {
            return this.makeBVarExpr(elem);
        }
        if (name.equals("piecewise")) {
            return this.makePiecewiseExpr(elem);
        }
        if (name.equals("degree")) {
            return this.makeDegree(elem);
        }
        if (name.equals("pi")) {
            return Expr.pi;
        }
        if (name.equals("csymbol")) {
            return this.makeCSymbol(elem, new Expr.List(0));
        }
        throw new Xcept("Tag <" + name + "> not supported within <math>");
    }

    private Expr makeApplyExpr(Element elem) throws Xcept {
        NodeList nodes = elem.getChildNodes();
        Node eop = null;
        Expr.List args = new Expr.List(4);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            if (eop == null) {
                eop = (Element)node;
                continue;
            }
            Expr arg = this.makeExpr((Element)node);
            args.add((Object)arg);
        }
        if (eop == null) {
            throw new Xcept("<apply> tag missing its operator");
        }
        String opname = eop.getNodeName();
        if (opname.equals("ci")) {
            if (args.size() == 0) {
                return this.makeVarExpr((Element)eop);
            }
            String fname = UtilXML.getText((Element)eop);
            Expr fex = this.nameSpace.funcCall(fname, args);
            if (fex == null) {
                throw new Xcept((DiagInfo)this, "Function " + fname + " not defined.");
            }
            return fex;
        }
        if (opname.equals("csymbol")) {
            return this.makeCSymbol((Element)eop, args);
        }
        MLApply.Op op = apply.op(opname);
        if (op != null) {
            return op.makeExpr(args);
        }
        throw new Xcept("Can't process <apply> operator " + opname);
    }

    private Expr makeCSymbol(Element elem, Expr.List args) throws Xcept {
        MLCSymbol csym;
        String name = this.nameSpace.compNameByElement(elem);
        MLCSymbol mLCSymbol = csym = this.csymbols == null ? null : this.csymbols.csym(name);
        if (csym == null) {
            throw new Xcept((DiagInfo)this, "Unsupported csymbol: " + name);
        }
        return csym.makeExpr(args);
    }

    private Expr makeDegree(Element elem) throws Xcept {
        NodeList nodes = elem.getChildNodes();
        Expr ret = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            if (ret != null) {
                throw new Xcept("<degree> requires single argument");
            }
            ret = this.makeExpr((Element)node);
        }
        if (ret == null) {
            throw new Xcept("<degree> requires single argument.");
        }
        return ret;
    }

    private Expr makePiecewiseExpr(Element elem) throws Xcept {
        Expr.List pieces0 = new Expr.List(4);
        Expr.List pieces1 = new Expr.List(4);
        Expr other = null;
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            String name = node.getNodeName();
            if (name.equals("piece")) {
                Expr.List piece = this.makeExprList((Element)node);
                if (piece.size() != 2) {
                    throw new Xcept((DiagInfo)this, "<piece> requires 2 components, " + piece.size() + " found.");
                }
                pieces0.add((Object)piece.expr(0));
                pieces1.add((Object)piece.expr(1));
                continue;
            }
            if (!name.equals("otherwise")) continue;
            if (other != null) {
                throw new Xcept((DiagInfo)this, "Duplicate <otherwise> tag.");
            }
            Expr.List list = this.makeExprList((Element)node);
            if (list.size() != 1) {
                throw new Xcept((DiagInfo)this, "<otherwise> requires 2 components, " + list.size() + " found.");
            }
            other = list.expr(0);
        }
        if (other == null) {
            throw new Xcept((DiagInfo)this, "<piecewise> without <otherwise> not supported.");
        }
        Expr expr = other;
        int ct = pieces0.size();
        for (int i = 0; i < ct; ++i) {
            Expr test = pieces1.expr(ct - 1 - i);
            Expr val = pieces0.expr(ct - 1 - i);
            expr = new IfExpr(test, val, expr);
        }
        return expr;
    }

    private Expr makeBVarExpr(Element elem) throws Xcept {
        NodeList nodes = elem.getElementsByTagName("ci");
        if (nodes.getLength() != 1) {
            throw new Xcept("<bvar> tag supports only a single <ci> child");
        }
        return this.makeVarExpr((Element)nodes.item(0));
    }

    private Expr makeVarExpr(Element elem) throws Xcept {
        String name = UtilXML.getText((Element)elem);
        if (Util.isBlank((String)name)) {
            throw new Xcept("Name text missing in <ci> tag.");
        }
        Expr e = this.nameSpace.compByName(name);
        if (e == null) {
            throw new Xcept("Can't find variable " + name);
        }
        return e;
    }

    private Expr makeConstExpr(Element elem) throws Xcept {
        String type = elem.getAttribute("type");
        double f = type.equals("e-notation") ? this.getValueEnot(elem) : UtilXML.getValueText((Element)elem);
        String s = elem.getAttribute("cellml:units");
        if (Util.isBlank((String)s)) {
            return Expr.cons((double)f);
        }
        Unit u = this.nameSpace.unitByName(s);
        return new RealConst(f, u);
    }

    private double getValueEnot(Element elem) throws Xcept {
        double exp;
        StringList texts = new StringList();
        NodeList childs = elem.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (!(child instanceof Text)) continue;
            texts.add((Object)((Text)child).getWholeText());
        }
        if (texts.size() != 2) {
            throw new Xcept("Illegal e-notation constant: " + texts);
        }
        double base = Util.toDouble((String)texts.str(0));
        double f = base * Math.pow(10.0, exp = Util.toDouble((String)texts.str(1)));
        if (Double.isNaN(f)) {
            throw new Xcept((DiagInfo)this, "Illegal e-notation constant: " + texts);
        }
        return f;
    }

    public MLLambda makeLambda(MLNameSpace ns, MLCSymbol.NList csyms) throws Xcept {
        MLLambda lambda = new MLLambda(ns);
        Element elambda = UtilXML.getUniqueElement((Element)this.math, (String)"lambda");
        ArrayList elems = UtilXML.getElements((Element)elambda);
        if (elems.size() < 1) {
            throw new Xcept("No elements within <lambda>");
        }
        for (int i = 0; i < elems.size() - 1; ++i) {
            Element earg = (Element)elems.get(i);
            if (!earg.getNodeName().equals("bvar")) {
                throw new Xcept("<lambda> element expected <bvar> child, got " + earg.getNodeName());
            }
            Element eci = UtilXML.getUniqueElement((Element)earg, (String)"ci");
            String argName = UtilXML.getText((Element)eci);
            lambda.addArg(argName);
        }
        this.nameSpace = lambda;
        this.csymbols = csyms;
        Element eeval = (Element)elems.get(elems.size() - 1);
        Expr eval = this.makeExpr(eeval);
        lambda.setEval(eval);
        return lambda;
    }

    public String toString() {
        return "MathML for " + this.nameSpace;
    }

    public String diagInfo() {
        return this.toString();
    }

    protected MLNameSpace nameSpace() {
        return this.nameSpace;
    }
}

