/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Comp;
import JSim.mml.IntNVar;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.RealConst;
import JSim.util.StringConst;
import JSim.util.StringList;
import JSim.util.Xcept;

public class ChoiceNVar
extends IntNVar {
    private StringList labels;
    private StringList values;
    private static String argErr = "choice variables support only string & integer arguments";

    public ChoiceNVar(Comp p, String n, Expr.List d) throws Xcept {
        super(p, n, null);
        this.args = d;
        this.labels = new StringList(d.size());
        this.values = new StringList(d.size());
        int vbase = 1;
        for (int i = 0; i < d.size(); ++i) {
            Expr a = d.expr(i).simplify();
            if (a instanceof StringConst) {
                String s = ((StringConst)a).constStringVal();
                if (this.labels.containSame(s)) {
                    throw new Xcept((DiagInfo)this, "duplicate choice label \"" + s + "\"");
                }
                this.labels.add((Object)s);
                String v = "" + vbase++;
                if (this.values.containSame(v)) {
                    throw new Xcept((DiagInfo)this, "duplicate choice value \"" + v + "\"");
                }
                this.values.add((Object)v);
                continue;
            }
            if (a instanceof RealConst) {
                double ar = ((RealConst)a).constRealVal();
                vbase = (int)ar;
                if ((double)vbase == ar) continue;
                throw new Xcept((DiagInfo)this, argErr);
            }
            throw new Xcept((DiagInfo)this, argErr);
        }
        if (this.labels.size() < 2) {
            throw new Xcept((DiagInfo)this, "choice variables require at least 2 labels");
        }
    }

    public StringList labels() {
        return this.labels;
    }

    public StringList values() {
        return this.values;
    }
}

