/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.jruntime.RTXFunc;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Util;
import JSim.util.XFunc;
import JSim.util.XFuncCall;
import JSim.util.Xcept;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassFunc
extends XFunc {
    private int dataType;
    protected Class clss;
    private ClassLoader classLoader;
    private Method m_getInfo;

    public ClassFunc(String n, int dtype, String clssName, ClassLoader cloader) throws Xcept {
        super(n, 1);
        this.dataType = dtype;
        this.classLoader = cloader;
        if (clssName != null) {
            this.loadClass(clssName);
        }
    }

    public void loadClass(String clssName) throws Xcept {
        if (this.m_getInfo != null) {
            throw new Xcept((DiagInfo)this, "Duplicate class=name specification");
        }
        try {
            if (this.classLoader == null) {
                Util.verbose((String)"No custom class loader is available for ClassFuncs");
                this.clss = Class.forName(clssName);
            } else {
                this.clss = this.classLoader.loadClass(clssName);
            }
            if (!RTXFunc.class.isAssignableFrom(this.clss)) {
                throw new Xcept((DiagInfo)this, "Class " + clssName + " must extend JSim.jruntime.RTXFunc");
            }
            Class[] carr = new Class[]{Expr.List.class};
            this.m_getInfo = this.clss.getMethod("getInfo", carr);
        }
        catch (Exception e) {
            throw new Xcept((DiagInfo)this, e.getMessage());
        }
    }

    public void addCode(String n, String code) throws Xcept {
        if (!n.equals("class")) {
            throw new Xcept((DiagInfo)this, "Unrecognized code " + n);
        }
        this.loadClass(code);
    }

    public XFuncCall createCall(Expr.List args) throws Xcept {
        Object[] oarr = new Object[]{args};
        try {
            RTXFunc.Info info = (RTXFunc.Info)this.m_getInfo.invoke(null, oarr);
            if (info.dataType != this.dataType) {
                throw new Xcept("declared dataType does not match internal dataType");
            }
            return new XFuncCall((XFunc)this, args, info.dataType, info.ninputs);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (e instanceof InvocationTargetException) {
                msg = ((InvocationTargetException)e).getTargetException().getMessage();
            }
            throw new Xcept((DiagInfo)this, msg);
        }
    }

    public void validate() throws Xcept {
        if (this.m_getInfo == null) {
            throw new Xcept((DiagInfo)this, "No class=name specified");
        }
    }

    public Class clss() {
        return this.clss;
    }

    public String className() {
        return this.clss.getName();
    }

    public int dataType() {
        return this.dataType;
    }

    public boolean sameAs(XFunc f) {
        if (!(f instanceof ClassFunc)) {
            return false;
        }
        ClassFunc f1 = (ClassFunc)f;
        if (this.clss != f1.clss) {
            return false;
        }
        return super.sameAs((XFunc)f1);
    }

    public void writeFlat(PrintStream out) {
        String fp = this.dataType == 1 ? "procedure" : "real function";
        out.println("class " + fp + " " + this.name + "{");
        out.println("\tclass=\"" + this.clss.getName() + "\";");
        out.println("\treentrant=\"" + this.isReentrant() + "\";");
        out.println("}");
    }
}

