/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.ClassFunc;
import JSim.mml.Comp;
import JSim.mml.CompProp;
import JSim.mml.Domain;
import JSim.mml.JavaTempl;
import JSim.mml.MathSys;
import JSim.mml.ModelReader;
import JSim.mml.Sys;
import JSim.mml.Templ;
import JSim.mml.UnitAssignor;
import JSim.mml.Var;
import JSim.mml.VarFuncCall;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.IExpr;
import JSim.util.NameSpace;
import JSim.util.Named;
import JSim.util.NamedExpr;
import JSim.util.RealBExpr;
import JSim.util.StringList;
import JSim.util.Unit;
import JSim.util.UnitNList;
import JSim.util.Util;
import JSim.util.XFunc;
import JSim.util.XFuncCall;
import JSim.util.Xcept;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class Model
extends MathSys
implements NameSpace {
    public static final int NONE = 0;
    public static final int OFF = 1;
    public static final int ON = 2;
    public int unitControl;
    public UnitNList units;
    public CompProp.List defProps;
    protected XFunc.NList xfuncs;
    protected Expr.List funcCalls;
    protected Templ.NList templ;
    protected JavaTempl realTempl;
    protected JavaTempl realDomainTempl;
    protected JavaTempl intTempl;
    protected JavaTempl realStateTempl;
    protected JavaTempl intStateTempl;
    protected JavaTempl choiceTempl;
    public StringList externJava;
    protected ClassLoader classLoader;
    protected String importPath;
    private Model flatModel;
    private MathSys flatMath;
    private int nscratch;

    public Model(ClassLoader cload, String ipath) throws Xcept {
        super(null, "top", null);
        this.classLoader = cload;
        this.importPath = ipath;
        this.unitControl = 0;
        this.units = new UnitNList();
        this.defProps = new CompProp.List(2);
        this.defProps.add((Object)new CompProp(this, "desc", 8));
        this.defProps.add((Object)new CompProp(this, "help", 8));
        this.xfuncs = new XFunc.NList(8);
        this.funcCalls = new Expr.List(8);
        this.templ = new Templ.NList(8);
        this.externJava = new StringList(4);
        new JavaTempl(this, "math", "JSim.mml.MathSys");
        this.realTempl = new JavaTempl(this, "real", "JSim.mml.RealNVar");
        this.intTempl = new JavaTempl(this, "int", "JSim.mml.IntNVar");
        this.realStateTempl = new JavaTempl(this, "realState", "JSim.mml.RealStateVar");
        this.intStateTempl = new JavaTempl(this, "intState", "JSim.mml.IntStateVar");
        this.choiceTempl = new JavaTempl(this, "choice", "JSim.mml.ChoiceNVar");
        this.realDomainTempl = new JavaTempl(this, "realDomain", "JSim.mml.Domain");
        ClassFunc xfunc = new ClassFunc("sum", 4, "JSim.jruntime.RTXSum", this.classLoader);
        xfunc.setReentrant(true);
        this.xfuncs.add((Named)xfunc);
        xfunc = new ClassFunc("integral", 4, "JSim.jruntime.RTXIntegral", this.classLoader);
        xfunc.setReentrant(true);
        this.xfuncs.add((Named)xfunc);
    }

    public void registerXFunc(XFunc f) throws Xcept {
        XFunc f1 = this.xfuncs.xfunc(f.name());
        if (f1 == null) {
            this.xfuncs.add((Named)f);
            return;
        }
        if (!f.sameAs(f1)) {
            throw new Xcept((DiagInfo)f, "conflicting function definitions");
        }
    }

    public void registerTempl(Templ t) throws Xcept {
        if (!this.templ.add(t)) {
            throw new Xcept((DiagInfo)t, "duplicate template name");
        }
    }

    public Templ getTempl(String n) throws Xcept {
        Templ t = this.templ.templ(n);
        if (t == null) {
            throw new Xcept((DiagInfo)this, "Template " + n + " not found");
        }
        return t;
    }

    public JavaTempl realTempl() {
        return this.realTempl;
    }

    public JavaTempl intTempl() {
        return this.intTempl;
    }

    public JavaTempl realStateTempl() {
        return this.realStateTempl;
    }

    public JavaTempl intStateTempl() {
        return this.intStateTempl;
    }

    public JavaTempl choiceTempl() {
        return this.choiceTempl;
    }

    public JavaTempl realDomainTempl() {
        return this.realDomainTempl;
    }

    public void dump(PrintStream out) throws Xcept {
        out.println("============= DUMPING MODEL UNITS");
        this.units.dump(out);
        out.println("============= DUMPING MODEL TEMPLATES");
        for (int i = 0; i < this.templ.size(); ++i) {
            this.templ.templ(i).dump(out, "  ");
        }
        out.println("============= DUMPING MODEL COMPS");
        super.dump(out, "  ");
    }

    public void checkSandbox() throws Xcept {
        for (int i = 0; i < this.xfuncs.size(); ++i) {
            XFunc xfunc = this.xfuncs.xfunc(i);
            if (xfunc.funcType() != 3 || xfunc.lang() == 4) continue;
            throw new Xcept((DiagInfo)xfunc, "Non-Java source functions not allowed in JSim sandbox");
        }
    }

    public void flatten(String flatname) throws Xcept {
        if (this.flatModel != null || this.flatMath != null) {
            return;
        }
        Model mod = this;
        Sys sys = null;
        int ct = 0;
        while (true) {
            if (++ct > 2) {
                throw new Xcept((DiagInfo)this, "Overly recursive model flattening.  Probably BCL bug.");
            }
            if (mod.child.size() == 0) {
                throw new Xcept((DiagInfo)mod, "No components in model");
            }
            if (mod.child.size() > 1) {
                throw new Xcept((DiagInfo)mod, "Multiple top-level model components not yet supported");
            }
            sys = (Sys)mod.child.comp(0);
            if (sys.isFlattenable()) break;
            if (flatname == null) {
                throw new Xcept((DiagInfo)mod, "Flattening requires flatname work file");
            }
            Util.verbose((String)("Flattening system " + sys.name + " (pass " + ct + ") to file " + flatname));
            try {
                FileOutputStream f1 = new FileOutputStream(flatname);
                PrintStream out = new PrintStream(f1, true);
                mod.writeFlat(out);
                if (out != System.out) {
                    out.close();
                }
            }
            catch (FileNotFoundException e) {
                throw new Xcept("IO error for flat file " + flatname);
            }
            mod = new ModelReader(new File(flatname), this.classLoader, this.importPath);
        }
        this.flatModel = mod;
        this.flatMath = (MathSys)sys;
        this.flatMath.setFlat();
        this.flatMath.expandChildDerivs();
        if (this.unitControl == 2) {
            new UnitAssignor(this.flatMath);
            this.flatModel.unitCorrectAll();
        }
        this.flatMath.simplifyAll();
    }

    public Model getFlatModel() throws Xcept {
        if (this.flatModel == null) {
            throw new Xcept((DiagInfo)this, "Model has not been successfully flattened");
        }
        return this.flatModel;
    }

    public MathSys getFlatMath() throws Xcept {
        if (this.flatMath == null) {
            throw new Xcept((DiagInfo)this, "Model has not been successfully flattened");
        }
        return this.flatMath;
    }

    public void writeFlat(PrintStream out) throws Xcept {
        int i;
        if (this.child.size() != 1) {
            throw new Xcept((DiagInfo)this, "Model must contain exactly 1 top-level component");
        }
        Sys top = (Sys)this.child.comp(0);
        out.println("JSim v1.1");
        out.println("");
        if (this.unitControl == 1) {
            out.println("unit conversion off;");
        }
        if (this.unitControl == 2) {
            out.println("unit conversion on;");
        }
        this.units.writeFlat(out);
        for (i = 2; i < this.defProps.size(); ++i) {
            CompProp p = this.defProps.prop(i);
            out.println("property " + p.name() + "=string;");
        }
        top.assignUnits();
        for (i = 0; i < this.xfuncs.size(); ++i) {
            XFunc xfunc = this.xfuncs.xfunc(i);
            String n = xfunc.name();
            if (n.equals("sum") || n.equals("integral")) continue;
            xfunc.writeFlat(out);
        }
        top.ctxt.unitConst = true;
        top.writeFlat(out, top.ctxt);
        top.ctxt.unitConst = false;
    }

    public Expr compByName(Comp comp, String n) throws Xcept {
        NamedExpr e = comp.getNamed(n);
        if (e != null) {
            return e;
        }
        throw new Xcept((DiagInfo)this, n + " unknown");
    }

    public Expr compByName(String n) throws Xcept {
        return this.compByName(this, n);
    }

    public Expr makeDeriv(Expr e1, Expr e2) throws Xcept {
        return new RealBExpr(38, e1, e2);
    }

    public Unit unitByName(String n) throws Xcept {
        return this.units.byName(n);
    }

    public Expr funcCall(String n, Expr.List elist) throws Xcept {
        return this.funcCall((Comp)this, n, elist);
    }

    public Expr funcCall(Comp comp, String n, Expr.List elist) throws Xcept {
        NamedExpr c = comp.getNamed(n);
        if (c != null && c instanceof Var) {
            return this.funcCall(comp, (Var)c, elist);
        }
        XFunc xfunc = this.xfuncs.xfunc(n);
        if (xfunc != null) {
            XFuncCall fc = xfunc.createCall(elist);
            fc.setSeq(xfunc.nextSeq());
            this.funcCalls.add((Object)fc);
            return fc;
        }
        return IExpr.create((String)n, (Expr.List)elist);
    }

    public Expr funcCall(Comp comp, Var v, Expr.List elist) throws Xcept {
        if (v.isDomain() || elist.size() != v.ndim()) {
            throw new Xcept((DiagInfo)v, "variable function requires " + v.ndim() + " arguments");
        }
        Domain.List domlist = v.domainList();
        if (domlist.sameAs(elist)) {
            return v;
        }
        return new VarFuncCall(v, elist);
    }

    public int newScratch() {
        return this.nscratch++;
    }

    public XFunc.NList neededFuncs() {
        XFunc.NList nfuncs = new XFunc.NList(4);
        for (int i = 0; i < this.xfuncs.size(); ++i) {
            XFunc f = this.xfuncs.xfunc(i);
            if (!f.needed()) continue;
            nfuncs.add((Named)f);
        }
        return nfuncs;
    }

    public Expr.List funcCalls() {
        return this.funcCalls;
    }

    public Unit parseUnit(String s) throws Xcept {
        return Unit.parse((NameSpace)this, (String)("1 " + s));
    }
}

