/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.Comp;
import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.util.CrossSet;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.TypedSet;
import JSim.util.Xcept;

public abstract class NVar
extends Var {
    protected Domain.List domain = new Domain.List(2);

    public NVar(Comp p, String n, Expr.List dom) throws Xcept {
        super(p, n, dom);
        if (dom == null) {
            return;
        }
        for (int i = 0; i < dom.size(); ++i) {
            Expr e = dom.expr(i);
            Var d = (Var)e.getNamed();
            if (d == null || !d.isDomain()) {
                throw new Xcept((DiagInfo)e, "Invalid domain for variable " + n);
            }
            for (int j = 0; j < this.domain.size(); ++j) {
                if (d != this.domain.comp(j)) continue;
                throw new Xcept((DiagInfo)this, "Duplicate domain in variable declaration");
            }
            this.domain.add((Object)d);
        }
    }

    public int ndim() {
        return this.domain == null ? 0 : this.domain.size();
    }

    public Domain domain(int i) {
        return (Domain)this.domain.comp(i);
    }

    public boolean isNVar() {
        return true;
    }

    public boolean hasDomain(Var v) {
        for (int i = 0; i < this.domain.size(); ++i) {
            if (this.domain.comp(i) != v) continue;
            return true;
        }
        return false;
    }

    public Expr calculable(Known known) throws Xcept {
        TypedSet s = known.getSet((NamedExpr)this);
        if (this.domain.size() == 0) {
            return s.isEmpty().not();
        }
        TypedSet[] dsarr = new TypedSet[this.ndim()];
        for (int i = 0; i < this.domain.size(); ++i) {
            Domain x = this.domain(i);
            dsarr[i] = known.getDomSet((NamedExpr)x);
        }
        CrossSet xset = new CrossSet(dsarr);
        return s.hasSubset((TypedSet)xset);
    }
}

