/*
 * Decompiled with CFR 0.152.
 */
package JSim.mml;

import JSim.mml.MathSys;
import JSim.mml.Var;

public class VarSet {
    public MathSys math;
    public boolean[] hasVar;
    public int size;

    public VarSet(MathSys m) {
        this.math = m;
        this.hasVar = new boolean[this.math.nVar()];
        this.size = 0;
    }

    public VarSet(VarSet v) {
        this.math = v.math;
        this.hasVar = (boolean[])v.hasVar.clone();
        this.size = v.size;
    }

    public void resize(int sz) {
        if (sz <= this.hasVar.length) {
            return;
        }
        boolean[] nhasVar = new boolean[sz];
        for (int j = 0; j < this.hasVar.length; ++j) {
            nhasVar[j] = this.hasVar[j];
        }
        this.hasVar = nhasVar;
    }

    public void add(Var v) {
        int i = v.flatInx();
        if (i > this.hasVar.length) {
            this.resize(i + 1);
        }
        if (!this.hasVar[i]) {
            ++this.size;
        }
        this.hasVar[i] = true;
    }

    public void add(VarSet v) {
        this.resize(v.hasVar.length);
        for (int i = 0; i < this.hasVar.length; ++i) {
            if (!v.hasVar[i] || this.hasVar[i]) continue;
            ++this.size;
            this.hasVar[i] = true;
        }
    }

    public void add(Var.List vlist) {
        for (int i = 0; i < vlist.size(); ++i) {
            this.add((Var)((Object)vlist.get(i)));
        }
    }

    public void sub(Var v) {
        int i = v.flatInx();
        if (i >= this.hasVar.length) {
            return;
        }
        this.hasVar[i] = false;
    }

    public boolean hasVar(Var v) {
        int inx = v.flatInx();
        return inx >= this.hasVar.length ? false : this.hasVar[v.flatInx()];
    }

    public boolean hasVars(Var.List vlist) {
        for (int i = 0; i < vlist.size(); ++i) {
            Var v = (Var)((Object)vlist.get(i));
            if (this.hasVar(v)) continue;
            return false;
        }
        return true;
    }

    public int subct(VarSet v) {
        this.resize(v.hasVar.length);
        int ct = 0;
        for (int i = 0; i < this.hasVar.length; ++i) {
            if (!this.hasVar[i] || v.hasVar[i]) continue;
            ++ct;
        }
        return ct;
    }

    public int size() {
        return this.size;
    }

    public Var.List varList() {
        Var.List list = new Var.List(this.size());
        for (int i = 0; i < this.hasVar.length; ++i) {
            if (!this.hasVar[i]) continue;
            list.add((Object)this.math.var(i));
        }
        return list;
    }

    public String toString() {
        return this.varList().toString();
    }
}

