/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.fzero;

import JSim.data.NamedVal;
import JSim.data.OptimArgs;
import JSim.data.OptimResults;
import JSim.jruntime.RTContext;
import JSim.nml.Solver;
import JSim.nml.fzero.Fzero2Callbacks;
import JSim.nml.opt.OptimFactory;
import JSim.nml.opt.Optimizer;
import JSim.util.Xcept;

public class Fzero2Solver
extends Solver {
    private int n;
    private String unboundAlg;
    private String boundAlg;
    private OptimFactory optimFactory;
    private Optimizer unboundOpt;
    private Optimizer boundOpt;
    private OptimArgs args;

    public Fzero2Solver(Fzero2Callbacks cb, int inx, NamedVal.Query nvals, int nn, OptimFactory factory) throws Xcept {
        super(cb, inx, nvals);
        this.n = nn;
        this.optimFactory = factory;
        this.unboundAlg = this.stringVal("fzero_unbound");
        this.unboundOpt = this.optimFactory.createOptimizer(this.unboundAlg);
        this.boundAlg = this.stringVal("fzero_bound");
        this.boundOpt = this.boundAlg.equals(this.unboundAlg) ? this.unboundOpt : this.optimFactory.createOptimizer(this.boundAlg);
        this.args = new OptimArgs(this.unboundAlg, this.n);
        for (int i = 0; i < this.n; ++i) {
            this.args.xname[i] = "x" + i;
            this.args.xistep[i] = this.realVal("fzero_istep");
        }
        this.args.maxCalls = this.n * this.intVal("fzero_maxcalls");
        this.args.errTol = this.realVal("fzero_errtol");
        this.args.stepTol = 0.0;
        this.args.gradTol = 0.0;
        this.args.saveLogs = false;
        this.args.maxIters = this.n * this.intVal("fzero_maxiters");
        this.args.eps = this.realVal("fzero_eps");
        this.args.npoints = this.intVal("fzero_npoints");
        this.args.randomSeed = this.intVal("fzero_randseed");
        this.args.initTemp = this.realVal("fzero_inittemp");
    }

    public String solverName() {
        return "Non-linear zero finder";
    }

    public void solve(RTContext ctxt, Fzero2Callbacks cbs, double[] guess, double[] min, double[] max, double[] result) throws Xcept {
        int i;
        Optimizer opt = this.boundOpt;
        for (i = 0; i < this.n; ++i) {
            if (!Double.isNaN(min[i]) || !Double.isNaN(max[i])) continue;
            opt = this.unboundOpt;
            break;
        }
        for (i = 0; i < this.n; ++i) {
            if (Double.isNaN(guess[i])) {
                guess[i] = (max[i] + min[i]) / 2.0;
            }
            if (!Double.isNaN(guess[i])) continue;
            guess[i] = 1.0;
        }
        this.args.alg = opt == this.boundOpt ? this.boundAlg : this.unboundAlg;
        this.args.xstart = guess;
        this.args.xmin = min;
        this.args.xmax = max;
        OptimResults results = new OptimResults(this.args);
        opt.optimize(ctxt, results, cbs);
        for (int i2 = 0; i2 < this.n; ++i2) {
            result[i2] = results.bestX[i2];
        }
        double err = cbs.calcError(ctxt, result, results);
        if (err <= this.args.errTol) {
            return;
        }
        throw new Xcept("Variables " + cbs.solvedVarsText() + " exceeded specified zero-finder error: " + " (" + err + ">" + this.args.errTol + ")");
    }
}

