/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.opt;

import JSim.data.OptimAlg;
import JSim.data.OptimArgs;
import JSim.data.OptimResults;
import JSim.jruntime.RTContext;
import JSim.nml.opt.OptimCallbacks;
import JSim.nml.opt.Optimizer;
import JSim.util.Xcept;

public class Genetic
extends Optimizer {
    public static OptimAlg.Info algInfo() {
        OptimAlg.Info algInfo = new OptimAlg.Info();
        algInfo.name = "genetic";
        algInfo.boundsNeeded = true;
        algInfo.sensMatNeeded = false;
        algInfo.parsNeeded = new String[]{"maxIters", "populationSize", "mutationRate", "crowding"};
        algInfo.optimClassName = Genetic.class.getName();
        return algInfo;
    }

    public void optimize(RTContext ctxt, OptimResults res, OptimCallbacks cbs) throws Xcept {
        OptimArgs args = res.args;
        System.err.println("GS mut=" + args.mutationRate);
        if (args.mutationRate < 0.0 || args.mutationRate > 1.0) {
            throw new Xcept("Genetic Optimizer: illegal mutationRate=" + args.mutationRate);
        }
        if (args.crossoverRate < 0.0 || args.crossoverRate > 1.0) {
            throw new Xcept("Genetic Optimizer: illegal crossoverRate=" + args.crossoverRate);
        }
        throw new Xcept("Genetic algorithm not yet implemented");
    }

    private void term(OptimResults res, String crit) {
        res.status = 1;
        res.termMsg = "Met " + crit + " stopping criterion";
    }

    public String diagInfo() {
        return "Genetic Optimizer";
    }

    public boolean allowMP() {
        return true;
    }
}

