/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.opt;

import JSim.data.OptimAlg;
import JSim.data.OptimArgs;
import JSim.data.OptimResults;
import JSim.jruntime.RTContext;
import JSim.nml.opt.OptimCallbacks;
import JSim.nml.opt.Optimizer;
import JSim.util.DiagInfo;
import JSim.util.Xcept;

public class NL2sol
extends Optimizer {
    private OptimArgs args;
    private OptimCallbacks cbs;
    private OptimResults res;

    public static OptimAlg.Info algInfo() {
        OptimAlg.Info algInfo = new OptimAlg.Info();
        algInfo.name = "nl2sol";
        algInfo.boundsNeeded = false;
        algInfo.sensMatNeeded = false;
        algInfo.parsNeeded = new String[0];
        algInfo.optimClassName = NL2sol.class.getName();
        return algInfo;
    }

    public void optimize(RTContext ctxt, OptimResults r, OptimCallbacks c) throws Xcept {
        this.res = r;
        this.args = this.res.args;
        this.cbs = c;
        int nr = 1;
        int n = this.args.nx();
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = this.args.xstart[i];
        }
        int[] iv = new int[84 + n];
        double[] v = new double[105 + n * (nr + 2 * n + 17) + 3 * nr];
        int[] istop = new int[1];
        int liv = 84 + n;
        int lv = 105 + n * (nr + 2 * n + 17) + 3 * nr;
        int iout = -1;
        try {
            int threadInx = ctxt == null ? 0 : ctxt.threadInx;
            this.nl2sol(threadInx, ctxt, nr, n, x, iv, liv, v, lv, new double[]{this.args.errTol}, this.args.maxCalls, iout, istop);
            this.res.status = istop[0];
            for (int i = 0; i < n; ++i) {
                this.res.bestX[i] = x[i];
            }
            this.res.finalStep = Double.NaN;
            switch (this.res.status) {
                case 0: {
                    this.res.status = 1;
                    this.res.termMsg = "Normal termination";
                    break;
                }
                case 1: {
                    this.res.status = 1;
                    this.res.termMsg = "Met Min RMS error stopping criterion";
                    break;
                }
                case 2: {
                    this.res.status = 1;
                    this.res.termMsg = "Met # calls stopping criterion";
                    break;
                }
                case 3: {
                    this.res.status = 3;
                    this.res.termMsg = "Optimization canceled by user";
                    break;
                }
                default: {
                    this.res.status = 3;
                    this.res.termMsg = "Undocumented error code (" + istop[0] + ")";
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof Xcept) {
                Xcept xe = (Xcept)((Object)e);
                this.res.termMsg = xe.cleanMessage();
                throw xe;
            }
            this.res.termMsg = e.getMessage();
            throw new Xcept((DiagInfo)this, this.res.termMsg);
        }
        if (this.res.status == 3) {
            throw new Xcept("NL2sol optimizer: " + this.res.termMsg);
        }
    }

    private native void nl2sol(int var1, RTContext var2, int var3, int var4, double[] var5, int[] var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, int[] var13) throws Exception;

    public native void abort(int var1);

    public double fcn(RTContext ctxt, double[] x) {
        try {
            return this.cbs.calcError(ctxt, x, this.res);
        }
        catch (Exception e) {
            int threadInx = ctxt == null ? 0 : ctxt.threadInx;
            this.abort(threadInx);
            return Double.NaN;
        }
    }

    public String diagInfo() {
        return "NL2sol Optimizer";
    }

    public boolean allowMP() {
        return false;
    }

    static {
        System.loadLibrary("opt");
    }
}

