/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.opt;

import JSim.data.OptimAlg;
import JSim.nml.opt.GGopt;
import JSim.nml.opt.GridSearch;
import JSim.nml.opt.NL2sol;
import JSim.nml.opt.NelderMead;
import JSim.nml.opt.Optimizer;
import JSim.nml.opt.Sensop;
import JSim.nml.opt.SimAnneal;
import JSim.nml.opt.Simplex;
import JSim.util.Named;
import JSim.util.Plugin;
import JSim.util.StringList;
import JSim.util.Xcept;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class OptimFactory {
    private StringList names = new StringList();
    private ArrayList<ClassLoader> cloaders;
    private ArrayList<OptimAlg.Info> infos = new ArrayList();
    private OptimAlg.NList algs;

    public OptimFactory() {
        this.cloaders = new ArrayList();
        this.algs = new OptimAlg.NList();
        this.add(Simplex.algInfo());
        this.add(GGopt.algInfo());
        this.add(GridSearch.algInfo());
        this.add(NelderMead.algInfo());
        this.add(NL2sol.algInfo());
        this.add(Sensop.algInfo());
        this.add(SimAnneal.algInfo());
    }

    private void add(OptimAlg.Info info) {
        this.add(OptimFactory.class.getClassLoader(), info);
    }

    private void add(ClassLoader cloader, OptimAlg.Info info) {
        this.names.add((Object)info.name);
        this.cloaders.add(cloader);
        this.infos.add(info);
        this.algs.add((Named)new OptimAlg(info));
    }

    public void add(Plugin.List list) throws Xcept {
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.plugin(i));
        }
    }

    public void add(Plugin plugin) throws Xcept {
        if (!plugin.type().equals("Optimizer")) {
            return;
        }
        ClassLoader cloader = plugin.classLoader();
        OptimAlg.Info info = OptimFactory.getInfo(cloader, plugin.className());
        info.name = plugin.variant();
        this.add(cloader, info);
    }

    public Optimizer createOptimizer(String name) throws Xcept {
        int inx = this.names.indexOf(name);
        if (inx < 0) {
            throw new Xcept(name + ": Unknown optimization algorithm");
        }
        ClassLoader cloader = this.cloaders.get(inx);
        String className = this.infos.get((int)inx).optimClassName;
        try {
            return (Optimizer)Plugin.newInstance((ClassLoader)cloader, (String)className, (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (ClassCastException e) {
            throw Xcept.wrap((Throwable)e);
        }
    }

    private static OptimAlg.Info getInfo(ClassLoader cloader, String className) throws Xcept {
        try {
            Class<?> clss = cloader.loadClass(className);
            Method meth = clss.getMethod("algInfo", new Class[0]);
            return (OptimAlg.Info)meth.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw Xcept.wrap((Throwable)e);
        }
    }

    public OptimAlg.Info[] algInfo() {
        return this.infos.toArray(new OptimAlg.Info[0]);
    }

    public OptimAlg.NList algs() {
        return this.algs;
    }

    public static void main(String[] args) throws Exception {
        String name = args[0];
        OptimFactory factory = new OptimFactory();
        OptimAlg alg = factory.algs().alg(name);
        System.err.println("alg=" + alg);
        Optimizer opt = factory.createOptimizer(name);
        System.err.println("opt=" + opt);
    }
}

