/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.opt;

import JSim.data.OptimAlg;
import JSim.data.OptimArgs;
import JSim.data.OptimResults;
import JSim.jruntime.RTContext;
import JSim.nml.opt.OptimCallbacks;
import JSim.nml.opt.Optimizer;
import JSim.util.DiagInfo;
import JSim.util.Util;
import JSim.util.Xcept;

public class SimAnneal
extends Optimizer {
    public static OptimAlg.Info algInfo() {
        OptimAlg.Info algInfo = new OptimAlg.Info();
        algInfo.name = "simanneal";
        algInfo.boundsNeeded = true;
        algInfo.sensMatNeeded = false;
        algInfo.parsNeeded = new String[]{"initTemp"};
        algInfo.optimClassName = SimAnneal.class.getName();
        return algInfo;
    }

    public void optimize(RTContext ctxt, OptimResults res, OptimCallbacks cbs) throws Xcept {
        OptimArgs args = res.args;
        int nx = args.nx();
        double[] x = args.xstart;
        double[] xmin = args.xmin;
        double[] xmax = args.xmax;
        if (Util.hasNaNs((double[])xmin) || Util.hasNaNs((double[])xmax)) {
            throw new Xcept((DiagInfo)this, "xmin & xmax required");
        }
        double ssetl = args.errTol;
        int maxfn = args.maxCalls;
        double[] steps = new double[nx];
        double[][] xpars = new double[nx][nx];
        double[] errs = new double[nx];
        int k = 1;
        double scale0 = 0.10989010989010989;
        double T = args.initTemp;
        if (Double.isNaN(T) || T <= 0.0) {
            throw new Xcept((DiagInfo)this, "Illegal initTemp=" + T);
        }
        double naccept = 1.0;
        double percentAccept = 1.0;
        double err = cbs.calcError(ctxt, x, res);
        while (k < maxfn && err > ssetl) {
            int jx;
            double scale = scale0 * (1.0 + 9.0 * (naccept / (double)k - 0.1));
            steps = this.nextStep(ctxt, x, xmin, xmax, scale);
            for (jx = 0; jx < nx; ++jx) {
                for (int ix = 0; ix < nx; ++ix) {
                    xpars[jx][ix] = x[ix];
                    if (ix != jx) continue;
                    double[] dArray = xpars[jx];
                    int n = ix;
                    dArray[n] = dArray[n] + steps[ix];
                }
            }
            cbs.calcErrors(ctxt, xpars, errs, res);
            k += nx;
            for (jx = 0; jx < nx; ++jx) {
                if (errs[jx] < err) {
                    naccept += 1.0;
                    err = errs[jx];
                    for (int ix = 0; ix < nx; ++ix) {
                        x[ix] = xpars[jx][ix];
                    }
                    if (!(err < ssetl)) continue;
                    this.sendMsg(res, 1);
                    return;
                }
                if (!(err < errs[jx])) continue;
                double small = Math.min(5.0E-4, Math.abs(err + errs[jx]));
                if (!(ctxt.random() < Math.exp((err - errs[jx]) / (0.5 * (err + errs[jx]) / T)))) continue;
                T *= 0.95;
                naccept += 1.0;
                err = errs[jx];
                for (int ix = 0; ix < nx; ++ix) {
                    x[ix] = xpars[jx][ix];
                }
                if (!(err < ssetl)) continue;
                this.sendMsg(res, 1);
                return;
            }
        }
        if (err < ssetl) {
            this.sendMsg(res, 1);
            return;
        }
        if (k > maxfn) {
            this.sendMsg(res, 4);
            return;
        }
        this.sendMsg(res, 0);
    }

    public void sendMsg(OptimResults res, int istat) {
        switch (istat) {
            case 1: {
                this.term(res, "mean sqr error");
                break;
            }
            case 4: {
                this.term(res, "# calls");
                break;
            }
            default: {
                this.termError(res, "Unspecified error in SimAnneal.");
            }
        }
    }

    public double[] nextStep(RTContext ctxt, double[] x, double[] xmin, double[] xmax, double scale) {
        int nx = x.length;
        double[] step = new double[nx];
        int i = 0;
        while (i < nx) {
            double r = ctxt.random();
            double r1 = ctxt.random();
            double r2 = ctxt.random();
            step[i] = r > 0.5 ? (xmax[i] - x[i]) * r1 : (xmin[i] - x[i]) * r2;
            int n = i++;
            step[n] = step[n] * scale;
        }
        return step;
    }

    private void term(OptimResults res, String crit) {
        res.status = 1;
        res.termMsg = "Met " + crit + " stopping criterion";
    }

    private void termError(OptimResults res, String crit) {
        res.status = 3;
        res.termMsg = crit;
    }

    public String diagInfo() {
        return "SimAnneal Optimizer";
    }

    public boolean allowMP() {
        return true;
    }
}

