/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.pde1;

public class InterpolationLinear {
    double[] x;
    double[] y;

    public InterpolationLinear(double[] x, double[] y) {
        this.x = x;
        this.y = y;
    }

    public double valueAt(double xfit) {
        int n = this.x.length;
        if (xfit < this.x[0]) {
            return this.y[0];
        }
        if (xfit > this.x[n - 1]) {
            return this.y[n - 1];
        }
        int klo = 0;
        int khi = n - 1;
        while (khi - klo > 1) {
            int k = khi + klo >> 1;
            if (this.x[k] > xfit) {
                khi = k;
                continue;
            }
            klo = k;
        }
        double h = this.x[khi] - this.x[klo];
        if (h == 0.0) {
            return Double.MIN_VALUE;
        }
        double a = this.y[klo];
        double b = (this.y[khi] - this.y[klo]) / h;
        double yfit = a + b * (xfit - this.x[klo]);
        return yfit;
    }
}

