/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.pde1;

import JSim.jruntime.RTContext;
import JSim.nml.ode1.ODE1Callbacks;
import JSim.nml.ode1.ODE1Solver;
import JSim.nml.pde1.PDE1Slave;
import JSim.nml.pde1.PDE1Solver;
import JSim.util.Xcept;

public class PDE1SolverLSFEA2
extends PDE1Slave
implements ODE1Callbacks {
    public static final String solverName = "LSFEA2";
    private ODE1Solver odeSolver;
    private boolean firstTime;
    private boolean canContinue;
    private double[] xitg;
    private double timein;
    private double[] ont0;
    private double[][] wt;
    private int[] nwt;
    private boolean[] ondfr;
    private double[] vel;
    private double odeXValue;
    private double[] zeroes;
    private double[] f1;
    private double[] f2;
    private double[] f3;
    private double[] g1;
    private double[] g2;
    private double[] g3;

    public PDE1SolverLSFEA2(PDE1Solver s) throws Xcept {
        super(s, solverName);
        this.odeSolver = new ODE1Solver(this, -1, this.solver.namedVals(), this.npde());
        this.firstTime = true;
        this.canContinue = true;
        this.odeXValue = Double.NaN;
        this.zeroes = new double[this.npde()];
        this.f1 = new double[this.npde()];
        this.f2 = new double[this.npde()];
        this.f3 = new double[this.npde()];
        this.g1 = new double[this.npde()];
        this.g2 = new double[this.npde()];
        this.g3 = new double[this.npde()];
    }

    public boolean isReentrant() {
        return false;
    }

    public void evaluate(RTContext ctxt, double t, double[] u, double[] udot) throws Xcept {
        this.callbacks().LSFEA_tstep(ctxt, t, this.odeXValue, u, udot);
    }

    public void solve(RTContext ctxt, double t0, double tfinal, double[] xgrid, double[][] u0, double[][] uf, double[][] ut0, double[][] utf, double[][] ux0, double[][] uxf, double[][] uxt0, double[][] uxtf, double[] v0, double[] vf, double[] vt0, double[] vtf) throws Xcept {
        int i;
        for (i = 0; i < u0.length; ++i) {
            for (int j = 0; j < u0[0].length; ++j) {
                uf[i][j] = u0[i][j];
            }
        }
        this.callbacks().common_LHB(ctxt, t0, this.zeroes, this.f1, this.f2, this.f3);
        this.callbacks().common_RHB(ctxt, t0, this.zeroes, this.g1, this.g2, this.g3);
        for (i = 0; i < u0.length; ++i) {
            if (this.f1[i] != 0.0) {
                double d = this.f3[i] / this.f1[i];
                uf[i][0] = d;
                u0[i][0] = d;
            }
            if (this.g1[i] != 0.0) {
                double d = this.g3[i] / this.g1[i];
                uf[i][u0[0].length - 1] = d;
                u0[i][u0[0].length - 1] = d;
            }
            if (this.f1[i] != 0.0 && this.g1[i] != 0.0) {
                this.fail("At least one of f1 and g1 must be zero");
            }
            if (this.f2[i] != 0.0 || this.g2[i] != 0.0) continue;
            this.fail("At least one of f2 and g2 must be non-zero");
        }
        double[][] uxxf = new double[u0.length][u0[0].length];
        this.oneTStep(ctxt, t0, tfinal, xgrid, uf, utf, uxf, uxxf);
    }

    private void fail(String msg) throws Xcept {
        throw new Xcept("LSFEA PDE solver: " + msg + " (use MacCormack or Toms731 instead)");
    }

    public void oneTStep(RTContext ctxt, double t, double tend, double[] xgrid, double[][] u, double[][] ut, double[][] ux, double[][] uxx) throws Xcept {
        int i;
        double dt;
        if (!this.canContinue) {
            return;
        }
        double[] coefX = new double[u.length];
        double[] coefXX = new double[u.length];
        double[] uu = new double[u.length * u[0].length];
        this.callbacks().LSFEA_xstep(ctxt, t, xgrid[0], uu, coefX, coefXX);
        int neqn = coefX.length;
        int ngrid = xgrid.length;
        for (int i2 = 0; i2 < neqn; ++i2) {
            if (coefXX[i2] < 0.0) {
                throw new Xcept("LSFEA solver failure: negative diffusion term");
            }
            if (coefX[i2] == 0.0) {
                if (this.f1[i2] == 0.0 && this.f3[i2] == 0.0 && this.g1[i2] == 0.0 && this.g3[i2] == 0.0) continue;
                this.fail("Zero advection requires zero f1, f3, g1 and g3");
                continue;
            }
            if (coefX[i2] > 0.0) {
                if (this.f1[i2] != 0.0) continue;
                this.fail("Positive advection requires non-zero f1");
                continue;
            }
            if (!(coefX[i2] < 0.0) || this.g1[i2] != 0.0) continue;
            this.fail("Negative advection requires non-zero g1");
        }
        if (ngrid % 2 == 0) {
            this.canContinue = false;
            this.fail("Number of grid points must be an odd");
        }
        int nseg = (ngrid - 1) / 2;
        double xlen = xgrid[xgrid.length - 1] - xgrid[0];
        double tStepSize = dt = tend - t;
        this.vel = new double[neqn];
        for (int i3 = 0; i3 < neqn; ++i3) {
            this.vel[i3] = coefX[i3] / xlen;
            if (!(Math.abs(this.vel[i3]) < 1.0E-9)) continue;
            this.vel[i3] = 0.0;
        }
        double minVel = 0.0;
        for (i = 0; i < neqn; ++i) {
            if (!(this.vel[i] != 0.0 && Math.abs(this.vel[i]) < minVel) && minVel != 0.0) continue;
            minVel = Math.abs(this.vel[i]);
        }
        if (minVel == 0.0) {
            this.canContinue = false;
            throw new Xcept("Solver failure: convection terms cannot be all zero. Try other solvers.");
        }
        tStepSize = 1.0 / ((double)nseg * minVel);
        if (this.firstTime) {
            this.firstTime = false;
            this.timein = t - dt;
            this.xitg = new double[neqn];
            this.ont0 = new double[neqn];
            this.nwt = new int[neqn];
            this.ondfr = new boolean[neqn];
            this.wt = new double[neqn][2 * nseg];
            for (i = 0; i < neqn; ++i) {
                this.xitg[i] = 0.0;
                this.ont0[i] = 0.0;
                this.ondfr[i] = false;
                if (!(coefXX[i] > 0.0) || nseg < 3) continue;
                this.nwt[i] = this.ddifcf(nseg, xlen, tStepSize, coefXX[i], this.wt[i]);
                if (nseg < 3 || !(xlen > 0.0)) continue;
                this.ondfr[i] = true;
            }
        }
        double[][] useg = new double[neqn][nseg + 2];
        this.gridToSeg(neqn, useg, u);
        double[] velRatio = new double[neqn];
        double[] uin = new double[neqn];
        double[] oitg = new double[neqn];
        double[] uout = new double[neqn];
        for (int i4 = 0; i4 < neqn; ++i4) {
            velRatio[i4] = minVel > 0.0 ? this.vel[i4] / minVel : 0.0;
            uin[i4] = this.vel[i4] > 0.0 ? u[i4][0] : (this.vel[i4] < 0.0 ? u[i4][ngrid - 1] : 0.0);
            if (Double.isNaN(uin[i4])) {
                uin[i4] = 0.0;
            }
            int n = i4;
            this.xitg[n] = this.xitg[n] + uin[i4] * dt;
            oitg[i4] = 0.0;
            uout[i4] = 0.0;
        }
        double[] uode = new double[neqn];
        double[] uodedot = new double[neqn];
        double oamt = 0.0;
        int nstep = (int)((t - this.timein) / tStepSize);
        if (nstep > 0) {
            for (int k = 0; k < nstep; ++k) {
                int i5;
                double t0 = this.timein;
                this.timein += tStepSize;
                for (i5 = 0; i5 < neqn; ++i5) {
                    if (velRatio[i5] == 0.0) continue;
                    double xtmp = (t - this.timein) * uin[i5];
                    double uavg = (this.xitg[i5] - xtmp) / tStepSize;
                    this.xitg[i5] = xtmp;
                    if (this.vel[i5] > 0.0) {
                        useg[i5][0] = uavg;
                    } else if (this.vel[i5] < 0.0) {
                        useg[i5][nseg + 1] = uavg;
                    }
                    oamt = this.slide(useg[i5], velRatio[i5], tStepSize, true);
                    int n = i5;
                    oitg[n] = oitg[n] + oamt;
                }
                for (int j = 1; j <= nseg; ++j) {
                    int jinx = 2 * j - 1;
                    this.odeAryAt(uode, useg, j);
                    this.odeXValue = this.callbacks().LSFEA_setX(ctxt, jinx);
                    this.odeSolver.solve(ctxt, t0, t0 + tStepSize, uode, uode);
                    this.pdeAryAt(useg, uode, j);
                }
                for (i5 = 0; i5 < neqn; ++i5) {
                    if (!this.ondfr[i5]) continue;
                    this.dwmwav(nseg, useg[i5], this.nwt[i5], this.wt[i5]);
                }
            }
        }
        double textra = t - this.timein;
        for (int i6 = 0; i6 < neqn; ++i6) {
            if (velRatio[i6] != 0.0) {
                oamt = this.slide(useg[i6], velRatio[i6], textra, false);
                int n = i6;
                oitg[n] = oitg[n] + (oamt - this.ont0[i6]);
                this.ont0[i6] = oamt;
            }
            uout[i6] = oitg[i6] / dt;
            if (this.vel[i6] > 0.0) {
                useg[i6][nseg + 1] = uout[i6];
                u[i6][ngrid - 1] = uout[i6];
                continue;
            }
            if (!(this.vel[i6] < 0.0)) continue;
            useg[i6][0] = uout[i6];
            u[i6][0] = uout[i6];
        }
        this.segToGrid(neqn, u, useg);
    }

    public double slide(double[] useg, double vRatio, double dt, boolean flg) {
        int i;
        double oamt = 0.0;
        if (Math.abs(vRatio) < 1.0E-6) {
            return oamt;
        }
        int nseg = useg.length - 2;
        int ish = (int)Math.abs(vRatio);
        double extra = Math.abs(vRatio) - (double)ish;
        if (vRatio > 0.0) {
            for (i = 1; i <= ish; ++i) {
                oamt += useg[nseg + 1 - i];
            }
            oamt += extra * useg[nseg - ish];
        } else {
            for (i = 1; i <= ish; ++i) {
                oamt += useg[i];
            }
            oamt += extra * useg[ish + 1];
        }
        oamt = oamt / Math.abs(vRatio) * dt;
        if (!flg) {
            return oamt;
        }
        double scal1 = extra;
        double scal2 = 1.0 - extra;
        if (vRatio > 0.0) {
            int i2;
            if (scal1 == 0.0) {
                for (i2 = nseg; i2 >= ish + 1; --i2) {
                    useg[i2] = useg[i2 - ish];
                }
            } else {
                for (i2 = nseg; i2 >= ish + 1; --i2) {
                    useg[i2] = scal1 * useg[i2 - ish - 1] + scal2 * useg[i2 - ish];
                }
            }
            for (i2 = 1; i2 <= ish; ++i2) {
                useg[i2] = useg[0];
            }
        } else {
            int i3;
            if (scal1 == 0.0) {
                for (i3 = 1; i3 <= nseg - ish; ++i3) {
                    useg[i3] = useg[i3 + ish];
                }
            } else {
                for (i3 = 1; i3 <= nseg - ish; ++i3) {
                    useg[i3] = scal1 * useg[i3 + ish + 1] + scal2 * useg[i3 + ish];
                }
            }
            for (i3 = nseg - ish + 1; i3 <= nseg; ++i3) {
                useg[i3] = useg[nseg + 1];
            }
        }
        return oamt;
    }

    public void gridToSeg(int neqn, double[][] useg, double[][] u) {
        int nseg = useg[0].length;
        int ngrid = u[0].length;
        for (int i = 0; i < neqn; ++i) {
            useg[i][0] = u[i][0];
            useg[i][nseg - 1] = u[i][ngrid - 1];
            for (int j = 1; j < nseg - 1; ++j) {
                int j2 = this.vel[i] < 0.0 ? 2 * j - 2 : 2 * j;
                useg[i][j] = u[i][j2];
            }
        }
    }

    public void segToGrid(int neqn, double[][] u, double[][] useg) {
        int nseg = useg[0].length;
        int ngrid = u[0].length;
        for (int i = 0; i < neqn; ++i) {
            u[i][0] = useg[i][0];
            u[i][ngrid - 1] = useg[i][nseg - 1];
            for (int j = 1; j < nseg - 1; ++j) {
                if (this.vel[i] < 0.0) {
                    u[i][2 * j - 2] = useg[i][j];
                } else {
                    u[i][2 * j] = useg[i][j];
                }
                if (j >= nseg) continue;
                u[i][2 * j - 1] = this.vel[i] >= 0.0 ? (useg[i][j - 1] + useg[i][j]) / 2.0 : (useg[i][j] + useg[i][j + 1]) / 2.0;
            }
            if (this.vel[i] != 0.0) continue;
            u[i][0] = u[i][1];
            u[i][1] = 2.0 * u[i][2] - u[i][3];
        }
    }

    public void odeAryAt(double[] des, double[][] src, int j) {
        for (int i = 0; i < des.length; ++i) {
            des[i] = src[i][j];
        }
    }

    public void pdeAryAt(double[][] des, double[] src, int j) {
        for (int i = 0; i < src.length; ++i) {
            des[i][j] = src[i];
        }
    }

    public int ddifcf(int nseg, double xlen, double dt, double d, double[] w) {
        double dx = xlen / (double)nseg;
        double dx2 = dx / 2.0;
        double diff = d * 2.0 * dt / (dx * dx);
        if (diff <= 0.25 || nseg <= 5) {
            int nw = 3;
            w[1] = Math.exp(-diff);
            w[0] = 0.5 * (1.0 - w[1]);
            w[2] = w[0];
            return nw;
        }
        int nhafp1 = Math.min((int)(4.0 * Math.sqrt(diff)), nseg - 1) + 1;
        int nw = 2 * nhafp1 - 1;
        double scale = 0.5 / Math.sqrt(d * dt);
        double x = 0.0;
        double sum = 0.0;
        for (int i = nhafp1 - 1; i >= 0; --i) {
            w[i] = 0.5 * (this.erf((x + dx2) * scale) - this.erf((x - dx2) * scale));
            w[nw - 1 - i] = w[i];
            sum += w[i];
            x += dx;
        }
        sum = 2.0 * sum - w[nhafp1 - 1];
        double rsum = 1.0;
        if (sum > 0.0) {
            rsum = 1.0 / sum;
            int i = 0;
            while (i < nw) {
                int n = i++;
                w[n] = w[n] * rsum;
            }
        }
        return nw;
    }

    public void dwmwav(int nf, double[] f, int nspan, double[] w) {
        double[] wk = new double[nf + nspan];
        int nhalf = nspan / 2;
        if (nhalf > nf || nspan <= 1) {
            return;
        }
        for (int i = 0; i < nf; ++i) {
            wk[i + nhalf] = f[i + 1];
            f[i + 1] = 0.0;
        }
        int index = nhalf;
        for (int i = 0; i < nhalf; ++i) {
            wk[--index] = wk[i + nhalf];
            wk[nf + i + nhalf] = wk[nf - i + nhalf - 1];
        }
        for (int j = 0; j < nf; ++j) {
            for (int i = 0; i < nspan; ++i) {
                int n = j + 1;
                f[n] = f[n] + w[i] * wk[j + i];
            }
        }
    }

    public double erf(double x) {
        double fval;
        double a1 = 0.254829592;
        double a2 = -0.284496736;
        double a3 = 1.421413741;
        double a4 = -1.453152027;
        double a5 = 1.061405429;
        double scale = 0.3275911;
        double c1 = 1.1283791671;
        double c2 = 0.6666666666;
        double c3 = 0.2666666666;
        double ax = Math.abs(x);
        double ax2 = ax * ax;
        if (ax > 0.1) {
            double z = 1.0 / (1.0 + scale * ax);
            fval = 1.0 - z * Math.exp(-ax2) * (a1 + z * (a2 + z * (a3 + z * (a4 + z * a5))));
        } else {
            double ax3 = ax * ax2;
            fval = c1 * Math.exp(-ax2) * (ax + c2 * ax3 + c3 * ax3 * ax2);
        }
        if (x < 0.0) {
            fval = -fval;
        }
        return fval;
    }
}

