/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.pde1;

import JSim.jruntime.RTContext;
import JSim.nml.pde1.InterpolationSpline;
import JSim.nml.pde1.PDE1Callbacks;
import JSim.nml.pde1.PDE1Slave;
import JSim.nml.pde1.PDE1Solver;
import JSim.util.Xcept;

public class PDE1SolverToms731
extends PDE1Slave {
    public static final String solverName = "Toms731 (moving-grid)";
    private int neqn;
    private int ngrid;

    public PDE1SolverToms731(PDE1Solver s) throws Xcept {
        super(s, solverName);
    }

    public void solve(RTContext ctxt, double t0, double tfinal, double[] xgrid, double[][] u0, double[][] uf, double[][] ut0, double[][] utf, double[][] ux0, double[][] uxf, double[][] uxt0, double[][] uxtf, double[] v0, double[] vf, double[] vt0, double[] vtf) throws Xcept {
        int i;
        for (int i2 = 0; i2 < u0.length; ++i2) {
            for (int j = 0; j < u0[0].length; ++j) {
                uf[i2][j] = u0[i2][j];
            }
        }
        double[] zeros = new double[u0.length];
        double[] beta = new double[u0.length];
        double[] gamma = new double[u0.length];
        for (i = 0; i < u0.length; ++i) {
            zeros[i] = 0.0;
        }
        this.callbacks().Toms731_LHB(ctxt, t0, zeros, zeros, beta, gamma);
        for (i = 0; i < u0.length; ++i) {
            if (beta[i] != 0.0) continue;
            double d = -gamma[i];
            uf[i][0] = d;
            u0[i][0] = d;
        }
        this.callbacks().Toms731_RHB(ctxt, t0, zeros, zeros, beta, gamma);
        for (i = 0; i < u0.length; ++i) {
            if (beta[i] != 0.0) continue;
            double d = -gamma[i];
            uf[i][u0[0].length - 1] = d;
            u0[i][u0[0].length - 1] = d;
        }
        this.oneTStep(ctxt, t0, tfinal, xgrid, u0, uf);
    }

    public void oneTStep(RTContext ctxt, double t, double tend, double[] xgrid, double[][] u0, double[][] u) throws Xcept {
        int i;
        this.neqn = u.length;
        this.ngrid = xgrid.length;
        double[] y = new double[(this.neqn + 1) * this.ngrid];
        double[] movingGrid = new double[this.ngrid];
        double[][] movingY = new double[this.neqn][this.ngrid];
        for (int i2 = 0; i2 < this.neqn; ++i2) {
            for (int j = 0; j < this.ngrid; ++j) {
                y[i2 + j * (this.neqn + 1)] = u[i2][j];
            }
        }
        int idid = PDE1SolverToms731.jtoms731(ctxt.threadInx, ctxt, this.neqn, t, tend, this.ngrid, xgrid[0], xgrid[this.ngrid - 1], u0, y, this.callbacks());
        if (idid < 0 && idid < 0) {
            throw new Xcept("Toms731 (moving-grid) faild: idid=" + idid);
        }
        InterpolationSpline[] spline = new InterpolationSpline[this.neqn];
        for (i = 0; i < this.ngrid; ++i) {
            movingGrid[i] = y[(this.neqn + 1) * (i + 1) - 1];
        }
        for (int j = 0; j < this.neqn; ++j) {
            for (int i3 = 0; i3 < this.ngrid; ++i3) {
                movingY[j][i3] = y[(this.neqn + 1) * i3 + j];
            }
            spline[j] = new InterpolationSpline(movingGrid, movingY[j], 0.0, 0.0);
        }
        for (i = 0; i < this.neqn; ++i) {
            for (int j = 0; j < this.ngrid; ++j) {
                u[i][j] = j == 0 || j == this.ngrid - 1 ? y[i + j * (this.neqn + 1)] : spline[i].splint(movingGrid, movingY[i], xgrid[j]);
            }
        }
    }

    static native int jtoms731(int var0, RTContext var1, int var2, double var3, double var5, int var7, double var8, double var10, double[][] var12, double[] var13, PDE1Callbacks var14);

    static {
        System.loadLibrary("pdesolver");
    }
}

