/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan;

import JSim.aserver.ASConstraint;
import JSim.aserver.ASModel;
import JSim.data.NamedVal;
import JSim.mml.Var;
import JSim.plan.Calc;
import JSim.plan.DEBlockToolIF;
import JSim.plan.DomainCalc;
import JSim.plan.ExprCalc;
import JSim.plan.FuncCalc;
import JSim.plan.FzeroProc;
import JSim.plan.FzeroToolIF;
import JSim.plan.IfCalc;
import JSim.plan.LoopCalc;
import JSim.plan.MultiCalc;
import JSim.plan.ODEProc;
import JSim.plan.PDEProc;
import JSim.plan.PlanIF;
import JSim.plan.PlanWriter;
import JSim.plan.Proc;
import JSim.plan.ProcCalc;
import JSim.plan.RelationCalc;
import JSim.plan.SetCalc;
import JSim.plan.TopProc;
import JSim.util.JSLang;
import JSim.util.Xcept;

public class JSPlanWriter
extends PlanWriter {
    public JSPlanWriter(PlanIF p) {
        super(p, JSLang.lang);
    }

    protected void write() throws Xcept {
        int i;
        NamedVal.NList props = new NamedVal.NList();
        this.plan.addProperties(props);
        ASConstraint.List cons = new ASConstraint.List(this.plan.getConstraints());
        this.println("Variables:");
        ++this.indent;
        for (i = 0; i < this.plan.math().nVar(); ++i) {
            NamedVal p;
            String vq;
            Var v = this.plan.math().var(i);
            String s = this.plan.inputVars().contains((Object)v) ? "Input " : "Output ";
            StringBuffer buf = new StringBuffer(s + (Object)((Object)v));
            if (v.unit() != null) {
                buf.append(v.unit().pubName());
            }
            if ((vq = v.toString()).endsWith("__init")) {
                vq = vq.substring(0, vq.length() - 6);
            }
            if ((p = props.nval(vq + ".calc")) != null) {
                buf.append(" " + p.stringVal() + ":");
            }
            ASConstraint.List vcons = cons.constraints(vq, 2);
            for (int j = 0; j < vcons.size(); ++j) {
                buf.append(" " + vcons.constraint(j) + ";");
            }
            this.println(buf.toString());
        }
        --this.indent;
        this.println("Cacheable vars:");
        ++this.indent;
        this.println(this.plan.cache().toString());
        --this.indent;
        this.println("Required units:");
        ++this.indent;
        this.println(this.plan.units().toString());
        --this.indent;
        this.println("Allow MP Runs: " + this.allowMPRuns());
        this.println("");
        this.writeProc(this.plan.mainProc());
        this.println("");
        for (i = 0; i < this.plan.procs().size(); ++i) {
            Proc p = this.plan.procs().proc(i);
            this.writeProc(p);
            this.println("");
        }
    }

    public void write(TopProc proc) throws Xcept {
        this.println("method " + proc.name + " {");
        ++this.indent;
        this.writeCalc(proc.mcalc);
        --this.indent;
        this.println("}");
    }

    public void write(FzeroProc proc) throws Xcept {
        int i;
        FzeroToolIF tool = proc.tool;
        this.println("sub-class " + proc.name + " loops=" + (Object)((Object)proc.loopDomains()) + " {");
        ++this.indent;
        for (i = 0; i < tool.exprs().size(); ++i) {
            this.println("tmp[" + i + "] = " + tool.exprs().expr(i) + ";");
        }
        for (i = 0; i < tool.vsol().size(); ++i) {
            Var v = tool.vsol().var(i);
            if (tool.vmin(i) != null) {
                this.println("" + (Object)((Object)v) + ">=" + tool.vmin(i));
            }
            if (tool.vmax(i) != null) {
                this.println("" + (Object)((Object)v) + "<=" + tool.vmax(i));
            }
            if (tool.vapprox(i) == null) continue;
            this.println("" + (Object)((Object)v) + "~=" + tool.vapprox(i));
        }
        --this.indent;
        this.println("}");
    }

    public void write(ODEProc proc) throws Xcept {
        this.println("sub-class " + proc.name + " loops=" + (Object)((Object)proc.loopDomains()) + " {");
        ++this.indent;
        this.writeCalc(proc.calc);
        --this.indent;
        this.println("}");
    }

    public void write(PDEProc proc) throws Xcept {
        this.println("sub-class " + proc.name + " loops=" + (Object)((Object)proc.loopDomains()) + " {");
        ++this.indent;
        DEBlockToolIF block = proc.block;
        for (int i = 0; i < ASModel.PDE_Solvers.length; ++i) {
            if (block.usesPDESolver(i)) continue;
            this.println(ASModel.PDE_Solvers[i] + " not implemented: " + block.getSolverMessage(i));
        }
        this.write_common(proc);
        if (block.usesPDESolver(0)) {
            this.write_LSFEA(proc);
        }
        if (block.usesPDESolver(1)) {
            this.write_MacCormack(proc);
        }
        if (block.usesPDESolver(2)) {
            this.write_Toms731(proc);
        }
        --this.indent;
        this.println("}");
    }

    public void write_common(PDEProc proc) throws Xcept {
        int i;
        DEBlockToolIF block = proc.block;
        this.println("method common_LHB {");
        ++this.indent;
        this.writeCalc(proc.lcalc);
        for (i = 0; i < block.nState(); ++i) {
            this.println("f1[" + i + "]=" + block.coefF1(i, true).toString() + ";");
            this.println("f2[" + i + "]=" + block.coefF2(i, true).toString() + ";");
            this.println("f3[" + i + "]=" + block.coefF3(i, true).toString() + ";");
        }
        --this.indent;
        this.println("}");
        this.println("method common_RHB {");
        ++this.indent;
        this.writeCalc(proc.rcalc);
        for (i = 0; i < block.nState(); ++i) {
            this.println("f1[" + i + "]=" + block.coefF1(i, false).toString() + ";");
            this.println("f2[" + i + "]=" + block.coefF2(i, false).toString() + ";");
            this.println("f3[" + i + "]=" + block.coefF3(i, false).toString() + ";");
        }
        --this.indent;
        this.println("}");
    }

    public void write_LSFEA(PDEProc proc) throws Xcept {
        int i;
        DEBlockToolIF block = proc.block;
        this.println("method lsfea_tcalc {");
        ++this.indent;
        this.writeCalc(proc.ecalc);
        for (i = 0; i < block.nState(); ++i) {
            this.println(block.vt(i).toString() + "=" + block.coefS(i).toString() + ";");
        }
        --this.indent;
        this.println("}");
        this.println("method lsfea_xcalc {");
        ++this.indent;
        this.writeCalc(proc.ecalc);
        for (i = 0; i < block.nState(); ++i) {
            this.println("coefB[" + i + "]=" + block.coefB(i).toString() + ";");
            this.println("coefD[" + i + "]=" + block.coefD(i).toString() + ";");
        }
        --this.indent;
        this.println("}");
    }

    public void write_MacCormack(PDEProc proc) throws Xcept {
        DEBlockToolIF block = proc.block;
        this.println("method MacCormack_State {");
        ++this.indent;
        this.writeCalc(proc.ecalc);
        for (int i = 0; i < block.nState(); ++i) {
            this.println("coefB[" + i + "]=" + block.coefB(i).toString() + ";");
            this.println("coefD[" + i + "]=" + block.coefD(i).toString() + ";");
            this.println("coefS[" + i + "]=" + block.coefS(i).toString() + ";");
        }
        --this.indent;
        this.println("}");
    }

    private void write_Toms731(PDEProc proc) throws Xcept {
        int i;
        DEBlockToolIF block = proc.block;
        this.println("method Toms731_State {");
        ++this.indent;
        this.writeCalc(proc.ecalc);
        for (i = 0; i < block.nState(); ++i) {
            this.println("C[" + i + "]=" + block.toms731_C(i).toString() + ";");
            this.println("Q[" + i + "]=" + block.toms731_Q(i).toString() + ";");
            this.println("R[" + i + "]=" + block.toms731_R(i).toString() + ";");
        }
        --this.indent;
        this.println("}");
        this.println("method Toms_LHB {");
        ++this.indent;
        this.writeCalc(proc.lcalc);
        for (i = 0; i < block.nState(); ++i) {
            this.println("BETA[" + i + "]=" + block.toms731_BETA(i, true).toString() + ";");
            this.println("GAMMA[" + i + "]=" + block.toms731_GAMMA(i, true).toString() + ";");
        }
        --this.indent;
        this.println("}");
        this.println("method Toms_RHB {");
        ++this.indent;
        this.writeCalc(proc.rcalc);
        for (i = 0; i < block.nState(); ++i) {
            this.println("BETA[" + i + "]=" + block.toms731_BETA(i, false).toString() + ";");
            this.println("GAMMA[" + i + "]=" + block.toms731_GAMMA(i, false).toString() + ";");
        }
        --this.indent;
        this.println("}");
    }

    public void write(ExprCalc calc) throws Xcept {
        this.println(calc.v.toString() + " = " + calc.expr + ";");
    }

    public void write(DomainCalc calc) throws Xcept {
        this.println(calc.toString() + ";");
    }

    public void write(FuncCalc calc) throws Xcept {
        this.println(calc.toString() + "();");
    }

    public void write(SetCalc calc) throws Xcept {
        if (calc.calc.size() == 0) {
            return;
        }
        String s = calc.isLHBC() ? "LHBC" : "RHBC";
        this.println("At " + s + "(" + (Object)((Object)calc.x) + ") {");
        ++this.indent;
        for (int i = 0; i < calc.calc.size(); ++i) {
            Calc c = calc.calc.calc(i);
            this.writeCalc(c);
        }
        --this.indent;
        this.println("}");
    }

    public void write(LoopCalc calc) throws Xcept {
        if (calc.loop.size() == 0) {
            return;
        }
        this.println("Loop over " + (Object)((Object)calc.x) + " {");
        ++this.indent;
        this.writeCalc(calc.loop);
        --this.indent;
        this.println("}");
    }

    public void write(IfCalc calc) throws Xcept {
        if (calc.isEmpty()) {
            return;
        }
        this.println("if (" + calc.test + ")");
        if (calc.pass != null) {
            ++this.indent;
            this.writeCalc(calc.pass);
            --this.indent;
        }
        if (calc.fail != null) {
            this.println("else");
            ++this.indent;
            this.writeCalc(calc.fail);
            --this.indent;
        }
    }

    public void write(MultiCalc calc) throws Xcept {
        for (int i = 0; i < calc.calc.size(); ++i) {
            Calc c = calc.calc.get(i);
            this.writeCalc(c);
        }
    }

    public void write(ProcCalc calc) throws Xcept {
        this.println("call " + calc.proc.name + "()");
    }

    public void write(RelationCalc calc) throws Xcept {
        this.println("enforce " + calc.expr);
    }
}

