/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mml.Domain;
import JSim.mml.RealNVar;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.plan1.DEConTool;
import JSim.plan1.ExprTool;
import JSim.plan1.Tool;
import JSim.plan1.ToolBox;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.IfExpr;
import JSim.util.Known;
import JSim.util.NamedQueryExpr;
import JSim.util.Util;
import JSim.util.Xcept;

public class DETool
extends Tool {
    protected RealNVar v;
    public Domain.List vdoms;
    protected DEConTool.List cons;
    protected boolean complete;
    protected Domain t;
    protected Var vt;
    protected Tool ictool;
    protected RealNVar vic;
    protected Domain x;
    protected Var vx;
    protected Var vxx;
    protected Expr coefD;
    protected Expr coefDx;
    protected Expr coefP;
    protected Expr coefB;
    protected Expr coefS;
    protected Expr[] coefF;
    protected Expr[] coefG;

    public DETool(ToolBox b, Var vv) throws Xcept {
        super(b);
        this.v = (RealNVar)vv;
        this.vdoms = new Domain.List(1);
        this.v.addDomains(this.vdoms);
        this.vsol.add((Object)this.v);
        this.vreq = new Var.List(1);
        this.sdsol = SubDom.entire();
        this.sdcalc = SubDom.entire();
        this.cons = new DEConTool.List(3);
        this.complete = false;
    }

    public void addCon(DEConTool con) throws Xcept {
        if (this.cons.contains(con)) {
            return;
        }
        Util.verbose((String)("\t" + this + " addCon: " + con));
        if (this.cons.con(con.sdcalc) != null) {
            throw new Xcept((DiagInfo)this, (DiagInfo)con, "Duplicate DE contraint");
        }
        this.cons.addUniq(con);
        this.checkComplete();
        con.borg.add(this);
        this.box.update(this);
        if (this.complete && this.x != null) {
            this.factorPDE();
        }
    }

    public DEConTool state() {
        return this.cons.con(SubDom.entire());
    }

    public DEConTool lhbc(Domain z) throws Xcept {
        return this.cons.con(z.lhbc());
    }

    public DEConTool rhbc(Domain z) throws Xcept {
        return this.cons.con(z.rhbc());
    }

    public boolean isODE() {
        return this.x == null;
    }

    public Var v() {
        return this.v;
    }

    public Var vt() {
        return this.vt;
    }

    public Var vx() {
        return this.vx;
    }

    public Var t() {
        return this.t;
    }

    public Var x() {
        return this.x;
    }

    public Tool sdTool(SubDom sd) throws Xcept {
        DEConTool con = this.cons.con(sd);
        if (con != null) {
            return con.tool;
        }
        if (this.complete) {
            return this;
        }
        return null;
    }

    public String calcInfo(Var v) {
        if (this.x == null) {
            return "ODE(" + (Object)((Object)this.t) + ")";
        }
        return "PDE(" + (Object)((Object)this.t) + "," + (Object)((Object)this.x) + ")";
    }

    public String checkComplete() throws Xcept {
        Var.List vlist;
        this.complete = false;
        this.x = null;
        this.t = null;
        this.vxx = null;
        this.vx = null;
        this.vt = null;
        if (this.state() == null) {
            return "No state equation";
        }
        if (this.cons.domains.size() > 2) {
            throw new Xcept((DiagInfo)this, "PDEs of >2 dimensions not supported");
        }
        for (int i = 0; i < this.cons.domains.size(); ++i) {
            Domain z = this.cons.domains.domain(i);
            if (this.cons.con(z.lhbc()) == null || this.cons.con(z.rhbc()) != null) continue;
            this.t = z;
            break;
        }
        if (this.t == null) {
            return "IC missing";
        }
        if (this.cons.domains.size() > 1) {
            int tinx = this.cons.domains.indexOf((Object)this.t);
            this.x = this.cons.domains.domain(1 - tinx);
            if (this.cons.con(this.x.lhbc()) == null) {
                return "PDE LHBC missing";
            }
            if (this.cons.con(this.x.rhbc()) == null) {
                return "PDE RHBC missing";
            }
        }
        this.vt = this.v.deriv(this.t);
        if (this.x != null) {
            this.vx = this.v.deriv(this.x);
            this.vxx = this.vx.deriv(this.x);
            this.vt.setAccess(2);
            this.vx.setAccess(2);
            this.vxx.setAccess(2);
        }
        if (!(vlist = this.state().vsol()).contains((Object)this.vt)) {
            throw new Xcept((DiagInfo)this.v, "State eqn does not solve " + (Object)((Object)this.vt));
        }
        boolean xderiv = false;
        for (int i = 0; i < vlist.size(); ++i) {
            Var u = vlist.var(i);
            if (u.zeroDeriv() != this.v) continue;
            int n = u.nDeriv();
            for (int j = 0; j < n; ++j) {
                Domain z = u.derivDomain();
                u = u.unDeriv();
                if (z == this.t) continue;
                if (z == this.x) {
                    xderiv = true;
                    continue;
                }
                if (this.x == null) {
                    return "PDE missing BCs for " + (Object)((Object)z);
                }
                throw new Xcept((DiagInfo)this, "PDE state eqn contains illegal deriv " + (Object)((Object)u.deriv(z)));
            }
        }
        if (this.x != null && !xderiv) {
            throw new Xcept((DiagInfo)this, "ODE does not require BCs for " + (Object)((Object)this.x));
        }
        this.complete = true;
        return null;
    }

    public void validate() throws Xcept {
        String msg = this.checkComplete();
        if (msg != null) {
            throw new Xcept((DiagInfo)this.v, msg);
        }
        this.ictool = this.lhbc((Domain)this.t).tool;
        if (this.ictool == null || !this.ictool.vsol.contains((Object)this.v)) {
            throw new Xcept((DiagInfo)this, "Tool-based IC required for " + (Object)((Object)this.v));
        }
        this.ictool.unborg(this.lhbc(this.t));
        this.cons.remove(this.lhbc(this.t));
        if (this.x == null) {
            this.vsol.add((Object)this.vt);
            this.vsol.addUniq(this.state().vsol());
        }
        for (int i = 0; i < this.cons.size(); ++i) {
            this.vreq.addUniq(this.cons.con(i).vreq());
        }
        this.createVIC();
    }

    private void createVIC() throws Xcept {
        if (!this.ictool.isInputTool()) {
            return;
        }
        if (!(this.ictool instanceof ExprTool)) {
            return;
        }
        Expr icexpr = ((ExprTool)this.ictool).expr();
        Expr.List icdoms = new Expr.List(this.v.ndim() - 1);
        for (int i = 0; i < this.v.ndim(); ++i) {
            Domain z = this.v.domain(i);
            if (z == this.t) continue;
            icdoms.add((Object)z);
        }
        this.vic = new RealNVar(this.box.math, this.v.name() + "__init", icdoms);
        this.vic.setUnit(this.v.unit());
        ExprTool tool = new ExprTool(this.box, this.v, (Expr)this.vic, this.t.lhbc());
        this.box.addTool(tool);
        this.ictool.borg.add(tool);
        tool = new ExprTool(this.box, this.vic, icexpr, SubDom.entire());
        this.box.addTool(tool);
    }

    private void factorPDE() throws Xcept {
        Expr e0 = this.state().zeroExpr();
        Util.verbose((String)("\tfactoring PDE: " + e0 + " = 0"));
        Expr coefVT = e0.linearFactor((NamedQueryExpr)this.vt, true).simplify();
        e0 = e0.linearFactor((NamedQueryExpr)this.vt, false).mult((Expr)Expr.negone).simplify();
        this.coefD = e0.linearFactor((NamedQueryExpr)this.vxx, true).div(coefVT);
        this.coefD = this.coefD.simplify();
        this.coefP = e0.linearFactor((NamedQueryExpr)this.vxx, false).div(coefVT).simplify();
        try {
            this.coefDx = this.coefD.takeDeriv((Expr)this.x);
        }
        catch (Xcept e) {
            this.coefDx = null;
        }
        Util.verbose((String)("\t    coefD = " + this.coefD));
        Util.verbose((String)("\t    coefD:x = " + this.coefDx));
        Util.verbose((String)("\t    coefP = " + this.coefP));
        Expr.List list = new Expr.List(1);
        this.coefD.addNamedExpr(list);
        this.coefP.addNamedExpr(list);
        if (list.contains((Object)this.vt) || list.contains((Object)this.vxx)) {
            throw new Xcept((DiagInfo)this, "PDE could not be factored to ideal form");
        }
        this.checkNoDerivs(this.state(), "D", this.coefD);
        if (this.realVal(this.coefD) < 0.0) {
            throw new Xcept((DiagInfo)this.state(), "PDE has negative diffusion term: " + this.coefD);
        }
        this.coefB = this.coefP.linearFactor((NamedQueryExpr)this.vx, true).mult((Expr)Expr.negone).simplify();
        this.coefS = this.coefP.linearFactor((NamedQueryExpr)this.vx, false).simplify();
        list = new Expr.List(1);
        this.coefD.addNamedExpr(list);
        this.coefB.addNamedExpr(list);
        this.coefS.addNamedExpr(list);
        if (list.contains((Object)this.vx)) {
            this.coefS = null;
            this.coefB = null;
        } else if (this.containsDerivs(this.coefB) || this.containsDerivs(this.coefS)) {
            this.coefS = null;
            this.coefB = null;
        }
        if (this.coefDx != null) {
            this.coefDx.addNamedExpr((Expr.List)this.state().vreq);
        }
        this.coefF = this.factorBC(this.lhbc(this.x));
        this.coefG = this.factorBC(this.rhbc(this.x));
    }

    private Expr[] factorBC(DEConTool con) throws Xcept {
        Expr[] fs = new Expr[3];
        Expr bcz = con.zeroExpr().simplify();
        fs[0] = bcz.linearFactor((NamedQueryExpr)this.v, true).simplify();
        Expr rem = bcz.linearFactor((NamedQueryExpr)this.v, false).simplify();
        fs[1] = rem.linearFactor((NamedQueryExpr)this.vx, true).simplify();
        Expr f3 = rem.linearFactor((NamedQueryExpr)this.vx, false).mult((Expr)Expr.negone);
        fs[2] = f3.simplify();
        Expr.List list = new Expr.List(1);
        fs[0].addNamedExpr(list);
        fs[1].addNamedExpr(list);
        fs[2].addNamedExpr(list);
        if (list.contains((Object)this.vt) || list.contains((Object)this.vx) || list.contains((Object)this.vxx)) {
            throw new Xcept((DiagInfo)con, "PDE BC cannot be factored to form f1*v + f2*vx = f3");
        }
        this.checkNoDerivs(con, "f1-f3", fs);
        return fs;
    }

    private void checkNoDerivs(DEConTool con, String f, Expr[] exprs) throws Xcept {
        for (int i = 0; i < exprs.length; ++i) {
            this.checkNoDerivs(con, f, exprs[i]);
        }
    }

    private void checkNoDerivs(DEConTool con, String f, Expr expr) throws Xcept {
        if (this.containsDerivs(expr)) {
            throw new Xcept((DiagInfo)con, "Derivatives not allowed in PDE factor " + f);
        }
    }

    private boolean containsDerivs(Expr expr) throws Xcept {
        Expr.List list = new Expr.List();
        expr.addNamedExpr(list);
        for (int i = 0; i < list.size(); ++i) {
            Var v;
            if (!(list.get(i) instanceof Var) || !(v = (Var)((Object)list.get(i))).isDeriv()) continue;
            return true;
        }
        return false;
    }

    public void lsfea1OK() throws Xcept {
        if (this.coefB == null) {
            throw new Xcept("PDE state eqn not factorable");
        }
        for (int i = 0; i < this.box.size(); ++i) {
            Tool tool = this.box.tool(i);
            Var vaux = null;
            if (tool.vreq().contains((Object)this.vt)) {
                vaux = this.vt;
            }
            if (tool.vreq().contains((Object)this.vx)) {
                vaux = this.vx;
            }
            if (this.vxx != null && tool.vreq().contains((Object)this.vxx)) {
                vaux = this.vxx;
            }
            if (vaux == null) continue;
            throw new Xcept("" + (Object)((Object)vaux) + " required later by " + tool);
        }
        if (this.lhbc(this.x).lsfeaBC0(this.v) && this.rhbc(this.x).lsfeaBC1(this.vx)) {
            return;
        }
        if (this.rhbc(this.x).lsfeaBC0(this.v) && this.lhbc(this.x).lsfeaBC1(this.vx)) {
            return;
        }
        if (this.lhbc(this.x).lsfeaBC1(this.vx) && this.rhbc(this.x).lsfeaBC1(this.vx)) {
            return;
        }
        throw new Xcept("PDE BCs not supported");
    }

    public void lsfea2OK(Var.List vblock) throws Xcept {
        if (this.coefB == null) {
            throw new Xcept("PDE state eqn not factorable");
        }
        this.checkXInvariance("Advection", this.coefB);
        this.checkXInvariance("Diffusion", this.coefD);
        if (this.realVal(this.coefD) < 0.0) {
            throw new Xcept("Negative diffusion term: " + this.coefD);
        }
        double Bval = this.realVal(this.coefB);
        if (Bval == 0.0 && (this.realValNonZero(this.coefF1(true)) || this.realValNonZero(this.coefF1(false)) || this.realValNonZero(this.coefF3(true)) || this.realValNonZero(this.coefF3(false)))) {
            throw new Xcept("Zero advection requires zero f1, f3, g1 and g3");
        }
        if (Bval > 0.0 && this.realVal(this.coefF1(true)) == 0.0) {
            throw new Xcept("Positive advection requires non-zero f1");
        }
        if (Bval < 0.0 && this.realVal(this.coefF1(false)) == 0.0) {
            throw new Xcept("Negative advection requires non-zero g1");
        }
        if (this.realValNonZero(this.coefF1(true)) && this.realValNonZero(this.coefF1(false))) {
            throw new Xcept("At least one of f1,g1 must be zero");
        }
        if (this.realVal(this.coefF2(true)) == 0.0 && this.realVal(this.coefF2(false)) == 0.0) {
            throw new Xcept("At least one of f2,g2 must be non-zero");
        }
        for (int i = 0; i < this.box.size(); ++i) {
            Tool tool = this.box.tool(i);
            Var vaux = null;
            if (tool.vreq().contains((Object)this.vt)) {
                vaux = this.vt;
            }
            if (tool.vreq().contains((Object)this.vx)) {
                vaux = this.vx;
            }
            if (this.vxx != null && tool.vreq().contains((Object)this.vxx)) {
                vaux = this.vxx;
            }
            if (vaux == null) continue;
            throw new Xcept("" + (Object)((Object)vaux) + " required later by " + tool);
        }
        this.lsfea2BCOK(vblock, this.lhbc(this.x), this.coefF);
        this.lsfea2BCOK(vblock, this.rhbc(this.x), this.coefG);
    }

    private void checkXInvariance(String n, Expr expr) throws Xcept {
        Expr.List doms = new Expr.List();
        expr.addDomains(doms);
        if (doms.containSame((Expr)this.x)) {
            throw new Xcept(n + " term " + expr + " has spatial dependence");
        }
    }

    private double realVal(Expr expr) throws Xcept {
        return expr.isConst() ? expr.constRealVal() : Double.NaN;
    }

    private boolean realValNonZero(Expr expr) throws Xcept {
        double d = this.realVal(expr);
        if (Double.isNaN(d)) {
            return false;
        }
        return d != 0.0;
    }

    private void lsfea2BCOK(Var.List vblock, DEConTool con, Expr[] fs) throws Xcept {
        Expr.List list = new Expr.List(1);
        fs[0].addNamedExpr(list);
        fs[1].addNamedExpr(list);
        fs[2].addNamedExpr(list);
        if (list.containAny((Expr.List)vblock)) {
            throw new Xcept("BC " + con + " depends on block variable");
        }
    }

    public void macCormackOK() throws Xcept {
        if (this.coefB == null || this.coefS == null) {
            throw new Xcept("PDE state equation not factorable");
        }
        Expr.List list = new Expr.List(1);
        this.coefD.addNamedExpr(list);
        this.coefB.addNamedExpr(list);
        this.coefS.addNamedExpr(list);
        if (list.contains((Object)this.vx)) {
            throw new Xcept("Unsupported " + this.vx.name() + " in PDE state eqn");
        }
        if (this.realVal(this.coefD) < 0.0) {
            throw new Xcept("Negative diffusion term: " + this.coefD);
        }
    }

    public void toms731OK() throws Xcept {
        if (this.realVal(this.coefD) < 0.0) {
            throw new Xcept("Negative diffusion term: " + this.coefD);
        }
        if (this.coefDx == null) {
            throw new Xcept("Diffusion term not symbolically differentiable");
        }
    }

    public void vxxToolCreate() throws Xcept {
        if (this.vxx == null) {
            return;
        }
        for (int i = 0; i < this.box.size(); ++i) {
            Tool tool = this.box.tool(i);
            if (!tool.vreq().contains((Object)this.vxx)) continue;
            ExprTool vxxtool = new ExprTool(this.box, this.vxx, this.vxxExpr(), SubDom.entire());
            this.box.addTool(vxxtool);
            break;
        }
    }

    public boolean lsfeaXcoef() throws Xcept {
        return this.coefB != null && !this.coefB.sameAs((Expr)Expr.zero);
    }

    public String toString() {
        String s = "DE " + (Object)((Object)this.v);
        return s;
    }

    public Expr vxxExpr() throws Xcept {
        Expr e = this.vt.add(this.coefP);
        e = Expr.negone.mult(e).div(this.coefD);
        return e.simplify();
    }

    public Expr coefD() throws Xcept {
        return this.coefD;
    }

    public Expr coefB() throws Xcept {
        if (this.coefB == null) {
            throw new Xcept("This PDE can't be factored to -B*u:x + S form");
        }
        return this.coefB;
    }

    public Expr coefS() throws Xcept {
        if (this.coefS == null) {
            throw new Xcept("This PDE can't be factored to -B*u:x + S form");
        }
        return this.coefS;
    }

    public Expr coefF1(boolean left) {
        return left ? this.coefF[0] : this.coefG[0];
    }

    public Expr coefF2(boolean left) {
        return left ? this.coefF[1] : this.coefG[1];
    }

    public Expr coefF3(boolean left) {
        return left ? this.coefF[2] : this.coefG[2];
    }

    public Expr toms731_C() throws Xcept {
        return Expr.one;
    }

    public Expr toms731_Q() throws Xcept {
        return this.coefDx.mult((Expr)this.vx).sub(this.coefP).simplify();
    }

    public Expr toms731_R() throws Xcept {
        return this.coefD.mult((Expr)this.vx).simplify();
    }

    public Expr toms731_BETA(boolean left) throws Xcept {
        DEConTool con = left ? this.lhbc(this.x) : this.rhbc(this.x);
        Expr f2 = this.coefF2(left);
        IfExpr beta = new IfExpr(f2.eq((Expr)Expr.zero), (Expr)Expr.zero, (Expr)Expr.one);
        return beta.simplify();
    }

    public Expr toms731_GAMMA(boolean left) throws Xcept {
        DEConTool con = left ? this.lhbc(this.x) : this.rhbc(this.x);
        Expr bcz = con.zeroExpr().simplify();
        Expr f1 = this.coefF1(left);
        Expr f2 = this.coefF2(left);
        IfExpr GB0 = new IfExpr(f1.eq((Expr)Expr.zero), bcz, bcz.div(f1));
        Expr GB1 = this.vx.sub(bcz.div(f2)).mult(this.coefD).simplify();
        IfExpr gamma = new IfExpr(f2.eq((Expr)Expr.zero), (Expr)GB0, GB1);
        return gamma.simplify();
    }

    public void sequencable(Known k) throws Xcept {
        throw new Xcept((DiagInfo)this, "DETool.sequencable() not implemented");
    }
}

