/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mml.Event;
import JSim.mml.MathSys;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.plan1.EventTool;
import JSim.plan1.ExprTool;
import JSim.plan1.Tool;
import JSim.plan1.ToolBox;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Util;
import JSim.util.Xcept;

public class EventBuilder {
    private ToolBox box;
    private Tool.List etools;

    public EventBuilder(ToolBox b) throws Xcept {
        this.box = b;
        MathSys math = this.box.math;
        this.etools = new Tool.List(math.events.size());
        for (int i = 0; i < math.events.size(); ++i) {
            Event.List elist = new Event.List(1);
            Event event = math.events.event(i);
            for (int j = 0; j < event.nactions(); ++j) {
                Var v = event.v(j);
                if (v.isState()) continue;
                throw new Xcept((DiagInfo)event, (DiagInfo)v, "Event action LHS must be a state variable");
            }
            elist.add(event);
            EventTool tool = new EventTool(this.box, elist);
            this.etools.add(tool);
        }
        boolean working = true;
        while (working) {
            working = false;
            Object[] otools = this.etools.toArray();
            this.etools = new Tool.List(otools.length);
            for (int i = 0; i < otools.length; ++i) {
                EventTool itool = (EventTool)otools[i];
                if (itool == null) continue;
                Var.List ivars = new Var.List(itool.vsol.size());
                Event.List ievents = new Event.List(math.events.size());
                ivars.addUniq(itool.vsol);
                ievents.addAll(itool.events);
                for (int j = i + 1; j < otools.length; ++j) {
                    Var.List jvars;
                    EventTool jtool = (EventTool)otools[j];
                    if (jtool == null || !ivars.containAny(jvars = jtool.vsol)) continue;
                    working = true;
                    ivars.addUniq(jvars);
                    ievents.addAll(jtool.events);
                    otools[j] = null;
                }
                EventTool etool = new EventTool(this.box, ievents);
                this.etools.add(etool);
            }
        }
        for (int i = 0; i < this.etools.size(); ++i) {
            Util.verbose((String)("\tmerged event tool: " + this.etools.tool(i)));
        }
    }

    public void build() throws Xcept {
        int i;
        for (i = 0; i < this.etools.size(); ++i) {
            EventTool etool = (EventTool)this.etools.tool(i);
            if (etool.hasAllBCs()) continue;
            for (int j = 0; j < etool.vsol.size(); ++j) {
                Var v;
                Tool bctool;
                if (etool.bctools[j] != null || (bctool = this.box.tool(v = etool.vsol.var(j), etool.t.lhbc())) == null) continue;
                etool.setBC(j, bctool);
            }
            if (!etool.hasAllBCs()) continue;
            this.box.addTool(etool);
        }
        for (i = 0; i < this.box.math.nVar(); ++i) {
            Var v0;
            Var v = this.box.math.var(i);
            if (v.nDeriv() == 0 || !(v0 = v.zeroDeriv()).isState() || this.box.tool(v, SubDom.entire()) != null) continue;
            ExprTool e = new ExprTool(this.box, v, (Expr)Expr.zero, SubDom.entire());
            this.box.addTool(e);
        }
    }

    public void validate() throws Xcept {
        Var.List missing = new Var.List(4);
        for (int i = 0; i < this.etools.size(); ++i) {
            EventTool etool = (EventTool)this.etools.tool(i);
            for (int j = 0; j < etool.vsol.size(); ++j) {
                if (etool.bctools[j] != null) continue;
                missing.add((Object)etool.vsol.var(j));
            }
        }
        if (missing.size() > 0) {
            throw new Xcept("State variable(s) missing ICs: " + (Object)((Object)missing));
        }
    }
}

