/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mml.Domain;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.plan.ExprCalc;
import JSim.plan1.PlanSeq;
import JSim.plan1.SequenceXcept;
import JSim.plan1.Tool;
import JSim.plan1.ToolBox;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.Xcept;

public class ExprTool
extends Tool {
    public Var v;
    public Expr expr;
    private boolean origConst;

    public ExprTool(ToolBox b, Var vv, Expr xpr, SubDom sd) throws Xcept {
        super(b);
        this.v = vv;
        this.expr = xpr;
        this.vsol.add((Object)this.v);
        this.sdsol = ExprTool.relaxSD(this.v, sd);
        this.vreq = new Var.List(this.expr);
        this.sdcalc = sd;
        this.origConst = this.expr.isConst();
    }

    public static SubDom relaxSD(Var v, SubDom sd) {
        if (sd.isEntire()) {
            return sd;
        }
        Domain x = sd.bcDomain();
        if (v.hasDomain(x)) {
            return sd;
        }
        return SubDom.entire();
    }

    public Expr expr() {
        return this.expr;
    }

    public String calcInfo(Var v) {
        return "expr";
    }

    public boolean isInputTool() {
        if (!this.origConst) {
            return false;
        }
        if (this.v.isPrivate()) {
            return false;
        }
        return this.v.nDeriv() <= 0;
    }

    public void validate() throws Xcept {
        this.validateDomains(this.expr);
        Expr old = this.expr;
        this.expr = this.box.simplify(this.expr);
    }

    public Tool iccopy(Domain t) throws Xcept {
        if (!this.v.hasDomain(t)) {
            return null;
        }
        return new ExprTool(this.box, this.v, this.expr, t.lhbc());
    }

    public void addCalc(PlanSeq seq) throws Xcept {
        ExprCalc c = new ExprCalc(this.v, this.expr);
        seq.mcalc.add(c);
    }

    public void sequencable(Known known) throws Xcept, SequenceXcept {
        this.satisfied(known, this.sdcalc.expr, "SubDom");
        this.calculable(known, this.expr);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean showSD) {
        String s = this.v.toString();
        if (showSD && !this.sdsol.isEntire()) {
            s = s + "[" + this.sdsol + "]";
        }
        s = s + " = " + this.expr;
        if (showSD && !this.sdcalc.isEntire() && !this.sdcalc.sameAs(this.sdsol)) {
            s = s + "[" + this.sdcalc + "]";
        }
        return s;
    }
}

