/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mml.Eqn;
import JSim.mml.EqnSet;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.mml.VarSet;
import JSim.plan1.BoundBuilder;
import JSim.plan1.FzeroTool;
import JSim.plan1.ToolBox;
import JSim.plan1.ToolBuilder;
import JSim.util.DiagInfo;
import JSim.util.Util;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FzeroBuilder
extends ToolBuilder {
    public static final int ADDGROUPTHRESH = 2;
    protected VarSet[] unsolvedVars;
    protected SubDom sdom;
    protected RankedEqnSet eqns;

    public FzeroBuilder(ToolBox b) throws Xcept {
        super(b);
    }

    public void build() throws Xcept {
        int i;
        SubDom.List sdlist = new SubDom.List(1);
        ArrayList<RankedEqnSet> sdeqnset = new ArrayList<RankedEqnSet>(1);
        this.unsolvedVars = new VarSet[this.box.math.eqn.size()];
        for (i = 0; i < this.box.math.eqn.size(); ++i) {
            int j;
            Eqn eqn = this.box.math.eqn.eqn(i);
            if (!eqn.isEqn() || this.box.tool(eqn) != null) continue;
            VarSet vars = new VarSet(this.box.math);
            Var.List vlist = eqn.varList();
            for (j = 0; j < vlist.size(); ++j) {
                Var v = vlist.var(j);
                if (this.box.tool(v, eqn.sdom()) != null) continue;
                vars.add(v);
            }
            this.unsolvedVars[eqn.flatInx()] = vars;
            for (j = 0; j < sdlist.size() && !eqn.sdom().sameAs(sdlist.sdom(j)); ++j) {
            }
            if (j == sdlist.size()) {
                sdlist.add(eqn.sdom());
                sdeqnset.add(new RankedEqnSet(this));
            }
            RankedEqnSet eset = (RankedEqnSet)sdeqnset.get(j);
            eset.add(eqn);
        }
        for (i = 0; i < sdlist.size(); ++i) {
            if (!this.buildSD(sdlist.sdom(i), (RankedEqnSet)sdeqnset.get(i))) continue;
            return;
        }
    }

    private boolean buildSD(SubDom sd, RankedEqnSet eset) throws Xcept {
        this.sdom = sd;
        this.eqns = eset;
        Util.verbose((String)("FzeroBuilder: " + this.eqns.size() + " eqns for SD " + this.sdom + ", likely vars" + (Object)((Object)this.box.likelyVars())));
        Util.verbose((String)this.eqns.diagInfo());
        this.eqns.sort();
        boolean[] addbl = new boolean[this.box.math.eqn.size()];
        for (int i = 0; i < this.eqns.size(); ++i) {
            this.box.checkCancel();
            Eqn eqn = this.eqns.eqn(i);
            addbl[eqn.flatInx()] = true;
            Util.verbose((String)("\tseed " + eqn));
            EqnGroup wgroup = new EqnGroup(this, eqn, addbl);
            EqnGroup rgroup = wgroup.expand();
            if (rgroup == null) continue;
            rgroup.makeTool();
            return true;
        }
        return false;
    }

    private VarSet vars(Eqn eqn) {
        return this.unsolvedVars[eqn.flatInx()];
    }

    public static class EqnGroup
    extends RankedEqnSet {
        protected VarSet vars;
        protected boolean[] addable;

        public EqnGroup(FzeroBuilder b, Eqn eqn, boolean[] addbl) throws Xcept {
            super(b);
            this.vars = new VarSet(b.box.math);
            this.addable = (boolean[])addbl.clone();
            this.add(eqn);
            this.builder.box.checkCancel();
        }

        public EqnGroup(EqnGroup g) throws Xcept {
            super(g);
            this.vars = new VarSet(g.vars);
            this.addable = (boolean[])g.addable.clone();
            this.builder.box.checkCancel();
        }

        public void add(Eqn eqn) {
            super.add(eqn);
            this.vars.add(this.builder.vars(eqn));
            this.addable[eqn.flatInx()] = false;
        }

        public void makeTool() throws Xcept {
            int i;
            FzeroTool tz = new FzeroTool(this.builder.box, this.builder.sdom);
            for (i = 0; i < this.builder.box.math.nVar(); ++i) {
                if (!this.vars.hasVar[i]) continue;
                tz.add(this.builder.box.math.var(i));
            }
            for (i = 0; i < this.hasEqn.length; ++i) {
                if (!this.hasEqn[i]) continue;
                Eqn eqn = this.builder.box.math.eqn.eqn(i);
                tz.add(eqn);
                this.builder.box.useEqn(eqn, tz);
            }
            tz.vreqSet();
            BoundBuilder.add(tz);
            this.builder.box.addTool(tz);
        }

        public EqnGroup expand() throws Xcept {
            int i;
            boolean[] posit = new boolean[this.addable.length];
            for (i = 0; i < this.addable.length; ++i) {
                Eqn eqn;
                int ct;
                if (!this.addable[i] || (ct = this.builder.vars(eqn = this.builder.box.math.eqn.eqn(i)).subct(this.vars)) > 2) continue;
                if (ct == 0) {
                    this.add(eqn);
                    continue;
                }
                posit[i] = true;
            }
            if (this.size() == this.vars.size()) {
                return this;
            }
            if (this.size() > this.vars.size()) {
                throw new Xcept((DiagInfo)this, "System of eqns overspecifies variables");
            }
            for (i = 0; i < posit.length; ++i) {
                if (!posit[i]) continue;
                EqnGroup wgroup = new EqnGroup(this);
                Eqn eqn = this.builder.box.math.eqn.eqn(i);
                wgroup.add(eqn);
                EqnGroup rgroup = wgroup.expand();
                if (rgroup == null) continue;
                return rgroup;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EqnComparator
    implements Comparator<Eqn> {
        FzeroBuilder builder;

        public EqnComparator(FzeroBuilder b) {
            this.builder = b;
        }

        @Override
        public int compare(Eqn a, Eqn b) {
            return this.nvar(a) - this.nvar(b);
        }

        public int nvar(Eqn eqn) {
            return this.builder.unsolvedVars[eqn.flatInx()].size();
        }
    }

    public static class RankedEqnSet
    extends EqnSet {
        protected FzeroBuilder builder;
        protected Eqn.List sorted;

        public RankedEqnSet(FzeroBuilder bldr) {
            super(bldr.box.math);
            this.builder = bldr;
        }

        public RankedEqnSet(RankedEqnSet e) {
            super(e);
            this.builder = e.builder;
            if (e.sorted != null) {
                this.sorted = (Eqn.List)e.sorted.clone();
            }
        }

        public void sort() {
            this.sorted = new Eqn.List(this.size());
            for (int i = 0; i < this.hasEqn.length; ++i) {
                if (!this.hasEqn[i]) continue;
                this.sorted.add(this.builder.box.math.eqn.eqn(i));
            }
            Collections.sort(this.sorted, new EqnComparator(this.builder));
        }

        public Eqn eqn(int i) {
            return this.sorted.eqn(i);
        }
    }
}

