/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan.Calc;
import JSim.plan.LoopCalc;
import JSim.plan.MultiCalc;
import JSim.plan.SetCalc;
import JSim.plan1.DomCtl;
import JSim.plan1.ExprTool;
import JSim.plan1.Plan;
import JSim.plan1.SequenceXcept;
import JSim.plan1.Tool;
import JSim.plan1.ToolSet;
import JSim.util.CrossSet;
import JSim.util.EntireSet;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.TypedSet;
import JSim.util.Util;
import JSim.util.Xcept;

public class PlanSeq {
    protected Plan plan;
    private String label;
    private int nest;
    protected Known known;
    private Tool.List tools;
    private ToolSet compTools;
    private ToolSet auxTools;
    protected MultiCalc mcalc;
    protected DomCtl domctlTop;
    protected DomCtl domctl;
    private DomCtl.List domctlList;

    public String known(String s) {
        try {
            Var v = (Var)this.plan.math.getChild(s);
            return " known(" + s + ")=" + this.known.getSet((NamedExpr)v);
        }
        catch (Exception e) {
            return " UNKNOWN VARIABLE(" + s + ")";
        }
    }

    public PlanSeq(Plan p, Known k, Tool.List tt) throws Xcept {
        this.plan = p;
        this.label = "mainline";
        this.nest = 0;
        this.domctl = new DomCtl(this.plan.box.domains);
        this.domctlTop = new DomCtl(this.domctl);
        this.known = k;
        this.tools = tt;
        this.compTools = new ToolSet(this.plan.box);
        this.auxTools = new ToolSet(this.plan.box);
        this.mcalc = new MultiCalc(this.tools.size());
        this.buildDomCtlList();
    }

    public PlanSeq(PlanSeq pseq, DomCtl d, String l, Tool.List tt) throws Xcept {
        this.plan = pseq.plan;
        this.label = l;
        this.nest = pseq.nest;
        this.domctl = new DomCtl(d);
        this.domctlTop = new DomCtl(this.domctl);
        this.known = new Known(pseq.known);
        this.tools = new Tool.List(tt);
        this.compTools = new ToolSet(this.plan.box);
        this.auxTools = new ToolSet(this.plan.box);
        this.mcalc = new MultiCalc(this.tools.size());
        this.buildDomCtlList();
    }

    public PlanSeq(PlanSeq pseq) {
        this.plan = pseq.plan;
        this.label = pseq.label + " posit";
        this.nest = pseq.nest;
        this.domctl = new DomCtl(pseq.domctl);
        this.domctlTop = pseq.domctlTop;
        this.known = new Known(pseq.known);
        this.tools = new Tool.List(pseq.tools);
        this.compTools = new ToolSet(pseq.compTools);
        this.auxTools = new ToolSet(pseq.auxTools);
        this.mcalc = new MultiCalc(this.tools.size());
        this.domctlList = pseq.domctlList;
    }

    public PlanSeq(PlanSeq pseq, Tool.List used) {
        this.plan = pseq.plan;
        this.label = pseq.label + " semi";
        this.nest = pseq.nest;
        this.domctl = new DomCtl(pseq.domctl);
        this.domctlTop = pseq.domctlTop;
        this.known = new Known(pseq.known);
        this.tools = new Tool.List(used);
        this.compTools = new ToolSet(this.plan.box);
        this.auxTools = new ToolSet(pseq.auxTools);
        this.mcalc = new MultiCalc(this.tools.size());
        this.domctlList = pseq.domctlList;
    }

    public void buildDomCtlList() throws Xcept {
        int i;
        this.msg("PlanSeq (" + this.label + ")");
        ++this.nest;
        this.msg("Tools to sequence:");
        this.msg(1, this.tools);
        this.domctlList = new DomCtl.List(4);
        for (i = 0; i < this.tools.size(); ++i) {
            Tool tool = this.tools.tool(i);
            DomCtl dctl = this.domctl(tool);
            this.domctlList.addUniq(dctl);
        }
        this.msg("DomCtls to check:");
        for (i = 0; i < this.domctlList.size(); ++i) {
            DomCtl d = this.domctlList.domctl(i);
            this.msg(1, d.toString());
        }
    }

    public void append(MultiCalc pcalc) throws Xcept {
        if (!this.compTools.hasTools(this.tools)) {
            Tool tool;
            int i;
            this.msg("==== SUCCESSFULLY SEQUENCED TOOLS : " + this.label);
            for (i = 0; i < this.tools.size(); ++i) {
                tool = this.tools.tool(i);
                if (!this.compTools.hasTool(tool)) continue;
                this.msg("  " + tool);
            }
            this.msg("==== UNSEQUENCED TOOLS : " + this.label);
            for (i = 0; i < this.tools.size(); ++i) {
                tool = this.tools.tool(i);
                if (this.compTools.hasTool(tool)) continue;
                this.msg("  " + tool);
            }
            throw new Xcept("Not all tools sequenced in " + this.label);
        }
        pcalc.append(this.mcalc);
    }

    public void buildDeep() throws Xcept {
        this.msg("buildDeep(" + this.domctl + ") " + this.label + " rels=" + this.known.relationStr());
        if (!this.domctl.calculable(this.known)) {
            this.msg("  domctl not calculable");
            return;
        }
        ++this.nest;
        boolean working0 = true;
        while (working0) {
            boolean allseq = false;
            ToolSet badtools = new ToolSet(this.plan.box);
            PlanSeq pseq = null;
            while (!allseq) {
                pseq = new PlanSeq(this);
                pseq.tools = new Tool.List(this.tools.size());
                for (int i = 0; i < this.tools.size(); ++i) {
                    Tool tool = this.tools.tool(i);
                    if (badtools.hasTool(tool)) continue;
                    pseq.tools.add(tool);
                    tool.posit(pseq);
                }
                boolean working1 = true;
                while (working1) {
                    int ct = pseq.mcalc.size();
                    pseq.buildFlat();
                    for (int i = 0; i < this.domctlList.size(); ++i) {
                        DomCtl dctl = this.domctlList.domctl(i);
                        if (!dctl.refines(this.domctl)) continue;
                        pseq.buildNest(dctl);
                    }
                    working1 = pseq.mcalc.size() > ct;
                }
                ToolSet set = new ToolSet(this.plan.box);
                set.add(pseq.tools);
                set.sub(pseq.compTools);
                set.sub(pseq.auxTools);
                badtools.add(set);
                allseq = set.size() == 0;
            }
            boolean bl = working0 = pseq.mcalc.size() > this.mcalc.size();
            if (working0) {
                this.msg("append " + this.domctl);
                ToolSet nset = new ToolSet(pseq.compTools);
                nset.sub(this.compTools);
                this.msg(1, nset);
            }
            this.known = pseq.known.flatCopy();
            this.compTools.add(pseq.compTools);
            this.auxTools.add(pseq.auxTools);
            this.mcalc.append(pseq.mcalc);
        }
        --this.nest;
    }

    public ToolSet unusedTools() throws Xcept {
        ToolSet set = new ToolSet(this.plan.box);
        set.add(this.tools);
        set.sub(this.compTools);
        return set;
    }

    private void buildNest(DomCtl dctl) throws Xcept {
        Domain x;
        int i;
        MultiCalc mcalcSave = this.mcalc;
        DomCtl domctlSave = this.domctl;
        Expr.List relations = new Expr.List(1);
        Calc ncalc = this.mcalc = new MultiCalc(1);
        for (i = this.domctl.size() - 1; i >= 0; --i) {
            x = this.domctl.domain(i);
            if (this.domctl.sameStat(dctl, x)) continue;
            if (!this.domctl.isFree(x)) {
                throw new Xcept("buildNest() isFree error");
            }
            if (!dctl.isLoop(x)) continue;
            ncalc = new LoopCalc(x, ncalc);
        }
        for (i = 0; i < this.domctl.size(); ++i) {
            x = this.domctl.domain(i);
            if (this.domctl.sameStat(dctl, x)) continue;
            if (!this.domctl.isFree(x)) {
                throw new Xcept("buildNest() isFree error");
            }
            if (dctl.isLHBC(x)) {
                relations.add((Object)x.lhbExpr());
                ncalc = new SetCalc(x, true, ncalc);
                continue;
            }
            if (!dctl.isRHBC(x)) continue;
            relations.add((Object)x.rhbExpr());
            ncalc = new SetCalc(x, false, ncalc);
        }
        if (ncalc == this.mcalc) {
            throw new Xcept("buildNest() identical domctl error");
        }
        for (i = 0; i < relations.size(); ++i) {
            this.known.addRelation(relations.expr(i));
        }
        this.domctl = dctl;
        this.buildDeep();
        if (!this.mcalc.isEmpty()) {
            mcalcSave.add(ncalc);
        }
        for (i = 0; i < relations.size(); ++i) {
            this.known.subRelation(relations.expr(i));
        }
        this.domctl = domctlSave;
        this.mcalc = mcalcSave;
    }

    private void buildFlat() throws Xcept {
        this.msg("buildFlat(" + this.domctl + ") " + this.label + " rels=" + this.known.relationStr());
        ++this.nest;
        boolean working = true;
        while (working) {
            int i;
            working = false;
            Tool.List semiTools = new Tool.List(1);
            Tool.List postTools = new Tool.List(1);
            for (i = 0; i < this.tools.size(); ++i) {
                Tool tool = this.tools.tool(i);
                if (this.compTools.hasTool(tool)) continue;
                if (!this.domctl.sameAs(this.domctl(tool))) {
                    if (!(tool instanceof ExprTool) || !this.domctl.subsetOf(this.domctl(tool))) continue;
                    semiTools.add(tool);
                    continue;
                }
                try {
                    tool.sequencable(this.known);
                }
                catch (SequenceXcept e) {
                    this.msg("tool postponed: " + tool);
                    this.msg(1, e.toString());
                    postTools.add(tool);
                    continue;
                }
                this.msg("tool scheduled: " + tool);
                tool.addCalc(this);
                this.knownUpdate(tool);
                this.compTools.add(tool);
                working = true;
            }
            if (working) continue;
            for (i = 0; i < postTools.size(); ++i) {
                working = this.buildSemi(postTools.tool(i), semiTools);
                if (!working) continue;
            }
        }
        --this.nest;
    }

    private boolean buildSemi(Tool target, Tool.List semiTools) throws Xcept {
        if (semiTools.size() == 0) {
            return false;
        }
        Tool.List used = new Tool.List(semiTools.size());
        Var.List vreq = new Var.List(1);
        vreq.addUniq(target.vreq);
        boolean working = true;
        while (working) {
            working = false;
            for (int i = 0; i < semiTools.size(); ++i) {
                Tool tool = semiTools.tool(i);
                if (used.contains(tool)) continue;
                boolean add = false;
                for (int j = 0; j < vreq.size(); ++j) {
                    Var v = vreq.var(j);
                    if (!tool.vsol.contains((Object)v)) continue;
                    add = true;
                    break;
                }
                if (!add) continue;
                used.add(tool);
                vreq.addUniq(tool.vreq);
                working = true;
            }
        }
        if (used.size() == 0) {
            return false;
        }
        this.msg("semiseq attempt for " + target + " :: " + used);
        used.add(target);
        PlanSeq pseq = new PlanSeq(this, used);
        pseq.buildSemi1(target);
        if (!pseq.compTools.hasTool(target)) {
            this.msg("semiseq failed for " + target);
            return false;
        }
        this.msg("semiseq success for " + target);
        this.known = pseq.known.flatCopy();
        this.compTools.add(pseq.compTools);
        this.auxTools.add(pseq.auxTools);
        this.msg(1, pseq.auxTools);
        this.msg(1, pseq.compTools);
        this.mcalc.append(pseq.mcalc);
        return true;
    }

    private void buildSemi1(Tool target) throws Xcept {
        ++this.nest;
        boolean working = true;
        while (working) {
            working = false;
            for (int i = 0; i < this.tools.size(); ++i) {
                Tool tool = this.tools.tool(i);
                if (this.compTools.hasTool(tool) || this.auxTools.hasTool(tool)) continue;
                try {
                    tool.sequencable(this.known);
                }
                catch (SequenceXcept e) {
                    this.msg("tool postponed: " + tool);
                    this.msg(1, e.toString());
                    continue;
                }
                this.msg("tool scheduled: " + tool);
                tool.addCalc(this);
                this.knownUpdate(tool);
                if (tool == target) {
                    this.compTools.add(tool);
                } else {
                    this.auxTools.add(tool);
                }
                working = true;
            }
        }
        --this.nest;
    }

    private DomCtl domctl(Tool tool) throws Xcept {
        DomCtl tctl = new DomCtl(tool.domctl());
        for (int i = 0; i < tctl.size(); ++i) {
            Domain x = tctl.domain(i);
            if (tctl.isLHBC(x) || tctl.isRHBC(x)) continue;
            if (this.domctlTop.isLHBC(x)) {
                tctl.setLHBC(x);
            }
            if (!this.domctlTop.isRHBC(x)) continue;
            tctl.setRHBC(x);
        }
        return tctl;
    }

    private void knownUpdate(Tool tool) throws Xcept {
        Domain.List fdom = tool.freeDomains();
        for (int i = 0; i < tool.vsol.size(); ++i) {
            Var v = tool.vsol.var(i);
            boolean allEntire = true;
            TypedSet[] vsets = new TypedSet[v.ndim()];
            for (int j = 0; j < v.ndim(); ++j) {
                Domain x = v.domain(j);
                vsets[j] = this.domctl.getSet(x);
                if (fdom.contains((Object)x)) {
                    vsets[j] = Expr.entire;
                }
                if (vsets[j] instanceof EntireSet) continue;
                allEntire = false;
            }
            Object vset = null;
            vset = allEntire ? Expr.entire : (v.ndim() == 1 ? vsets[0] : new CrossSet(vsets));
            TypedSet oset = this.known.getSet((NamedExpr)v);
            TypedSet nset = (TypedSet)oset.union(vset).simplify(this.known);
            this.known.setSet((NamedExpr)v, nset);
        }
    }

    protected void msg(String s) {
        this.msg(0, s);
    }

    protected void msg(int ct, String s) {
        String indent = "\t";
        for (int i = 1; i < this.nest + ct; ++i) {
            indent = indent + "  ";
        }
        Util.verbose((String)(indent + s));
    }

    protected void msg(int ct, Tool.List list) {
        for (int i = 0; i < list.size(); ++i) {
            Tool tool = list.tool(i);
            this.msg(ct, tool.toString());
        }
    }

    protected void msg(int ct, ToolSet set) {
        this.msg(ct, set.toolList());
    }
}

