/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.plan1.Tool;
import JSim.plan1.ToolBox;

public class ToolSet {
    public ToolBox box;
    public boolean[] hasTool;
    public int size;

    public ToolSet(ToolBox b) {
        this.box = b;
        this.hasTool = new boolean[this.box.size()];
        this.size = 0;
    }

    public ToolSet(ToolSet v) {
        this.box = v.box;
        this.hasTool = (boolean[])v.hasTool.clone();
        this.size = v.size;
    }

    public void resize(int sz) {
        if (sz <= this.hasTool.length) {
            return;
        }
        boolean[] nhasTool = new boolean[sz];
        for (int j = 0; j < this.hasTool.length; ++j) {
            nhasTool[j] = this.hasTool[j];
        }
        this.hasTool = nhasTool;
    }

    public void add(Tool v) {
        int i = v.inx;
        if (i > this.hasTool.length) {
            this.resize(i + 1);
        }
        if (this.hasTool[i]) {
            return;
        }
        ++this.size;
        this.hasTool[i] = true;
    }

    public void sub(Tool v) {
        int i = v.inx;
        if (i > this.hasTool.length) {
            return;
        }
        if (!this.hasTool[i]) {
            return;
        }
        --this.size;
        this.hasTool[i] = false;
    }

    public void sub(ToolSet set) {
        for (int i = 0; i < set.hasTool.length; ++i) {
            if (!set.hasTool[i] || i >= this.hasTool.length || !this.hasTool[i]) continue;
            this.hasTool[i] = false;
            --this.size;
        }
    }

    public void add(ToolSet v) {
        this.resize(v.hasTool.length);
        for (int i = 0; i < this.hasTool.length; ++i) {
            if (!v.hasTool[i] || this.hasTool[i]) continue;
            ++this.size;
            this.hasTool[i] = true;
        }
    }

    public void add(Tool.List vlist) {
        for (int i = 0; i < vlist.size(); ++i) {
            this.add((Tool)vlist.get(i));
        }
    }

    public boolean hasTool(int inx) {
        return inx >= this.hasTool.length ? false : this.hasTool[inx];
    }

    public boolean hasTool(Tool v) {
        return this.hasTool(v.inx);
    }

    public boolean hasTools(Tool.List vlist) {
        for (int i = 0; i < vlist.size(); ++i) {
            Tool v = (Tool)vlist.get(i);
            if (this.hasTool(v)) continue;
            return false;
        }
        return true;
    }

    public boolean hasTools(ToolSet vset) {
        for (int i = 0; i < vset.hasTool.length; ++i) {
            if (!vset.hasTool(i) || this.hasTool(i)) continue;
            return false;
        }
        return true;
    }

    public int subct(ToolSet v) {
        this.resize(v.hasTool.length);
        int ct = 0;
        for (int i = 0; i < this.hasTool.length; ++i) {
            if (!this.hasTool[i] || v.hasTool[i]) continue;
            ++ct;
        }
        return ct;
    }

    public int size() {
        return this.size;
    }

    public int ct() {
        return this.hasTool.length;
    }

    public Tool.List toolList() {
        Tool.List list = new Tool.List(this.size());
        for (int i = 0; i < this.hasTool.length; ++i) {
            if (!this.hasTool[i]) continue;
            list.add(this.box.tool(i));
        }
        return list;
    }

    public String toString() {
        return this.toolList().toString();
    }
}

