/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mathml.MLWriter;
import JSim.mml.ChoiceNVar;
import JSim.mml.CompContext;
import JSim.mml.CompProp;
import JSim.mml.Domain;
import JSim.mml.Eqn;
import JSim.mml.Event;
import JSim.mml.MathSys;
import JSim.mml.Model;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.plan1.DEConTool;
import JSim.plan1.DETool;
import JSim.plan1.DomainTool;
import JSim.plan1.ExprTool;
import JSim.plan1.FzeroTool;
import JSim.plan1.Plan;
import JSim.plan1.Tool;
import JSim.plan1.ToolBox;
import JSim.util.Context;
import JSim.util.Expr;
import JSim.util.JSLang;
import JSim.util.StringList;
import JSim.util.Unit;
import JSim.util.Util;
import JSim.util.UtilXML;
import JSim.util.XFuncCall;
import JSim.util.Xcept;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMMLOutput {
    private boolean debug = true;
    private Document doc = UtilXML.createDoc((String)"xmml");
    private Model model;
    private MathSys math;
    private ToolBox box;
    private Context ctxt;

    public XMMLOutput(Plan plan) throws Xcept {
        this.model = plan.model;
        this.math = plan.math;
        this.box = plan.box();
        this.ctxt = new CompContext(JSLang.lang, this.math);
        Element root = this.doc.getDocumentElement();
        root.setAttribute("version", "preliminary_" + Util.version());
        this.addUnits(root);
        this.addVars(root);
        Element list = this.addElement(root, "constraintList");
        this.addInherentConstraints(list);
        this.addDerivedConstraints(list);
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public Document getDocument() {
        return this.doc;
    }

    private void addUnits(Element root) throws Xcept {
        int j;
        Unit u;
        int i;
        Element list = this.addElement(root, "unitList");
        StringList funds = this.model.units.fund;
        for (int i2 = 0; i2 < funds.size(); ++i2) {
            Element ue = this.addElement(list, "unit");
            this.setID(ue, funds.str(i2));
            ue.setAttribute("isFundamental", "true");
        }
        ArrayList<Unit> derivs = new ArrayList<Unit>();
        for (i = 0; i < this.math.nVar(); ++i) {
            u = this.math.var(i).unit();
            if (u == null || funds.containSame(u.name())) continue;
            boolean found = false;
            for (j = 0; j < derivs.size(); ++j) {
                if (!((Unit)derivs.get(j)).name().equals(u.name())) continue;
                found = true;
            }
            if (found) continue;
            derivs.add(u);
        }
        for (i = 0; i < derivs.size(); ++i) {
            u = (Unit)derivs.get(i);
            Element ue = this.addElement(list, "unit");
            this.setID(ue, u);
            if (u.f != 1.0) {
                Element e = this.addElement(ue, "realFactor");
                e.setAttribute("multiplier", Util.pretty((double)u.f));
            }
            for (j = 0; j < u.dim.length; ++j) {
                if (u.dim[j] == 0.0) continue;
                Element e = this.addElement(ue, "unitFactor");
                this.setID(e, funds.str(j));
                e.setAttribute("exponent", Util.pretty((double)u.dim[j]));
            }
        }
    }

    private void addVars(Element root) throws Xcept {
        Element list = this.addElement(root, "variableList");
        for (int i = 0; i < this.math.nVar(); ++i) {
            Unit u;
            Var v = this.math.var(i);
            Element ve = this.addElement(list, "variable");
            this.setID(ve, (Object)v);
            String dataType = "real";
            if (v.isInt()) {
                dataType = "int";
            }
            if (v instanceof ChoiceNVar) {
                dataType = "choice";
            }
            ve.setAttribute("dataType", dataType);
            if (v.isDomain()) {
                ve.setAttribute("isDomain", "true");
            }
            if ((u = v.unit()) != null) {
                Element ue = this.addElement(ve, "unit");
                this.setID(ue, u);
            }
            for (int j = 0; j < v.ndim(); ++j) {
                Element xe = this.addElement(ve, "domain");
                this.setID(xe, (Object)v.domain(j));
            }
            this.addVarProps(v, ve);
        }
    }

    private void addVarProps(Var v, Element ve) throws Xcept {
        for (int j = 0; j < v.props.size(); ++j) {
            CompProp prop = v.props.prop(j);
            String value = prop.stringVal(this.ctxt);
            if (Util.isBlank((String)value)) continue;
            Element pe = this.doc.createElement("property");
            ve.appendChild(pe);
            pe.setAttribute("name", prop.name());
            String dataType = null;
            switch (prop.dataType()) {
                case 2: {
                    dataType = "boolean";
                    break;
                }
                case 4: {
                    dataType = "real";
                    break;
                }
                case 8: {
                    dataType = "string";
                }
            }
            if (dataType != null) {
                pe.setAttribute("dataType", dataType);
            }
            Text ptxt = this.doc.createTextNode(value);
            pe.appendChild(ptxt);
        }
    }

    private void addInherentConstraints(Element list) throws Xcept {
        int i;
        for (i = 0; i < this.math.nVar(); ++i) {
            Var v = this.math.var(i);
            if (v.isExtern()) {
                this.makeCons(list, "externConstraint", v);
            }
            if (!v.isState()) continue;
            this.makeCons(list, "discreteConstraint", v);
        }
        for (i = 0; i < this.math.eqn.size(); ++i) {
            this.makeCons(list, this.math.eqn.eqn(i));
        }
        for (i = 0; i < this.math.events.size(); ++i) {
            this.makeCons(list, this.math.events.event(i));
        }
        for (i = 0; i < this.math.voidFuncCalls.size(); ++i) {
            this.makeCons(list, this.math.voidFuncCalls.expr(i));
        }
    }

    private void makeCons(Element list, String name, Var v) throws Xcept {
        Element ce = this.addElement(list, name, v);
        this.setID(ce, "_" + this.id((Object)v));
        this.setInherent(ce, true);
        this.addVarList(ce, "outputVariableList", new Var.List((Expr)v));
    }

    private void makeCons(Element list, Eqn eqn) throws Xcept {
        Element ce = this.addElement(list, eqn.isEqn() ? "equationConstraint" : "relationConstraint");
        this.setID(ce, eqn);
        this.setInherent(ce, true);
        this.addWhen(ce, eqn.subdom());
        this.addMath(ce, "expression", eqn.expr());
        this.addVarList(ce, "inputVariableList", eqn.varList());
        this.addDebug(ce, eqn.toString());
    }

    private void makeCons(Element list, Event event) throws Xcept {
        Element ce = this.addElement(list, "eventConstraint");
        this.setID(ce, event);
        this.setInherent(ce, true);
        Element de = this.addElement(ce, "domain");
        this.setID(de, (Object)event.t());
        Element te = this.addMath(ce, "trigger", event.trigger());
        te.setAttribute("type", "absolute");
        this.addDebug(te, event.trigger().toString());
        Element aes = this.addElement(ce, "actionList");
        Var.List invars = new Var.List(4);
        event.trigger().addNamedExpr((Expr.List)invars);
        for (int i = 0; i < event.nactions(); ++i) {
            Element ae = this.addElement(aes, "action");
            Element av = this.addElement(ae, "variable");
            this.setID(av, (Object)event.v(i));
            this.addMath(ae, "expression", event.vexpr(i));
            event.vexpr(i).addNamedExpr((Expr.List)invars);
            this.addDebug(ae, "" + (Object)((Object)event.v(i)) + "=" + event.vexpr(i));
        }
        this.addVarList(ce, "inputVariableList", invars);
        this.addVarList(ce, "outputVariableList", event.vstate());
    }

    private void makeCons(Element list, Expr xcall) throws Xcept {
        Element ce = this.addElement(list, "procedureCallConstraint");
        this.setID(ce, xcall);
        this.setInherent(ce, true);
        this.addDebug(ce, xcall.toString());
    }

    private void addDerivedConstraints(Element list) throws Xcept {
        for (int i = 0; i < this.box.size(); ++i) {
            Tool tool = this.box.tool(i);
            String id = "tool_" + i;
            Element ce = null;
            if (tool instanceof ExprTool) {
                ce = this.makeCons((ExprTool)tool);
            } else if (tool instanceof DomainTool) {
                ce = this.makeCons((DomainTool)tool);
            } else if (tool instanceof FzeroTool) {
                ce = this.makeCons((FzeroTool)tool);
            } else if (tool instanceof DETool) {
                ce = this.makeCons((DETool)tool);
            }
            if (ce == null) continue;
            list.appendChild(ce);
            this.setID(ce, tool);
            this.setInherent(ce, false);
            this.addVarList(ce, "inputVariableList", tool.vreq());
            this.addVarList(ce, "outputVariableList", tool.vsol());
            this.addDebug(ce, tool.toString());
        }
    }

    private Element makeCons(DomainTool tool) throws Xcept {
        return this.doc.createElement("domainConstraint");
    }

    private Element makeCons(ExprTool tool) throws Xcept {
        Element ce = this.doc.createElement("assignmentConstraint");
        this.addMath(ce, "assignment", tool.expr);
        return ce;
    }

    private Element makeCons(FzeroTool tool) throws Xcept {
        Element ce = this.doc.createElement("implicitConstraint");
        Element es = this.addElement(ce, "equationList");
        for (int i = 0; i < tool.exprs.size(); ++i) {
            Expr expr = tool.exprs.expr(i);
            expr = expr.eq((Expr)Expr.zero);
            this.addMath(es, "equation", expr);
        }
        return ce;
    }

    private Element makeCons(DETool tool) throws Xcept {
        Element re;
        boolean isODE = tool.isODE();
        Element ce = this.doc.createElement((isODE ? "ode" : "pde") + "Constraint");
        ce.setAttribute("order", isODE ? "1" : "2");
        Element te = this.addElement(ce, "timeDomain");
        this.setID(te, (Object)tool.t());
        this.addDECon(ce, "stateEquation", tool.state());
        Tool ictool = tool.ictool;
        if (ictool != null) {
            Element ice = this.addElement(ce, "initialCondition");
            ice.setAttribute("domain", this.id((Object)tool.t()));
            this.setID(ice, ictool);
            this.addDebug(ice, ictool.toString());
        }
        if (isODE) {
            return ce;
        }
        Element xe = this.addElement(ce, "spatialDomain");
        this.setID(xe, (Object)tool.x());
        Element le = this.addDECon(ce, "boundaryCondition", tool.lhbc((Domain)tool.x()));
        String xid = this.id((Object)tool.x());
        if (le != null) {
            le.setAttribute("type", "leftHand");
            le.setAttribute("domain", xid);
        }
        if ((re = this.addDECon(ce, "boundaryCondition", tool.rhbc((Domain)tool.x()))) != null) {
            re.setAttribute("type", "rightHand");
            re.setAttribute("domain", xid);
        }
        return ce;
    }

    private Element addDECon(Element base, String name, DEConTool tool) throws Xcept {
        if (tool == null) {
            return null;
        }
        Element ce = this.addElement(base, name);
        Object ref = tool.tool;
        if (ref == null) {
            ref = tool.eqn;
        }
        this.setID(ce, ref);
        this.addDebug(ce, tool.toString());
        return ce;
    }

    private String id(Object o) throws Xcept {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Unit) {
            return ((Unit)o).pubName();
        }
        if (o instanceof Var) {
            return ((Var)((Object)o)).toString();
        }
        if (o instanceof Eqn) {
            return "eqn_" + ((Eqn)o).flatInx();
        }
        if (o instanceof Event) {
            return "event_" + o.hashCode();
        }
        if (o instanceof XFuncCall) {
            return "proc_" + o.hashCode();
        }
        if (o instanceof Tool) {
            return "tool_" + ((Tool)o).inx;
        }
        throw new Xcept("No id defined for class " + (o == null ? "null" : o.getClass().getName()));
    }

    private void setID(Element e, Object o) throws Xcept {
        e.setAttribute("id", this.id(o));
    }

    private Element addElement(Element base, String name, Var v) {
        Element e = this.addElement(base, name);
        e.setAttribute("variable", v.toString());
        return e;
    }

    private Element addElement(Element base, String name) {
        Element e = this.doc.createElement(name);
        base.appendChild(e);
        return e;
    }

    private void setInherent(Element e, boolean b) {
        e.setAttribute("isInherent", "" + b);
    }

    private void addWhen(Element e, Expr expr) throws Xcept {
        SubDom sd = new SubDom(expr);
        if (sd.isEntire()) {
            return;
        }
        Element we = this.addElement(e, "when");
        Domain x = sd.bcDomain();
        if (x == null) {
            this.addMath(we, "expression", expr);
        } else {
            we.setAttribute("domain", x.toString());
            we.setAttribute("boundary", sd.isLHBC() ? "left" : "right");
        }
    }

    private Element addMath(Element base, String name, Expr expr) throws Xcept {
        Element ne = this.doc.createElement(name);
        base.appendChild(ne);
        ne.setAttribute("unitConversionFactorsIncluded", "true");
        MLWriter math = new MLWriter(ne);
        math.add(expr);
        return ne;
    }

    private void addDebug(Element base, String s) {
        if (!this.debug) {
            return;
        }
        Element de = this.addElement(base, "debug");
        Text txt = this.doc.createTextNode(s);
        de.appendChild(txt);
    }

    private void addVarList(Element elem, String listName, Var.List vs) throws Xcept {
        if (vs.size() == 0) {
            return;
        }
        Element le = this.doc.createElement(listName);
        elem.appendChild(le);
        for (int i = 0; i < vs.size(); ++i) {
            Var v = vs.var(i);
            Element ve = this.doc.createElement("variable");
            le.appendChild(ve);
            this.setID(ve, (Object)v);
        }
    }
}

