/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml;

import JSim.sbml.SBCompartment;
import JSim.sbml.SBModel;
import JSim.sbml.SBVar;
import JSim.util.DiagInfo;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.util.List;
import jigcell.sbml2.Species;

public class SBSpecies
implements Named {
    protected SBModel sbmodel;
    protected Species spec;
    protected boolean initIsAmt;
    protected boolean quantIsAmt;
    protected String sunits;
    protected String cunits;
    protected SBVar vinit;
    protected SBVar vquant;
    protected SBVar vamt;
    protected SBVar vconc;

    public SBSpecies(SBModel sm, Species s) throws Xcept {
        double ival;
        this.sbmodel = sm;
        this.spec = s;
        this.sunits = this.spec.getSubstanceUnits();
        this.cunits = this.sunits + "/" + this.sbcomp().unit();
        this.quantIsAmt = this.spec.getHasOnlySubstanceUnits();
        if (this.sbcomp().spatialDimensions() == 0) {
            this.quantIsAmt = true;
        }
        boolean initIsAmt = !Double.isNaN(this.spec.getInitialAmount()) ? true : (!Double.isNaN(this.spec.getInitialConcentration()) ? false : this.quantIsAmt);
        String vamtName = this.name();
        String vconcName = this.name();
        if (this.quantIsAmt) {
            vconcName = vconcName + ".conc";
        } else {
            vamtName = vamtName + ".amt";
        }
        this.vamt = new SBVar(this.sbmodel, vamtName, "speciesAmount");
        this.vamt.setUnit(this.sunits);
        this.vamt.setConst(this.spec.isConstant());
        this.vamt.setBC(this.spec.isBoundaryCondition());
        this.vamt.setPrivate(!this.quantIsAmt);
        this.vconc = new SBVar(this.sbmodel, vconcName, "speciesConcentration");
        this.vconc.setUnit(this.cunits);
        this.vconc.setConst(this.spec.isConstant());
        this.vconc.setBC(this.spec.isBoundaryCondition());
        this.vconc.setPrivate(this.quantIsAmt);
        this.vquant = this.quantIsAmt ? this.vamt : this.vconc;
        this.vquant.setSBMLName(this.spec);
        this.vquant.compartment = this.spec.getCompartment();
        this.vinit = new SBVar(this.sbmodel, this.vquant.mmlName + ".init", "speciesInitial" + (initIsAmt ? "Amount" : "Concentration"));
        this.vinit.setUnit(initIsAmt ? this.sunits : this.cunits);
        this.vinit.setConst(true);
        double d = ival = initIsAmt ? this.spec.getInitialAmount() : this.spec.getInitialConcentration();
        if (Double.isNaN(ival)) {
            this.vinit.setExtern();
        } else {
            this.vinit.setAssign(Util.pretty((double)ival));
        }
    }

    public String toString() {
        return this.diagInfo();
    }

    public String name() {
        return this.spec.getId();
    }

    public String diagInfo() {
        return "Species " + this.name();
    }

    public SBCompartment sbcomp() throws Xcept {
        String cname = this.spec.getCompartment();
        SBCompartment sbcomp = this.sbmodel.sbcomps.sbcomp(cname);
        if (sbcomp == null) {
            throw new Xcept("Species " + this.name() + " compartment " + cname + " not found");
        }
        return sbcomp;
    }

    public void setCalc() throws Xcept {
        if (this.vamt.isSolved() && this.vconc.isSolved()) {
            throw new Xcept((DiagInfo)this, "Both amt and conc are constrained");
        }
        String compNameMML = this.sbcomp().v.mmlName;
        SBVar vmast = null;
        if (this.vamt.isSolved()) {
            vmast = this.vamt;
        }
        if (this.vconc.isSolved()) {
            vmast = this.vconc;
        }
        if (vmast == null) {
            vmast = this.vquant;
        }
        if (vmast.isODE() || !this.vinit.isExtern()) {
            String icexpr = this.vinit.mmlName;
            if (!this.vinit.unit.equals(vmast.unit)) {
                icexpr = icexpr + (this.vinit.unit == this.sunits ? "/" : "*") + compNameMML;
            }
            vmast.setInitValue(icexpr);
        } else {
            this.vinit.setPrivate(true);
        }
        SBVar vslave = vmast == this.vamt ? this.vconc : this.vamt;
        String sexpr = vslave == this.vamt ? vmast.mmlName + "*" + compNameMML : vmast.mmlName + "/" + compNameMML;
        vslave.setAssign(sexpr);
    }

    public void writeMML(PrintWriter wrt) {
    }

    public void writeMML2(PrintWriter wrt) {
    }

    public static class NList
    extends NamedList {
        public NList(SBModel sbm) throws Xcept {
            List list = sbm.model.getSpecies();
            for (int i = 0; i < list.size(); ++i) {
                this.add(new SBSpecies(sbm, (Species)list.get(i)));
            }
        }

        public NList() {
        }

        public SBSpecies sbspec(int i) {
            return (SBSpecies)this.get(i);
        }

        public SBSpecies sbspec(String n) {
            return (SBSpecies)this.getByName(n);
        }
    }
}

