/*
 * Decompiled with CFR 0.152.
 */
package JSim.sbml;

import JSim.mml.MMLUtil;
import JSim.sbml.SBModel;
import JSim.util.DiagInfo;
import JSim.util.Named;
import JSim.util.NamedList;
import JSim.util.Util;
import JSim.util.Xcept;
import java.io.PrintWriter;
import jigcell.sbml2.SBaseId;

public class SBVar
implements Named {
    protected SBModel sbmodel;
    protected String name;
    protected boolean strippedLeadingUnderscore;
    protected String mmlName;
    protected String role;
    protected String sbmlName;
    protected String compartment;
    protected String unit;
    protected boolean isConst;
    protected boolean isPrivate;
    protected boolean isBC;
    protected String initValue;
    protected boolean initNum;
    protected String alg;
    protected String ode;
    protected String deltas;
    private int calc;
    private static final int UNKNOWN = 0;
    private static final int EXTERN = 1;
    private static final int VALUE = 2;
    private static final int ODE = 3;
    private static final int EVENT = 4;
    private static final int ASSIGN = 5;
    private static final int IMPLICIT = 6;

    public SBVar(SBModel sm, String n, String role) throws Xcept {
        this.sbmodel = sm;
        this.name = n;
        this.mmlName = this.safeMMLName(this.name);
        this.unit = null;
        this.role = role;
        this.isConst = false;
        this.isPrivate = false;
        this.calc = 0;
        this.initValue = null;
        this.sbmodel.sbvars.add(this);
    }

    private String safeMMLName(String name) {
        String safe = name;
        if (!Character.isLetter(name.charAt(0))) {
            safe = "xxx" + name;
        } else if (name.length() > 1 && name.substring(0, 2).equalsIgnoreCase("js")) {
            safe = "" + name.charAt(0) + "_" + name.substring(1);
        } else if (MMLUtil.reservedWords.contains(name)) {
            safe = name + "_";
        }
        return safe;
    }

    public void setUnit(String u) {
        this.unit = u;
    }

    public void setInitValue(double d) {
        this.initNum = true;
        this.initValue = Double.isNaN(d) ? null : Util.pretty((double)d);
    }

    public void setInitValue(String s) {
        this.initNum = false;
        this.initValue = s;
    }

    public void setConst(boolean b) {
        this.isConst = b;
    }

    public void setBC(boolean b) {
        this.isBC = b;
    }

    public void setSBMLName(SBaseId sid) {
        this.sbmlName = sid.getName();
    }

    public void setExtern() {
        this.calc = 1;
    }

    public void setAssign(String e) throws Xcept {
        if (this.alg != null) {
            throw new Xcept((DiagInfo)this, "Multiple algebraic assigns not supported " + this);
        }
        this.alg = e;
    }

    public void setODE(String e) throws Xcept {
        if (this.ode != null) {
            throw new Xcept((DiagInfo)this, "Multiple ODE assigns not supported");
        }
        this.ode = e;
    }

    public void addODEDelta(String s) {
        if (this.isBC) {
            return;
        }
        this.deltas = this.deltas == null ? s : this.deltas + " + " + s;
    }

    public void setPrivate(boolean b) {
        this.isPrivate = b;
    }

    public boolean isExtern() {
        return this.calc == 1;
    }

    public boolean isSolved() {
        if (this.calc != 0) {
            return true;
        }
        if (this.alg != null) {
            return true;
        }
        if (this.ode != null) {
            return true;
        }
        return this.deltas != null;
    }

    public boolean isODE() {
        if (this.calc == 3) {
            return true;
        }
        if (this.calc != 0) {
            return false;
        }
        if (this.ode != null) {
            return true;
        }
        return this.deltas != null;
    }

    public void setCalc() throws Xcept {
        if (this.calc != 0) {
            return;
        }
        int ct = 0;
        String s = "";
        if (this.alg != null) {
            this.calc = 5;
            ++ct;
            s = s + " " + this.name + "=" + this.alg + ";";
        }
        if (this.ode != null) {
            this.calc = 3;
            ++ct;
            s = s + " " + this.name + ":time=" + this.ode + ";";
        }
        if (this.deltas != null) {
            this.calc = 3;
            ++ct;
            s = s + " " + this.name + ":time=" + this.deltas + ";";
        }
        if (this.calc == 3 && this.initValue == null) {
            this.initValue = "0";
        }
        if (ct > 1) {
            throw new Xcept((DiagInfo)this, "Multiple calculation methods not supported:" + s);
        }
        if (this.calc != 0) {
            return;
        }
        this.calc = this.initValue == null ? 1 : 2;
        this.isConst = true;
    }

    public void writeRenameWarning(PrintWriter wrt) {
        String orig = this.name;
        if (this.strippedLeadingUnderscore) {
            orig = "_" + this.name;
        }
        if (orig.equals(this.mmlName)) {
            return;
        }
        wrt.println("// WARNING: Renamed variable " + orig + " to " + this.mmlName + " due to JSim namespace restrictions");
    }

    public void writeMMLDecl(PrintWriter wrt) {
        if (this.isPrivate && this.isExtern()) {
            return;
        }
        String domain = this.isConst ? "" : "(time)";
        String decl = "real " + this.mmlName + domain;
        if (this.isPrivate) {
            decl = "private " + decl;
        }
        String svalue = " = " + this.initValue;
        String sunit = this.unit == null ? ";" : " " + this.unit + ";";
        switch (this.calc) {
            case 1: {
                wrt.println("  extern " + decl + sunit);
                break;
            }
            case 2: {
                if (this.initNum) {
                    wrt.println("  " + decl + svalue + sunit);
                    break;
                }
                wrt.println("  " + decl + sunit);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                wrt.println("  " + decl + sunit);
                break;
            }
            default: {
                wrt.println("//" + this.name + " UNKNOWN CALCULATION");
            }
        }
    }

    public void writeMMLEqn(PrintWriter wrt) {
        switch (this.calc) {
            case 2: {
                if (this.initNum) break;
                wrt.println("  " + this.mmlName + " = " + this.initValue + ";");
                break;
            }
            case 3: {
                wrt.println("  when (time=time.min) " + this.mmlName + " = " + this.initValue + ";");
                String expr = this.ode;
                if (expr == null) {
                    expr = this.deltas;
                }
                wrt.println("  " + this.mmlName + ":time = " + expr + ";");
                break;
            }
            case 5: {
                wrt.println("  " + this.mmlName + " = " + this.alg + ";");
            }
        }
    }

    protected void writeMMLProp(PrintWriter wrt) {
        if (this.isPrivate && this.isExtern()) {
            return;
        }
        if (this.role != null) {
            wrt.println("  " + this.mmlName + ".sbmlRole=\"" + this.role + "\";");
        }
        if (this.sbmlName != null && !this.sbmlName.equals(this.name)) {
            wrt.println("  " + this.mmlName + ".sbmlName=\"" + this.sbmlName + "\";");
        }
        if (this.compartment != null) {
            wrt.println("  " + this.mmlName + ".sbmlCompartment=\"" + this.compartment + "\";");
        }
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String diagInfo() {
        return "Var " + this.name();
    }

    public boolean unknown() {
        return this.calc == 0;
    }

    public static class NList
    extends NamedList {
        public SBVar sbvar(int i) {
            return (SBVar)this.get(i);
        }

        public SBVar sbvar(String n) throws Xcept {
            SBVar v = (SBVar)this.getByName(n);
            if (v == null) {
                throw new Xcept("Unknown SBML variable: " + n);
            }
            return v;
        }
    }
}

