/*
 * Decompiled with CFR 0.152.
 */
package JSim.xsim;

import JSim.data.XMLWriter;
import JSim.mml.Model;
import JSim.project.PApplication;
import JSim.project.PImage;
import JSim.project.PImageSet;
import JSim.project.PModel;
import JSim.project.PNamed;
import JSim.project.Project;
import JSim.util.StringList;
import JSim.util.Util;
import JSim.util.UtilIO;
import JSim.util.Xcept;
import JSim.xsim.CFFigure;
import JSim.xsim.CFGroup;
import JSim.xsim.CFItem;
import JSim.xsim.CFIvar;
import JSim.xsim.CFMenu;
import JSim.xsim.CFPar;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.Document;

public class CF {
    public String cfName = "unknown.cf";
    public Model unitModel;
    public String modName = "unknown";
    public String libName = "unknown";
    public int errors = 0;
    public CFItem.List items = new CFItem.List();
    public CFIvar ivar;
    public PrintWriter out;
    public PrintWriter err;
    public int maxloc;
    public CFItem.List renamedPars;
    public StringList dims;

    public void writeProj(Writer pwrt) throws Exception {
        File fmml = new File(this.modName + ".mod");
        FileWriter fwrt = new FileWriter(fmml);
        this.writeMML(fwrt);
        File frtml = new File(this.modName + ".rtml");
        fwrt = new FileWriter(frtml);
        this.writeRTML(fwrt);
        String smml = UtilIO.readText((File)fmml);
        String srtml = UtilIO.readText((File)frtml);
        PApplication pappl = new PApplication(null);
        Project proj = new Project("proj", pappl);
        PModel pmodel = new PModel((PNamed)proj, this.modName);
        pmodel.modelSource.setVal(smml);
        pmodel.built.setVal(true);
        pmodel.customRTMLText.setVal(srtml);
        pmodel.customBuilt.setVal(true);
        PImageSet imgSet = pmodel.images();
        for (int i = 0; i < this.items.size(); ++i) {
            if (!(this.items.item(i) instanceof CFFigure)) continue;
            CFFigure f = (CFFigure)this.items.item(i);
            if (imgSet.nestedChild(f.name) != null) continue;
            PImage img = new PImage((PNamed)imgSet, f.name);
            img.load(f.file);
        }
        Document doc = proj.exportXMLDoc();
        XMLWriter xwrt = new XMLWriter();
        xwrt.write(doc, pwrt);
    }

    public void writeRTML(PrintStream o) throws Xcept {
        this.writeRTML(new PrintWriter(o, true));
    }

    public void writeRTML(Writer o) throws Xcept {
        this.out = o instanceof PrintWriter ? (PrintWriter)o : new PrintWriter(o, true);
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.println("<JSim version=\"" + Util.version() + "\">");
        this.writeMenus();
        this.writeGroups(true);
        this.writeGroups(false);
        this.println("</JSim>");
    }

    public void writeMenus() throws Xcept {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!(this.items.item(i) instanceof CFMenu)) continue;
            CFMenu g = (CFMenu)this.items.item(i);
            if (!g.top) continue;
            g.writeRTML();
        }
    }

    public void writeGroups(boolean popup) throws Xcept {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!(this.items.item(i) instanceof CFGroup)) continue;
            CFGroup g = (CFGroup)this.items.item(i);
            if (g.popup != popup) continue;
            g.writeRTML();
        }
    }

    public void writeMML(PrintStream o) throws Xcept {
        this.writeMML(new PrintWriter(o, true));
    }

    public void writeMML(Writer o) throws Xcept {
        int i;
        this.out = o instanceof PrintWriter ? (PrintWriter)o : new PrintWriter(o, true);
        this.println("JSim v1.1");
        this.println("");
        this.println("// this file automatically generated by x2jsim");
        this.println("//\tfrom file " + this.cfName);
        this.println("");
        this.println("import XSim;");
        this.println("import nsrunit;");
        this.println("unit conversion off;");
        this.println("");
        this.println("XSim main {");
        this.println("\tlibrary lib(\"" + this.libName + "\");");
        this.ivar.writeMMLVar();
        for (i = 0; i < this.dims.size(); ++i) {
            String x = "x" + this.dims.str(i);
            this.println("\trealDomain " + x + "; " + x + ".min=1; " + x + ".max=" + this.dims.str(i) + "; " + x + ".delta=1;");
        }
        for (i = 0; i < this.items.size(); ++i) {
            if (this.items.item(i) == this.ivar) continue;
            this.items.item(i).writeMMLVar();
        }
        for (i = 0; i < this.items.size(); ++i) {
            this.items.item(i).writeMMLEqn();
        }
        this.println("}");
    }

    public String libName() {
        String f = this.cfName;
        int i = f.lastIndexOf(47);
        if (i > 0) {
            f = f.substring(i + 1);
        }
        if ((i = f.lastIndexOf(46)) < 0) {
            return f;
        }
        return f.substring(0, i);
    }

    public CFPar par(String n) {
        for (int i = 0; i < this.items.size(); ++i) {
            CFPar par;
            if (!(this.items.item(i) instanceof CFPar) || !n.equalsIgnoreCase((par = (CFPar)this.items.item(i)).name())) continue;
            return par;
        }
        return null;
    }

    public void println(String msg) {
        this.out.println(msg);
    }

    public void error(String msg) {
        this.err.println("Error: " + msg);
        ++this.errors;
    }

    public void warn(String msg) {
        this.err.println("Warning: " + msg);
    }
}

