/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jigcell.sbml2.Model;
import jigcell.sbml2.Reaction;
import jigcell.sbml2.Species;
import jigcell.sbml2.SpeciesReference;

public final class ConservationRelationFinder {
    private final boolean[] illegalSpecies;
    private final double[][] stoichiometryMatrix;
    private final int conservationRelationCount;
    private final List speciesIds;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static int countDependentRows(double[][] matrix, int rowCount, int columnCount) {
        for (int rowIndex = rowCount - 1; rowIndex >= 0; --rowIndex) {
            for (int reactionIndex = 0; reactionIndex < columnCount; ++reactionIndex) {
                if (matrix[rowIndex][reactionIndex] == 0.0) continue;
                return rowCount - rowIndex - 1;
            }
        }
        return rowCount;
    }

    private static void multiplyRow(double[][] matrix, int entryCount, int row1, double coefficient) {
        double[] row = matrix[row1];
        int entryIndex = 0;
        while (entryIndex < entryCount) {
            int n = entryIndex++;
            row[n] = row[n] * coefficient;
        }
    }

    private static void multiplyAndAddToRow(double[][] matrix, int entryCount, int row1, int row2, double coefficient) {
        double[] fromRow = matrix[row1];
        double[] toRow = matrix[row2];
        for (int entryIndex = 0; entryIndex < entryCount; ++entryIndex) {
            int n = entryIndex;
            toRow[n] = toRow[n] + coefficient * fromRow[entryIndex];
        }
    }

    private static void reduceMatrix(double[][] matrix, int rowCount, int columnCount, int entryCount) {
        int linkCount = Math.min(rowCount, columnCount);
        int activeRow = 0;
        for (int columnIndex = 0; columnIndex < columnCount && activeRow < linkCount; ++columnIndex) {
            int rowIndex;
            double coefficient = 0.0;
            int targetRow = -1;
            for (rowIndex = activeRow; rowIndex < rowCount; ++rowIndex) {
                coefficient = matrix[rowIndex][columnIndex];
                if (coefficient == 0.0) continue;
                targetRow = rowIndex;
                break;
            }
            if (targetRow == -1) continue;
            if (activeRow != targetRow) {
                ConservationRelationFinder.swapRows(matrix, activeRow, targetRow);
            }
            if (coefficient != 1.0) {
                ConservationRelationFinder.multiplyRow(matrix, entryCount, activeRow, 1.0 / coefficient);
            }
            for (rowIndex = activeRow + 1; rowIndex < rowCount; ++rowIndex) {
                coefficient = matrix[rowIndex][columnIndex];
                if (coefficient == 0.0) continue;
                ConservationRelationFinder.multiplyAndAddToRow(matrix, entryCount, activeRow, rowIndex, -coefficient);
            }
            ++activeRow;
        }
    }

    private static void swapRows(double[][] matrix, int row1, int row2) {
        double[] row = matrix[row1];
        matrix[row1] = matrix[row2];
        matrix[row2] = row;
    }

    public ConservationRelationFinder(Model model) {
        if (model == null) {
            throw new IllegalArgumentException("Model is null.");
        }
        List speciesList = model.getSpecies();
        if (speciesList == null) {
            throw new IllegalArgumentException("Model does not have a list of species.");
        }
        List reactions = model.getReactions();
        if (reactions == null) {
            throw new IllegalArgumentException("Model does not have a list of reactions.");
        }
        int speciesCount = speciesList.size();
        int reactionCount = reactions.size();
        int entryCount = speciesCount + reactionCount;
        this.illegalSpecies = new boolean[speciesCount];
        this.stoichiometryMatrix = new double[speciesCount][];
        this.speciesIds = new ArrayList(speciesCount);
        this.fillStoichiometryMatrix(model, speciesList, reactions, speciesCount, reactionCount, entryCount);
        ConservationRelationFinder.reduceMatrix(this.stoichiometryMatrix, speciesCount, reactionCount, entryCount);
        this.conservationRelationCount = ConservationRelationFinder.countDependentRows(this.stoichiometryMatrix, speciesCount, reactionCount);
    }

    public List getConservationRelations() {
        int rowIndex;
        ArrayList<ConservationRelation> equations = new ArrayList<ConservationRelation>();
        int speciesCount = this.stoichiometryMatrix.length;
        if (speciesCount == 0) {
            return equations;
        }
        int speciesRowIndex = this.stoichiometryMatrix[0].length - 1;
        int reactionCount = speciesRowIndex - speciesCount;
        int lastRow = rowIndex - this.conservationRelationCount;
        block0: for (rowIndex = speciesCount - 1; rowIndex > lastRow; --rowIndex) {
            double[] row = this.stoichiometryMatrix[rowIndex];
            TreeMap conservationRelation = new TreeMap();
            for (int inverseIndex = reactionCount; inverseIndex < reactionCount + speciesCount; ++inverseIndex) {
                double coefficient = row[inverseIndex];
                if (coefficient == 0.0) continue;
                int speciesIndex = inverseIndex - reactionCount;
                if (this.illegalSpecies[speciesIndex]) continue block0;
                conservationRelation.put(this.speciesIds.get(speciesIndex), new Double(coefficient));
            }
            if (conservationRelation.size() <= 1) continue;
            equations.add(new ConservationRelation(conservationRelation, (String)this.speciesIds.get((int)this.stoichiometryMatrix[rowIndex][speciesRowIndex])));
        }
        if (!$assertionsDisabled && !this.validateConservationRelations(equations)) {
            throw new AssertionError();
        }
        return equations;
    }

    public boolean validateConservationRelations(List userRelations) {
        if (userRelations == null) {
            throw new IllegalArgumentException("List of conservation relations is null.");
        }
        int userRelationCount = userRelations.size();
        if (userRelationCount > this.conservationRelationCount) {
            throw new IllegalArgumentException("Too many conservation relations.");
        }
        if (userRelationCount == 0) {
            return true;
        }
        int totalRelationCount = userRelationCount + this.conservationRelationCount;
        double[][] userSystem = new double[userRelationCount + this.conservationRelationCount][];
        int speciesCount = this.stoichiometryMatrix.length;
        HashSet<String> usedSpeciesIds = new HashSet<String>();
        for (int userRelationIndex = 0; userRelationIndex < userRelationCount; ++userRelationIndex) {
            ConservationRelation userRelation = (ConservationRelation)userRelations.get(userRelationIndex);
            String dependentSpeciesId = userRelation.dependentSpeciesId;
            if (!this.speciesIds.contains(dependentSpeciesId)) {
                throw new IllegalArgumentException("Species " + dependentSpeciesId + " is not present in the model.");
            }
            if (!usedSpeciesIds.add(dependentSpeciesId)) {
                throw new IllegalArgumentException("Species " + dependentSpeciesId + " is used as a dependent variable twice.");
            }
            double[] relationVector = new double[speciesCount];
            Iterator entryIterator = userRelation.getConservationRelation().entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                String speciesId = (String)entry.getKey();
                int speciesIndex = this.speciesIds.indexOf(speciesId);
                if (speciesIndex == -1) {
                    throw new IllegalArgumentException("Species " + speciesId + " is not present in the model.");
                }
                if (this.illegalSpecies[speciesIndex]) {
                    throw new IllegalArgumentException("Species " + speciesId + " cannot be used in a conservation relation.");
                }
                if (relationVector[speciesIndex] != 0.0) {
                    throw new IllegalArgumentException("Species " + speciesId + " is used in the conservation relation twice.");
                }
                relationVector[speciesIndex] = (Double)entry.getValue();
            }
            userSystem[userRelationIndex] = relationVector;
        }
        ConservationRelationFinder.reduceMatrix(userSystem, userRelationCount, speciesCount, speciesCount);
        if (ConservationRelationFinder.countDependentRows(userSystem, userRelationCount, speciesCount) > 0) {
            return false;
        }
        int reactionCount = this.stoichiometryMatrix[0].length - speciesCount - 1;
        for (int conservationRelationIndex = 0; conservationRelationIndex < this.conservationRelationCount; ++conservationRelationIndex) {
            double[] relationVector = new double[speciesCount];
            System.arraycopy(this.stoichiometryMatrix[speciesCount - 1 - conservationRelationIndex], reactionCount, relationVector, 0, speciesCount);
            userSystem[userRelationCount + conservationRelationIndex] = relationVector;
        }
        ConservationRelationFinder.reduceMatrix(userSystem, totalRelationCount, speciesCount, speciesCount);
        return ConservationRelationFinder.countDependentRows(userSystem, totalRelationCount, speciesCount) == userRelationCount;
    }

    private void addSpeciesStoichiometry(Model model, List modelSpecies, int reactionIndex, SpeciesReference reference, boolean positive) {
        if (reference == null) {
            throw new IllegalArgumentException(" contains an incomplete species reference.");
        }
        Species species = reference.getSpecies(model);
        if (species == null) {
            throw new IllegalArgumentException(" contains an incomplete species reference.");
        }
        if (species.isConstant() || species.isBoundaryCondition()) {
            return;
        }
        int speciesIndex = modelSpecies.indexOf(species);
        if (speciesIndex == -1) {
            throw new IllegalArgumentException(" contains species " + species.getName() + " not defined in the model.");
        }
        double stoichiometry = reference.getStoichiometry();
        if (Double.isNaN(stoichiometry)) {
            throw new IllegalArgumentException(" contains species " + species.getName() + " without fixed stoichiometry.");
        }
        double[] dArray = this.stoichiometryMatrix[speciesIndex];
        int n = reactionIndex;
        dArray[n] = dArray[n] + (positive ? stoichiometry : -stoichiometry);
    }

    private void fillStoichiometryMatrix(Model model, List speciesList, List reactions, int speciesCount, int reactionCount, int entryCount) {
        for (int speciesIndex = 0; speciesIndex < speciesCount; ++speciesIndex) {
            double[] speciesRow = new double[entryCount + 1];
            speciesRow[speciesIndex + reactionCount] = 1.0;
            speciesRow[entryCount] = speciesIndex;
            this.stoichiometryMatrix[speciesIndex] = speciesRow;
            Species species = (Species)speciesList.get(speciesIndex);
            this.speciesIds.add(species.getId());
            this.illegalSpecies[speciesIndex] = species.isSetByRule(model) || species.isSetByEvent(model);
        }
        for (int reactionIndex = 0; reactionIndex < reactionCount; ++reactionIndex) {
            Reaction reaction = (Reaction)reactions.get(reactionIndex);
            if (reaction == null) continue;
            try {
                Iterator productIterator = reaction.getProduct().iterator();
                while (productIterator.hasNext()) {
                    this.addSpeciesStoichiometry(model, speciesList, reactionIndex, (SpeciesReference)productIterator.next(), true);
                }
                Iterator reactantIterator = reaction.getReactant().iterator();
                while (reactantIterator.hasNext()) {
                    this.addSpeciesStoichiometry(model, speciesList, reactionIndex, (SpeciesReference)reactantIterator.next(), false);
                }
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Reaction " + reaction.getName() + e.getMessage());
            }
        }
    }

    static {
        $assertionsDisabled = !ConservationRelationFinder.class.desiredAssertionStatus();
    }

    public static final class ConservationRelation {
        private final String dependentSpeciesId;
        private final Map conservationRelation;

        public ConservationRelation(Map conservationRelation, String dependentSpeciesId) {
            if (conservationRelation == null || dependentSpeciesId == null) {
                throw new IllegalArgumentException();
            }
            if (!conservationRelation.containsKey(dependentSpeciesId)) {
                throw new IllegalArgumentException("Dependent species must be included in the conservation relation.");
            }
            Iterator iterator = conservationRelation.keySet().iterator();
            while (iterator.hasNext()) {
                String speciesId = (String)iterator.next();
                Double value = (Double)conservationRelation.get(speciesId);
                if (!value.isNaN() && !value.isInfinite() && value != 0.0) continue;
                throw new IllegalArgumentException("Coefficient for species " + speciesId + " is illegal.");
            }
            this.conservationRelation = Collections.unmodifiableMap(new TreeMap(conservationRelation));
            this.dependentSpeciesId = dependentSpeciesId;
        }

        public Map getConservationRelation() {
            return this.conservationRelation;
        }

        public String getDependentSpeciesId() {
            return this.dependentSpeciesId;
        }

        public String toString() {
            return "(" + this.dependentSpeciesId + ")" + this.conservationRelation.toString();
        }
    }
}

