/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jigcell.sbml2.EventAssignment;
import jigcell.sbml2.Model;
import jigcell.sbml2.SBase;
import jigcell.sbml2.SBaseId;
import jigcell.sbml2.UnitDefinition;
import jigcell.sbml2.XMLPrinter;
import org.xml.sax.Attributes;

public final class Event
extends SBaseId {
    private final List eventAssignment;
    private final SBase assignmentsElement = new SBase();
    private final SBase delayElement = new SBase();
    private final SBase triggerElement = new SBase();
    private String delay;
    private String timeUnits;
    private String trigger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Event() {
        this(null, null);
    }

    public Event(Event event) {
        this(event.getId(), event.isNameSet() ? event.getName() : null);
        this.setDelay(event.getDelay());
        this.setTimeUnits(event.getTimeUnits());
        this.setTrigger(event.getTrigger());
        Iterator iterator = event.getEventAssignment().iterator();
        while (iterator.hasNext()) {
            EventAssignment assignment = (EventAssignment)iterator.next();
            if (assignment == null) continue;
            this.addEventAssignment(new EventAssignment(assignment));
        }
    }

    public Event(String id, String name) {
        super(id, name);
        this.eventAssignment = new ArrayList();
        this.setDelay(null);
    }

    public void addEventAssignment(EventAssignment assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException();
        }
        this.eventAssignment.add(assignment);
    }

    public SBase getAssignmentsElement() {
        return this.assignmentsElement;
    }

    public String getDelay() {
        return this.delay;
    }

    public SBase getDelayElement() {
        return this.delayElement;
    }

    public List getEventAssignment() {
        return this.eventAssignment;
    }

    public String getTimeUnits() {
        return this.timeUnits == null ? "time" : this.timeUnits;
    }

    public UnitDefinition getTimeUnits(Model model) {
        return (UnitDefinition)model.findElementWithId(this.getTimeUnits(), 64);
    }

    public String getTrigger() {
        return this.trigger;
    }

    public SBase getTriggerElement() {
        return this.triggerElement;
    }

    public boolean isValid(Model model) {
        return super.isValid(model) && UnitDefinition.isValidTimeUnit(this.getTimeUnits(model));
    }

    public void setDelay(String delay) {
        if (delay == null) {
            delay = "<math:math><math:cn>0</math:cn></math:math>";
        }
        if (!$assertionsDisabled && !delay.startsWith("<math:math>")) {
            throw new AssertionError();
        }
        this.delay = delay;
    }

    public void setTimeUnits(String timeUnits) {
        if (timeUnits != null && !Event.isValidId(timeUnits)) {
            throw new IllegalArgumentException("Invalid SBML identifier.");
        }
        this.timeUnits = timeUnits;
    }

    public void setTimeUnits(UnitDefinition units) {
        this.setTimeUnits(units == null ? null : units.getId());
    }

    public void setTrigger(String trigger) {
        if (!$assertionsDisabled && trigger != null && !trigger.startsWith("<math:math>")) {
            throw new AssertionError();
        }
        this.trigger = trigger;
    }

    protected void parse(Attributes attributes) {
        super.parse(attributes);
        this.setTimeUnits(attributes.getValue("timeUnits"));
    }

    protected XMLPrinter print(XMLPrinter parent) {
        return this.print(parent, "event");
    }

    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        if (!this.getTimeUnits().equals("time")) {
            printer.addAttribute("timeUnits", this.getTimeUnits());
        }
        printer.addCustomElement(this.getTriggerElement(), "trigger", this.getTrigger());
        printer.addCustomElement(this.getDelayElement(), "delay", this.getDelay());
        printer.addElementList(this.getAssignmentsElement(), "listOfEventAssignments", this.getEventAssignment());
        return printer;
    }

    static {
        $assertionsDisabled = !Event.class.desiredAssertionStatus();
    }
}

